/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import android.net.Uri;
import android.util.Base64;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.source.UnrecognizedInputFormatException;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HlsPlaylistParser
implements ParsingLoadable.Parser<HlsPlaylist> {
    private static final String PLAYLIST_HEADER = "#EXTM3U";
    private static final String TAG_PREFIX = "#EXT";
    private static final String TAG_VERSION = "#EXT-X-VERSION";
    private static final String TAG_PLAYLIST_TYPE = "#EXT-X-PLAYLIST-TYPE";
    private static final String TAG_STREAM_INF = "#EXT-X-STREAM-INF";
    private static final String TAG_MEDIA = "#EXT-X-MEDIA";
    private static final String TAG_TARGET_DURATION = "#EXT-X-TARGETDURATION";
    private static final String TAG_DISCONTINUITY = "#EXT-X-DISCONTINUITY";
    private static final String TAG_DISCONTINUITY_SEQUENCE = "#EXT-X-DISCONTINUITY-SEQUENCE";
    private static final String TAG_PROGRAM_DATE_TIME = "#EXT-X-PROGRAM-DATE-TIME";
    private static final String TAG_INIT_SEGMENT = "#EXT-X-MAP";
    private static final String TAG_INDEPENDENT_SEGMENTS = "#EXT-X-INDEPENDENT-SEGMENTS";
    private static final String TAG_MEDIA_DURATION = "#EXTINF";
    private static final String TAG_MEDIA_SEQUENCE = "#EXT-X-MEDIA-SEQUENCE";
    private static final String TAG_START = "#EXT-X-START";
    private static final String TAG_ENDLIST = "#EXT-X-ENDLIST";
    private static final String TAG_KEY = "#EXT-X-KEY";
    private static final String TAG_BYTERANGE = "#EXT-X-BYTERANGE";
    private static final String TAG_GAP = "#EXT-X-GAP";
    private static final String TYPE_AUDIO = "AUDIO";
    private static final String TYPE_VIDEO = "VIDEO";
    private static final String TYPE_SUBTITLES = "SUBTITLES";
    private static final String TYPE_CLOSED_CAPTIONS = "CLOSED-CAPTIONS";
    private static final String METHOD_NONE = "NONE";
    private static final String METHOD_AES_128 = "AES-128";
    private static final String METHOD_SAMPLE_AES = "SAMPLE-AES";
    private static final String METHOD_SAMPLE_AES_CENC = "SAMPLE-AES-CENC";
    private static final String METHOD_SAMPLE_AES_CTR = "SAMPLE-AES-CTR";
    private static final String KEYFORMAT_IDENTITY = "identity";
    private static final String KEYFORMAT_WIDEVINE_PSSH_BINARY = "urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed";
    private static final String KEYFORMAT_WIDEVINE_PSSH_JSON = "com.widevine";
    private static final String BOOLEAN_TRUE = "YES";
    private static final String BOOLEAN_FALSE = "NO";
    private static final String ATTR_CLOSED_CAPTIONS_NONE = "CLOSED-CAPTIONS=NONE";
    private static final Pattern REGEX_AVERAGE_BANDWIDTH = Pattern.compile("AVERAGE-BANDWIDTH=(\\d+)\\b");
    private static final Pattern REGEX_AUDIO = Pattern.compile("AUDIO=\"(.+?)\"");
    private static final Pattern REGEX_BANDWIDTH = Pattern.compile("[^-]BANDWIDTH=(\\d+)\\b");
    private static final Pattern REGEX_CODECS = Pattern.compile("CODECS=\"(.+?)\"");
    private static final Pattern REGEX_RESOLUTION = Pattern.compile("RESOLUTION=(\\d+x\\d+)");
    private static final Pattern REGEX_FRAME_RATE = Pattern.compile("FRAME-RATE=([\\d\\.]+)\\b");
    private static final Pattern REGEX_TARGET_DURATION = Pattern.compile("#EXT-X-TARGETDURATION:(\\d+)\\b");
    private static final Pattern REGEX_VERSION = Pattern.compile("#EXT-X-VERSION:(\\d+)\\b");
    private static final Pattern REGEX_PLAYLIST_TYPE = Pattern.compile("#EXT-X-PLAYLIST-TYPE:(.+)\\b");
    private static final Pattern REGEX_MEDIA_SEQUENCE = Pattern.compile("#EXT-X-MEDIA-SEQUENCE:(\\d+)\\b");
    private static final Pattern REGEX_MEDIA_DURATION = Pattern.compile("#EXTINF:([\\d\\.]+)\\b");
    private static final Pattern REGEX_TIME_OFFSET = Pattern.compile("TIME-OFFSET=(-?[\\d\\.]+)\\b");
    private static final Pattern REGEX_BYTERANGE = Pattern.compile("#EXT-X-BYTERANGE:(\\d+(?:@\\d+)?)\\b");
    private static final Pattern REGEX_ATTR_BYTERANGE = Pattern.compile("BYTERANGE=\"(\\d+(?:@\\d+)?)\\b\"");
    private static final Pattern REGEX_METHOD = Pattern.compile("METHOD=(NONE|AES-128|SAMPLE-AES|SAMPLE-AES-CENC|SAMPLE-AES-CTR)\\s*(,|$)");
    private static final Pattern REGEX_KEYFORMAT = Pattern.compile("KEYFORMAT=\"(.+?)\"");
    private static final Pattern REGEX_URI = Pattern.compile("URI=\"(.+?)\"");
    private static final Pattern REGEX_IV = Pattern.compile("IV=([^,.*]+)");
    private static final Pattern REGEX_TYPE = Pattern.compile("TYPE=(AUDIO|VIDEO|SUBTITLES|CLOSED-CAPTIONS)");
    private static final Pattern REGEX_LANGUAGE = Pattern.compile("LANGUAGE=\"(.+?)\"");
    private static final Pattern REGEX_NAME = Pattern.compile("NAME=\"(.+?)\"");
    private static final Pattern REGEX_GROUP_ID = Pattern.compile("GROUP-ID=\"(.+?)\"");
    private static final Pattern REGEX_INSTREAM_ID = Pattern.compile("INSTREAM-ID=\"((?:CC|SERVICE)\\d+)\"");
    private static final Pattern REGEX_AUTOSELECT = HlsPlaylistParser.compileBooleanAttrPattern("AUTOSELECT");
    private static final Pattern REGEX_DEFAULT = HlsPlaylistParser.compileBooleanAttrPattern("DEFAULT");
    private static final Pattern REGEX_FORCED = HlsPlaylistParser.compileBooleanAttrPattern("FORCED");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HlsPlaylist parse(Uri uri, InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayDeque<String> extraLines = new ArrayDeque<String>();
        try {
            String line;
            if (!HlsPlaylistParser.checkPlaylistHeader(reader)) {
                throw new UnrecognizedInputFormatException("Input does not start with the #EXTM3U header.", uri);
            }
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith(TAG_STREAM_INF)) {
                    extraLines.add(line);
                    HlsMasterPlaylist hlsMasterPlaylist = HlsPlaylistParser.parseMasterPlaylist(new LineIterator(extraLines, reader), uri.toString());
                    return hlsMasterPlaylist;
                }
                if (line.startsWith(TAG_TARGET_DURATION) || line.startsWith(TAG_MEDIA_SEQUENCE) || line.startsWith(TAG_MEDIA_DURATION) || line.startsWith(TAG_KEY) || line.startsWith(TAG_BYTERANGE) || line.equals(TAG_DISCONTINUITY) || line.equals(TAG_DISCONTINUITY_SEQUENCE) || line.equals(TAG_ENDLIST)) {
                    extraLines.add(line);
                    HlsMediaPlaylist hlsMediaPlaylist = HlsPlaylistParser.parseMediaPlaylist(new LineIterator(extraLines, reader), uri.toString());
                    return hlsMediaPlaylist;
                }
                extraLines.add(line);
            }
        }
        finally {
            Util.closeQuietly((Closeable)reader);
        }
        throw new ParserException("Failed to parse the playlist, could not identify any tags.");
    }

    private static boolean checkPlaylistHeader(BufferedReader reader) throws IOException {
        int last = reader.read();
        if (last == 239) {
            if (reader.read() != 187 || reader.read() != 191) {
                return false;
            }
            last = reader.read();
        }
        last = HlsPlaylistParser.skipIgnorableWhitespace(reader, true, last);
        int playlistHeaderLength = PLAYLIST_HEADER.length();
        for (int i = 0; i < playlistHeaderLength; ++i) {
            if (last != PLAYLIST_HEADER.charAt(i)) {
                return false;
            }
            last = reader.read();
        }
        last = HlsPlaylistParser.skipIgnorableWhitespace(reader, false, last);
        return Util.isLinebreak((int)last);
    }

    private static int skipIgnorableWhitespace(BufferedReader reader, boolean skipLinebreaks, int c) throws IOException {
        while (c != -1 && Character.isWhitespace(c) && (skipLinebreaks || !Util.isLinebreak((int)c))) {
            c = reader.read();
        }
        return c;
    }

    private static HlsMasterPlaylist parseMasterPlaylist(LineIterator iterator, String baseUri) throws IOException {
        String line;
        HashSet<String> variantUrls = new HashSet<String>();
        HashMap<String, String> audioGroupIdToCodecs = new HashMap<String, String>();
        ArrayList<HlsMasterPlaylist.HlsUrl> variants = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        ArrayList<HlsMasterPlaylist.HlsUrl> audios = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        ArrayList<HlsMasterPlaylist.HlsUrl> subtitles = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        ArrayList<String> mediaTags = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        Format muxedAudioFormat = null;
        List<Format> muxedCaptionFormats = null;
        boolean noClosedCaptions = false;
        while (iterator.hasNext()) {
            String audioGroupId;
            int height;
            int width;
            line = iterator.next();
            if (line.startsWith(TAG_PREFIX)) {
                tags.add(line);
            }
            if (line.startsWith(TAG_MEDIA)) {
                mediaTags.add(line);
                continue;
            }
            if (!line.startsWith(TAG_STREAM_INF)) continue;
            noClosedCaptions |= line.contains(ATTR_CLOSED_CAPTIONS_NONE);
            int bitrate = HlsPlaylistParser.parseIntAttr(line, REGEX_BANDWIDTH);
            String averageBandwidthString = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_AVERAGE_BANDWIDTH);
            if (averageBandwidthString != null) {
                bitrate = Integer.parseInt(averageBandwidthString);
            }
            String codecs = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_CODECS);
            String resolutionString = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_RESOLUTION);
            if (resolutionString != null) {
                String[] widthAndHeight = resolutionString.split("x");
                width = Integer.parseInt(widthAndHeight[0]);
                height = Integer.parseInt(widthAndHeight[1]);
                if (width <= 0 || height <= 0) {
                    width = -1;
                    height = -1;
                }
            } else {
                width = -1;
                height = -1;
            }
            float frameRate = -1.0f;
            String frameRateString = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_FRAME_RATE);
            if (frameRateString != null) {
                frameRate = Float.parseFloat(frameRateString);
            }
            if ((audioGroupId = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_AUDIO)) != null && codecs != null) {
                audioGroupIdToCodecs.put(audioGroupId, Util.getCodecsOfType((String)codecs, (int)1));
            }
            if (!variantUrls.add(line = iterator.next())) continue;
            Format format = Format.createVideoContainerFormat((String)Integer.toString(variants.size()), (String)"application/x-mpegURL", null, (String)codecs, (int)bitrate, (int)width, (int)height, (float)frameRate, null, (int)0);
            variants.add(new HlsMasterPlaylist.HlsUrl(line, format));
        }
        block11: for (int i = 0; i < mediaTags.size(); ++i) {
            line = (String)mediaTags.get(i);
            int selectionFlags = HlsPlaylistParser.parseSelectionFlags(line);
            String uri = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_URI);
            String id = HlsPlaylistParser.parseStringAttr(line, REGEX_NAME);
            String language = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_LANGUAGE);
            String groupId = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_GROUP_ID);
            switch (HlsPlaylistParser.parseStringAttr(line, REGEX_TYPE)) {
                case "AUDIO": {
                    String codecs = (String)audioGroupIdToCodecs.get(groupId);
                    String sampleMimeType = codecs != null ? MimeTypes.getMediaMimeType((String)codecs) : null;
                    Format format = Format.createAudioContainerFormat((String)id, (String)"application/x-mpegURL", (String)sampleMimeType, (String)codecs, (int)-1, (int)-1, (int)-1, null, (int)selectionFlags, (String)language);
                    if (uri == null) {
                        muxedAudioFormat = format;
                        continue block11;
                    }
                    audios.add(new HlsMasterPlaylist.HlsUrl(uri, format));
                    continue block11;
                }
                case "SUBTITLES": {
                    Format format = Format.createTextContainerFormat((String)id, (String)"application/x-mpegURL", (String)"text/vtt", null, (int)-1, (int)selectionFlags, (String)language);
                    subtitles.add(new HlsMasterPlaylist.HlsUrl(uri, format));
                    continue block11;
                }
                case "CLOSED-CAPTIONS": {
                    int accessibilityChannel;
                    String mimeType;
                    String instreamId = HlsPlaylistParser.parseStringAttr(line, REGEX_INSTREAM_ID);
                    if (instreamId.startsWith("CC")) {
                        mimeType = "application/cea-608";
                        accessibilityChannel = Integer.parseInt(instreamId.substring(2));
                    } else {
                        mimeType = "application/cea-708";
                        accessibilityChannel = Integer.parseInt(instreamId.substring(7));
                    }
                    if (muxedCaptionFormats == null) {
                        muxedCaptionFormats = new ArrayList<Format>();
                    }
                    muxedCaptionFormats.add(Format.createTextContainerFormat((String)id, null, (String)mimeType, null, (int)-1, (int)selectionFlags, (String)language, (int)accessibilityChannel));
                    continue block11;
                }
            }
        }
        if (noClosedCaptions) {
            muxedCaptionFormats = Collections.emptyList();
        }
        return new HlsMasterPlaylist(baseUri, tags, variants, audios, subtitles, muxedAudioFormat, muxedCaptionFormats);
    }

    private static int parseSelectionFlags(String line) {
        return (HlsPlaylistParser.parseBooleanAttribute(line, REGEX_DEFAULT, false) ? 1 : 0) | (HlsPlaylistParser.parseBooleanAttribute(line, REGEX_FORCED, false) ? 2 : 0) | (HlsPlaylistParser.parseBooleanAttribute(line, REGEX_AUTOSELECT, false) ? 4 : 0);
    }

    private static HlsMediaPlaylist parseMediaPlaylist(LineIterator iterator, String baseUri) throws IOException {
        int playlistType = 0;
        long startOffsetUs = -9223372036854775807L;
        long mediaSequence = 0L;
        int version = 1;
        long targetDurationUs = -9223372036854775807L;
        boolean hasIndependentSegmentsTag = false;
        boolean hasEndTag = false;
        HlsMediaPlaylist.Segment initializationSegment = null;
        ArrayList<HlsMediaPlaylist.Segment> segments = new ArrayList<HlsMediaPlaylist.Segment>();
        ArrayList<String> tags = new ArrayList<String>();
        long segmentDurationUs = 0L;
        boolean hasDiscontinuitySequence = false;
        int playlistDiscontinuitySequence = 0;
        int relativeDiscontinuitySequence = 0;
        long playlistStartTimeUs = 0L;
        long segmentStartTimeUs = 0L;
        long segmentByteRangeOffset = 0L;
        long segmentByteRangeLength = -1L;
        long segmentMediaSequence = 0L;
        boolean hasGapTag = false;
        String encryptionKeyUri = null;
        String encryptionIV = null;
        DrmInitData drmInitData = null;
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (line.startsWith(TAG_PREFIX)) {
                tags.add(line);
            }
            if (line.startsWith(TAG_PLAYLIST_TYPE)) {
                String playlistTypeString = HlsPlaylistParser.parseStringAttr(line, REGEX_PLAYLIST_TYPE);
                if ("VOD".equals(playlistTypeString)) {
                    playlistType = 1;
                    continue;
                }
                if (!"EVENT".equals(playlistTypeString)) continue;
                playlistType = 2;
                continue;
            }
            if (line.startsWith(TAG_START)) {
                startOffsetUs = (long)(HlsPlaylistParser.parseDoubleAttr(line, REGEX_TIME_OFFSET) * 1000000.0);
                continue;
            }
            if (line.startsWith(TAG_INIT_SEGMENT)) {
                String uri = HlsPlaylistParser.parseStringAttr(line, REGEX_URI);
                String byteRange = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_ATTR_BYTERANGE);
                if (byteRange != null) {
                    String[] splitByteRange = byteRange.split("@");
                    segmentByteRangeLength = Long.parseLong(splitByteRange[0]);
                    if (splitByteRange.length > 1) {
                        segmentByteRangeOffset = Long.parseLong(splitByteRange[1]);
                    }
                }
                initializationSegment = new HlsMediaPlaylist.Segment(uri, segmentByteRangeOffset, segmentByteRangeLength);
                segmentByteRangeOffset = 0L;
                segmentByteRangeLength = -1L;
                continue;
            }
            if (line.startsWith(TAG_TARGET_DURATION)) {
                targetDurationUs = (long)HlsPlaylistParser.parseIntAttr(line, REGEX_TARGET_DURATION) * 1000000L;
                continue;
            }
            if (line.startsWith(TAG_MEDIA_SEQUENCE)) {
                segmentMediaSequence = mediaSequence = HlsPlaylistParser.parseLongAttr(line, REGEX_MEDIA_SEQUENCE);
                continue;
            }
            if (line.startsWith(TAG_VERSION)) {
                version = HlsPlaylistParser.parseIntAttr(line, REGEX_VERSION);
                continue;
            }
            if (line.startsWith(TAG_MEDIA_DURATION)) {
                segmentDurationUs = (long)(HlsPlaylistParser.parseDoubleAttr(line, REGEX_MEDIA_DURATION) * 1000000.0);
                continue;
            }
            if (line.startsWith(TAG_KEY)) {
                DrmInitData.SchemeData schemeData;
                String method = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_METHOD);
                String keyFormat = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_KEYFORMAT);
                encryptionKeyUri = null;
                encryptionIV = null;
                if (METHOD_NONE.equals(method)) continue;
                encryptionIV = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_IV);
                if (KEYFORMAT_IDENTITY.equals(keyFormat) || keyFormat == null) {
                    if (!METHOD_AES_128.equals(method)) continue;
                    encryptionKeyUri = HlsPlaylistParser.parseStringAttr(line, REGEX_URI);
                    continue;
                }
                if (method == null || (schemeData = HlsPlaylistParser.parseWidevineSchemeData(line, keyFormat)) == null) continue;
                drmInitData = new DrmInitData(METHOD_SAMPLE_AES_CENC.equals(method) || METHOD_SAMPLE_AES_CTR.equals(method) ? "cenc" : "cbcs", new DrmInitData.SchemeData[]{schemeData});
                continue;
            }
            if (line.startsWith(TAG_BYTERANGE)) {
                String byteRange = HlsPlaylistParser.parseStringAttr(line, REGEX_BYTERANGE);
                String[] splitByteRange = byteRange.split("@");
                segmentByteRangeLength = Long.parseLong(splitByteRange[0]);
                if (splitByteRange.length <= 1) continue;
                segmentByteRangeOffset = Long.parseLong(splitByteRange[1]);
                continue;
            }
            if (line.startsWith(TAG_DISCONTINUITY_SEQUENCE)) {
                hasDiscontinuitySequence = true;
                playlistDiscontinuitySequence = Integer.parseInt(line.substring(line.indexOf(58) + 1));
                continue;
            }
            if (line.equals(TAG_DISCONTINUITY)) {
                ++relativeDiscontinuitySequence;
                continue;
            }
            if (line.startsWith(TAG_PROGRAM_DATE_TIME)) {
                if (playlistStartTimeUs != 0L) continue;
                long programDatetimeUs = C.msToUs((long)Util.parseXsDateTime((String)line.substring(line.indexOf(58) + 1)));
                playlistStartTimeUs = programDatetimeUs - segmentStartTimeUs;
                continue;
            }
            if (line.equals(TAG_GAP)) {
                hasGapTag = true;
                continue;
            }
            if (line.equals(TAG_INDEPENDENT_SEGMENTS)) {
                hasIndependentSegmentsTag = true;
                continue;
            }
            if (line.equals(TAG_ENDLIST)) {
                hasEndTag = true;
                continue;
            }
            if (line.startsWith("#")) continue;
            String segmentEncryptionIV = encryptionKeyUri == null ? null : (encryptionIV != null ? encryptionIV : Long.toHexString(segmentMediaSequence));
            ++segmentMediaSequence;
            if (segmentByteRangeLength == -1L) {
                segmentByteRangeOffset = 0L;
            }
            segments.add(new HlsMediaPlaylist.Segment(line, initializationSegment, segmentDurationUs, relativeDiscontinuitySequence, segmentStartTimeUs, encryptionKeyUri, segmentEncryptionIV, segmentByteRangeOffset, segmentByteRangeLength, hasGapTag));
            segmentStartTimeUs += segmentDurationUs;
            segmentDurationUs = 0L;
            if (segmentByteRangeLength != -1L) {
                segmentByteRangeOffset += segmentByteRangeLength;
            }
            segmentByteRangeLength = -1L;
            hasGapTag = false;
        }
        return new HlsMediaPlaylist(playlistType, baseUri, tags, startOffsetUs, playlistStartTimeUs, hasDiscontinuitySequence, playlistDiscontinuitySequence, mediaSequence, version, targetDurationUs, hasIndependentSegmentsTag, hasEndTag, playlistStartTimeUs != 0L, drmInitData, segments);
    }

    private static DrmInitData.SchemeData parseWidevineSchemeData(String line, String keyFormat) throws ParserException {
        if (KEYFORMAT_WIDEVINE_PSSH_BINARY.equals(keyFormat)) {
            String uriString = HlsPlaylistParser.parseStringAttr(line, REGEX_URI);
            return new DrmInitData.SchemeData(C.WIDEVINE_UUID, "video/mp4", Base64.decode((String)uriString.substring(uriString.indexOf(44)), (int)0));
        }
        if (KEYFORMAT_WIDEVINE_PSSH_JSON.equals(keyFormat)) {
            try {
                return new DrmInitData.SchemeData(C.WIDEVINE_UUID, "hls", line.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new ParserException((Throwable)e);
            }
        }
        return null;
    }

    private static int parseIntAttr(String line, Pattern pattern) throws ParserException {
        return Integer.parseInt(HlsPlaylistParser.parseStringAttr(line, pattern));
    }

    private static long parseLongAttr(String line, Pattern pattern) throws ParserException {
        return Long.parseLong(HlsPlaylistParser.parseStringAttr(line, pattern));
    }

    private static double parseDoubleAttr(String line, Pattern pattern) throws ParserException {
        return Double.parseDouble(HlsPlaylistParser.parseStringAttr(line, pattern));
    }

    private static String parseOptionalStringAttr(String line, Pattern pattern) {
        Matcher matcher = pattern.matcher(line);
        return matcher.find() ? matcher.group(1) : null;
    }

    private static String parseStringAttr(String line, Pattern pattern) throws ParserException {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        throw new ParserException("Couldn't match " + pattern.pattern() + " in " + line);
    }

    private static boolean parseBooleanAttribute(String line, Pattern pattern, boolean defaultValue) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1).equals(BOOLEAN_TRUE);
        }
        return defaultValue;
    }

    private static Pattern compileBooleanAttrPattern(String attribute) {
        return Pattern.compile(attribute + "=(" + BOOLEAN_FALSE + "|" + BOOLEAN_TRUE + ")");
    }

    private static class LineIterator {
        private final BufferedReader reader;
        private final Queue<String> extraLines;
        private String next;

        public LineIterator(Queue<String> extraLines, BufferedReader reader) {
            this.extraLines = extraLines;
            this.reader = reader;
        }

        public boolean hasNext() throws IOException {
            if (this.next != null) {
                return true;
            }
            if (!this.extraLines.isEmpty()) {
                this.next = this.extraLines.poll();
                return true;
            }
            while ((this.next = this.reader.readLine()) != null) {
                this.next = this.next.trim();
                if (this.next.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public String next() throws IOException {
            String result = null;
            if (this.hasNext()) {
                result = this.next;
                this.next = null;
            }
            return result;
        }
    }
}

