/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.DefaultCompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceDrmHelper;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.hls.DefaultHlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsManifest;
import com.google.android.exoplayer2.source.hls.HlsMediaPeriod;
import com.google.android.exoplayer2.source.hls.playlist.DefaultHlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.DefaultHlsPlaylistTracker;
import com.google.android.exoplayer2.source.hls.playlist.FilteringHlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultLoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;

public final class HlsMediaSource
extends BaseMediaSource
implements HlsPlaylistTracker.PrimaryPlaylistListener {
    public static final int METADATA_TYPE_ID3 = 1;
    public static final int METADATA_TYPE_EMSG = 3;
    private final HlsExtractorFactory extractorFactory;
    private final MediaItem mediaItem;
    private final MediaItem.PlaybackProperties playbackProperties;
    private final HlsDataSourceFactory dataSourceFactory;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final DrmSessionManager drmSessionManager;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final boolean allowChunklessPreparation;
    private final int metadataType;
    private final boolean useSessionKeys;
    private final HlsPlaylistTracker playlistTracker;
    @Nullable
    private TransferListener mediaTransferListener;

    private HlsMediaSource(MediaItem mediaItem, HlsDataSourceFactory dataSourceFactory, HlsExtractorFactory extractorFactory, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, DrmSessionManager drmSessionManager, LoadErrorHandlingPolicy loadErrorHandlingPolicy, HlsPlaylistTracker playlistTracker, boolean allowChunklessPreparation, int metadataType, boolean useSessionKeys) {
        this.playbackProperties = (MediaItem.PlaybackProperties)Assertions.checkNotNull((Object)mediaItem.playbackProperties);
        this.mediaItem = mediaItem;
        this.dataSourceFactory = dataSourceFactory;
        this.extractorFactory = extractorFactory;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.drmSessionManager = drmSessionManager;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.playlistTracker = playlistTracker;
        this.allowChunklessPreparation = allowChunklessPreparation;
        this.metadataType = metadataType;
        this.useSessionKeys = useSessionKeys;
    }

    @Deprecated
    @Nullable
    public Object getTag() {
        return this.playbackProperties.tag;
    }

    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.mediaTransferListener = mediaTransferListener;
        this.drmSessionManager.prepare();
        MediaSourceEventListener.EventDispatcher eventDispatcher = this.createEventDispatcher(null);
        this.playlistTracker.start(this.playbackProperties.uri, eventDispatcher, this);
    }

    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.playlistTracker.maybeThrowPrimaryPlaylistRefreshError();
    }

    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher = this.createEventDispatcher(id);
        DrmSessionEventListener.EventDispatcher drmEventDispatcher = this.createDrmEventDispatcher(id);
        return new HlsMediaPeriod(this.extractorFactory, this.playlistTracker, this.dataSourceFactory, this.mediaTransferListener, this.drmSessionManager, drmEventDispatcher, this.loadErrorHandlingPolicy, mediaSourceEventDispatcher, allocator, this.compositeSequenceableLoaderFactory, this.allowChunklessPreparation, this.metadataType, this.useSessionKeys);
    }

    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((HlsMediaPeriod)mediaPeriod).release();
    }

    protected void releaseSourceInternal() {
        this.playlistTracker.stop();
        this.drmSessionManager.release();
    }

    @Override
    public void onPrimaryPlaylistRefreshed(HlsMediaPlaylist playlist) {
        SinglePeriodTimeline timeline;
        long windowStartTimeMs = playlist.hasProgramDateTime ? C.usToMs((long)playlist.startTimeUs) : -9223372036854775807L;
        long presentationStartTimeMs = playlist.playlistType == 2 || playlist.playlistType == 1 ? windowStartTimeMs : -9223372036854775807L;
        long windowDefaultStartPositionUs = playlist.startOffsetUs;
        HlsManifest manifest = new HlsManifest((HlsMasterPlaylist)Assertions.checkNotNull((Object)this.playlistTracker.getMasterPlaylist()), playlist);
        if (this.playlistTracker.isLive()) {
            long offsetFromInitialStartTimeUs = playlist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
            long periodDurationUs = playlist.hasEndTag ? offsetFromInitialStartTimeUs + playlist.durationUs : -9223372036854775807L;
            List<HlsMediaPlaylist.Segment> segments = playlist.segments;
            if (windowDefaultStartPositionUs == -9223372036854775807L) {
                windowDefaultStartPositionUs = 0L;
                if (!segments.isEmpty()) {
                    int defaultStartSegmentIndex;
                    long minStartPositionUs = playlist.durationUs - playlist.targetDurationUs * 2L;
                    for (defaultStartSegmentIndex = Math.max(0, segments.size() - 3); defaultStartSegmentIndex > 0 && segments.get((int)defaultStartSegmentIndex).relativeStartTimeUs > minStartPositionUs; --defaultStartSegmentIndex) {
                    }
                    windowDefaultStartPositionUs = segments.get((int)defaultStartSegmentIndex).relativeStartTimeUs;
                }
            }
            timeline = new SinglePeriodTimeline(presentationStartTimeMs, windowStartTimeMs, -9223372036854775807L, periodDurationUs, playlist.durationUs, offsetFromInitialStartTimeUs, windowDefaultStartPositionUs, true, !playlist.hasEndTag, true, (Object)manifest, this.mediaItem);
        } else {
            if (windowDefaultStartPositionUs == -9223372036854775807L) {
                windowDefaultStartPositionUs = 0L;
            }
            timeline = new SinglePeriodTimeline(presentationStartTimeMs, windowStartTimeMs, -9223372036854775807L, playlist.durationUs, playlist.durationUs, 0L, windowDefaultStartPositionUs, true, false, false, (Object)manifest, this.mediaItem);
        }
        this.refreshSourceInfo((Timeline)timeline);
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.hls");
    }

    public static final class Factory
    implements MediaSourceFactory {
        private final HlsDataSourceFactory hlsDataSourceFactory;
        private final MediaSourceDrmHelper mediaSourceDrmHelper;
        private HlsExtractorFactory extractorFactory;
        private HlsPlaylistParserFactory playlistParserFactory;
        private HlsPlaylistTracker.Factory playlistTrackerFactory;
        private CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
        @Nullable
        private DrmSessionManager drmSessionManager;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private boolean allowChunklessPreparation;
        private int metadataType;
        private boolean useSessionKeys;
        private List<StreamKey> streamKeys;
        @Nullable
        private Object tag;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(new DefaultHlsDataSourceFactory(dataSourceFactory));
        }

        public Factory(HlsDataSourceFactory hlsDataSourceFactory) {
            this.hlsDataSourceFactory = (HlsDataSourceFactory)Assertions.checkNotNull((Object)hlsDataSourceFactory);
            this.mediaSourceDrmHelper = new MediaSourceDrmHelper();
            this.playlistParserFactory = new DefaultHlsPlaylistParserFactory();
            this.playlistTrackerFactory = DefaultHlsPlaylistTracker.FACTORY;
            this.extractorFactory = HlsExtractorFactory.DEFAULT;
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
            this.compositeSequenceableLoaderFactory = new DefaultCompositeSequenceableLoaderFactory();
            this.metadataType = 1;
            this.streamKeys = Collections.emptyList();
        }

        @Deprecated
        public Factory setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        public Factory setExtractorFactory(@Nullable HlsExtractorFactory extractorFactory) {
            this.extractorFactory = extractorFactory != null ? extractorFactory : HlsExtractorFactory.DEFAULT;
            return this;
        }

        public Factory setLoadErrorHandlingPolicy(@Nullable LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy != null ? loadErrorHandlingPolicy : new DefaultLoadErrorHandlingPolicy();
            return this;
        }

        @Deprecated
        public Factory setMinLoadableRetryCount(int minLoadableRetryCount) {
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy(minLoadableRetryCount);
            return this;
        }

        public Factory setPlaylistParserFactory(@Nullable HlsPlaylistParserFactory playlistParserFactory) {
            this.playlistParserFactory = playlistParserFactory != null ? playlistParserFactory : new DefaultHlsPlaylistParserFactory();
            return this;
        }

        public Factory setPlaylistTrackerFactory(@Nullable HlsPlaylistTracker.Factory playlistTrackerFactory) {
            this.playlistTrackerFactory = playlistTrackerFactory != null ? playlistTrackerFactory : DefaultHlsPlaylistTracker.FACTORY;
            return this;
        }

        public Factory setCompositeSequenceableLoaderFactory(@Nullable CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory) {
            this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory != null ? compositeSequenceableLoaderFactory : new DefaultCompositeSequenceableLoaderFactory();
            return this;
        }

        public Factory setAllowChunklessPreparation(boolean allowChunklessPreparation) {
            this.allowChunklessPreparation = allowChunklessPreparation;
            return this;
        }

        public Factory setMetadataType(int metadataType) {
            this.metadataType = metadataType;
            return this;
        }

        public Factory setUseSessionKeys(boolean useSessionKeys) {
            this.useSessionKeys = useSessionKeys;
            return this;
        }

        public Factory setDrmSessionManager(@Nullable DrmSessionManager drmSessionManager) {
            this.drmSessionManager = drmSessionManager;
            return this;
        }

        public Factory setDrmHttpDataSourceFactory(@Nullable HttpDataSource.Factory drmHttpDataSourceFactory) {
            this.mediaSourceDrmHelper.setDrmHttpDataSourceFactory(drmHttpDataSourceFactory);
            return this;
        }

        public MediaSourceFactory setDrmUserAgent(@Nullable String userAgent) {
            this.mediaSourceDrmHelper.setDrmUserAgent(userAgent);
            return this;
        }

        @Deprecated
        public Factory setStreamKeys(@Nullable List<StreamKey> streamKeys) {
            this.streamKeys = streamKeys != null ? streamKeys : Collections.emptyList();
            return this;
        }

        @Deprecated
        public HlsMediaSource createMediaSource(Uri playlistUri, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
            HlsMediaSource mediaSource = this.createMediaSource(playlistUri);
            if (eventHandler != null && eventListener != null) {
                mediaSource.addEventListener(eventHandler, eventListener);
            }
            return mediaSource;
        }

        @Deprecated
        public HlsMediaSource createMediaSource(Uri uri) {
            return this.createMediaSource(new MediaItem.Builder().setUri(uri).setMimeType("application/x-mpegURL").build());
        }

        public HlsMediaSource createMediaSource(MediaItem mediaItem) {
            boolean needsStreamKeys;
            List streamKeys;
            Assertions.checkNotNull((Object)mediaItem.playbackProperties);
            HlsPlaylistParserFactory playlistParserFactory = this.playlistParserFactory;
            List list = streamKeys = mediaItem.playbackProperties.streamKeys.isEmpty() ? this.streamKeys : mediaItem.playbackProperties.streamKeys;
            if (!streamKeys.isEmpty()) {
                playlistParserFactory = new FilteringHlsPlaylistParserFactory(playlistParserFactory, streamKeys);
            }
            boolean needsTag = mediaItem.playbackProperties.tag == null && this.tag != null;
            boolean bl = needsStreamKeys = mediaItem.playbackProperties.streamKeys.isEmpty() && !streamKeys.isEmpty();
            if (needsTag && needsStreamKeys) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).setStreamKeys(streamKeys).build();
            } else if (needsTag) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).build();
            } else if (needsStreamKeys) {
                mediaItem = mediaItem.buildUpon().setStreamKeys(streamKeys).build();
            }
            return new HlsMediaSource(mediaItem, this.hlsDataSourceFactory, this.extractorFactory, this.compositeSequenceableLoaderFactory, this.drmSessionManager != null ? this.drmSessionManager : this.mediaSourceDrmHelper.create(mediaItem), this.loadErrorHandlingPolicy, this.playlistTrackerFactory.createTracker(this.hlsDataSourceFactory, this.loadErrorHandlingPolicy, playlistParserFactory), this.allowChunklessPreparation, this.metadataType, this.useSessionKeys);
        }

        public int[] getSupportedTypes() {
            return new int[]{2};
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MetadataType {
    }
}

