/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.DefaultCompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.hls.DefaultHlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsManifest;
import com.google.android.exoplayer2.source.hls.HlsMediaPeriod;
import com.google.android.exoplayer2.source.hls.playlist.DefaultHlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.DefaultHlsPlaylistTracker;
import com.google.android.exoplayer2.source.hls.playlist.FilteringHlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultLoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public final class HlsMediaSource
extends BaseMediaSource
implements HlsPlaylistTracker.PrimaryPlaylistListener {
    public static final int METADATA_TYPE_ID3 = 1;
    public static final int METADATA_TYPE_EMSG = 3;
    private final HlsExtractorFactory extractorFactory;
    private final Uri manifestUri;
    private final HlsDataSourceFactory dataSourceFactory;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final DrmSessionManager<?> drmSessionManager;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final boolean allowChunklessPreparation;
    private final int metadataType;
    private final boolean useSessionKeys;
    private final HlsPlaylistTracker playlistTracker;
    @Nullable
    private final Object tag;
    @Nullable
    private TransferListener mediaTransferListener;

    private HlsMediaSource(Uri manifestUri, HlsDataSourceFactory dataSourceFactory, HlsExtractorFactory extractorFactory, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, DrmSessionManager<?> drmSessionManager, LoadErrorHandlingPolicy loadErrorHandlingPolicy, HlsPlaylistTracker playlistTracker, boolean allowChunklessPreparation, int metadataType, boolean useSessionKeys, @Nullable Object tag) {
        this.manifestUri = manifestUri;
        this.dataSourceFactory = dataSourceFactory;
        this.extractorFactory = extractorFactory;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.drmSessionManager = drmSessionManager;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.playlistTracker = playlistTracker;
        this.allowChunklessPreparation = allowChunklessPreparation;
        this.metadataType = metadataType;
        this.useSessionKeys = useSessionKeys;
        this.tag = tag;
    }

    @Nullable
    public Object getTag() {
        return this.tag;
    }

    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.mediaTransferListener = mediaTransferListener;
        this.drmSessionManager.prepare();
        MediaSourceEventListener.EventDispatcher eventDispatcher = this.createEventDispatcher(null);
        this.playlistTracker.start(this.manifestUri, eventDispatcher, this);
    }

    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.playlistTracker.maybeThrowPrimaryPlaylistRefreshError();
    }

    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaSourceEventListener.EventDispatcher eventDispatcher = this.createEventDispatcher(id);
        return new HlsMediaPeriod(this.extractorFactory, this.playlistTracker, this.dataSourceFactory, this.mediaTransferListener, this.drmSessionManager, this.loadErrorHandlingPolicy, eventDispatcher, allocator, this.compositeSequenceableLoaderFactory, this.allowChunklessPreparation, this.metadataType, this.useSessionKeys);
    }

    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((HlsMediaPeriod)mediaPeriod).release();
    }

    protected void releaseSourceInternal() {
        this.playlistTracker.stop();
        this.drmSessionManager.release();
    }

    @Override
    public void onPrimaryPlaylistRefreshed(HlsMediaPlaylist playlist) {
        SinglePeriodTimeline timeline;
        long windowStartTimeMs = playlist.hasProgramDateTime ? C.usToMs((long)playlist.startTimeUs) : -9223372036854775807L;
        long presentationStartTimeMs = playlist.playlistType == 2 || playlist.playlistType == 1 ? windowStartTimeMs : -9223372036854775807L;
        long windowDefaultStartPositionUs = playlist.startOffsetUs;
        HlsManifest manifest = new HlsManifest((HlsMasterPlaylist)Assertions.checkNotNull((Object)this.playlistTracker.getMasterPlaylist()), playlist);
        if (this.playlistTracker.isLive()) {
            long offsetFromInitialStartTimeUs = playlist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
            long periodDurationUs = playlist.hasEndTag ? offsetFromInitialStartTimeUs + playlist.durationUs : -9223372036854775807L;
            List<HlsMediaPlaylist.Segment> segments = playlist.segments;
            if (windowDefaultStartPositionUs == -9223372036854775807L) {
                windowDefaultStartPositionUs = 0L;
                if (!segments.isEmpty()) {
                    int defaultStartSegmentIndex;
                    long minStartPositionUs = playlist.durationUs - playlist.targetDurationUs * 2L;
                    for (defaultStartSegmentIndex = Math.max(0, segments.size() - 3); defaultStartSegmentIndex > 0 && segments.get((int)defaultStartSegmentIndex).relativeStartTimeUs > minStartPositionUs; --defaultStartSegmentIndex) {
                    }
                    windowDefaultStartPositionUs = segments.get((int)defaultStartSegmentIndex).relativeStartTimeUs;
                }
            }
            timeline = new SinglePeriodTimeline(presentationStartTimeMs, windowStartTimeMs, periodDurationUs, playlist.durationUs, offsetFromInitialStartTimeUs, windowDefaultStartPositionUs, true, !playlist.hasEndTag, true, (Object)manifest, this.tag);
        } else {
            if (windowDefaultStartPositionUs == -9223372036854775807L) {
                windowDefaultStartPositionUs = 0L;
            }
            timeline = new SinglePeriodTimeline(presentationStartTimeMs, windowStartTimeMs, playlist.durationUs, playlist.durationUs, 0L, windowDefaultStartPositionUs, true, false, false, (Object)manifest, this.tag);
        }
        this.refreshSourceInfo((Timeline)timeline);
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.hls");
    }

    public static final class Factory
    implements MediaSourceFactory {
        private final HlsDataSourceFactory hlsDataSourceFactory;
        private HlsExtractorFactory extractorFactory;
        private HlsPlaylistParserFactory playlistParserFactory;
        @Nullable
        private List<StreamKey> streamKeys;
        private HlsPlaylistTracker.Factory playlistTrackerFactory;
        private CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
        private DrmSessionManager<?> drmSessionManager;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private boolean allowChunklessPreparation;
        private int metadataType;
        private boolean useSessionKeys;
        private boolean isCreateCalled;
        @Nullable
        private Object tag;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(new DefaultHlsDataSourceFactory(dataSourceFactory));
        }

        public Factory(HlsDataSourceFactory hlsDataSourceFactory) {
            this.hlsDataSourceFactory = (HlsDataSourceFactory)Assertions.checkNotNull((Object)hlsDataSourceFactory);
            this.playlistParserFactory = new DefaultHlsPlaylistParserFactory();
            this.playlistTrackerFactory = DefaultHlsPlaylistTracker.FACTORY;
            this.extractorFactory = HlsExtractorFactory.DEFAULT;
            this.drmSessionManager = DrmSessionManager.getDummyDrmSessionManager();
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
            this.compositeSequenceableLoaderFactory = new DefaultCompositeSequenceableLoaderFactory();
            this.metadataType = 1;
        }

        public Factory setTag(@Nullable Object tag) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.tag = tag;
            return this;
        }

        public Factory setExtractorFactory(HlsExtractorFactory extractorFactory) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.extractorFactory = (HlsExtractorFactory)Assertions.checkNotNull((Object)extractorFactory);
            return this;
        }

        public Factory setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
            return this;
        }

        @Deprecated
        public Factory setMinLoadableRetryCount(int minLoadableRetryCount) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy(minLoadableRetryCount);
            return this;
        }

        public Factory setPlaylistParserFactory(HlsPlaylistParserFactory playlistParserFactory) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.playlistParserFactory = (HlsPlaylistParserFactory)Assertions.checkNotNull((Object)playlistParserFactory);
            return this;
        }

        public Factory setPlaylistTrackerFactory(HlsPlaylistTracker.Factory playlistTrackerFactory) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.playlistTrackerFactory = (HlsPlaylistTracker.Factory)Assertions.checkNotNull((Object)playlistTrackerFactory);
            return this;
        }

        public Factory setCompositeSequenceableLoaderFactory(CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.compositeSequenceableLoaderFactory = (CompositeSequenceableLoaderFactory)Assertions.checkNotNull((Object)compositeSequenceableLoaderFactory);
            return this;
        }

        public Factory setAllowChunklessPreparation(boolean allowChunklessPreparation) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.allowChunklessPreparation = allowChunklessPreparation;
            return this;
        }

        public Factory setMetadataType(int metadataType) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.metadataType = metadataType;
            return this;
        }

        public Factory setUseSessionKeys(boolean useSessionKeys) {
            this.useSessionKeys = useSessionKeys;
            return this;
        }

        @Deprecated
        public HlsMediaSource createMediaSource(Uri playlistUri, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
            HlsMediaSource mediaSource = this.createMediaSource(playlistUri);
            if (eventHandler != null && eventListener != null) {
                mediaSource.addEventListener(eventHandler, eventListener);
            }
            return mediaSource;
        }

        public Factory setDrmSessionManager(DrmSessionManager<?> drmSessionManager) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.drmSessionManager = drmSessionManager;
            return this;
        }

        public HlsMediaSource createMediaSource(Uri playlistUri) {
            this.isCreateCalled = true;
            if (this.streamKeys != null) {
                this.playlistParserFactory = new FilteringHlsPlaylistParserFactory(this.playlistParserFactory, this.streamKeys);
            }
            return new HlsMediaSource(playlistUri, this.hlsDataSourceFactory, this.extractorFactory, this.compositeSequenceableLoaderFactory, this.drmSessionManager, this.loadErrorHandlingPolicy, this.playlistTrackerFactory.createTracker(this.hlsDataSourceFactory, this.loadErrorHandlingPolicy, this.playlistParserFactory), this.allowChunklessPreparation, this.metadataType, this.useSessionKeys, this.tag);
        }

        public Factory setStreamKeys(List<StreamKey> streamKeys) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.streamKeys = streamKeys;
            return this;
        }

        public int[] getSupportedTypes() {
            return new int[]{2};
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MetadataType {
    }
}

