/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.offline;

import android.net.Uri;
import com.google.android.exoplayer2.offline.DownloaderConstructorHelper;
import com.google.android.exoplayer2.offline.SegmentDownloader;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParser;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.UriUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class HlsDownloader
extends SegmentDownloader<HlsPlaylist> {
    public HlsDownloader(Uri playlistUri, List<StreamKey> streamKeys, DownloaderConstructorHelper constructorHelper) {
        super(playlistUri, streamKeys, constructorHelper);
    }

    protected HlsPlaylist getManifest(DataSource dataSource, DataSpec dataSpec) throws IOException {
        return HlsDownloader.loadManifest(dataSource, dataSpec);
    }

    protected List<SegmentDownloader.Segment> getSegments(DataSource dataSource, HlsPlaylist playlist, boolean allowIncompleteList) throws IOException {
        ArrayList<DataSpec> mediaPlaylistDataSpecs = new ArrayList<DataSpec>();
        if (playlist instanceof HlsMasterPlaylist) {
            HlsMasterPlaylist masterPlaylist = (HlsMasterPlaylist)playlist;
            this.addMediaPlaylistDataSpecs(masterPlaylist.mediaPlaylistUrls, mediaPlaylistDataSpecs);
        } else {
            mediaPlaylistDataSpecs.add(SegmentDownloader.getCompressibleDataSpec((Uri)Uri.parse((String)playlist.baseUri)));
        }
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        HashSet<Uri> seenEncryptionKeyUris = new HashSet<Uri>();
        for (DataSpec mediaPlaylistDataSpec : mediaPlaylistDataSpecs) {
            HlsMediaPlaylist mediaPlaylist;
            segments.add(new SegmentDownloader.Segment(0L, mediaPlaylistDataSpec));
            try {
                mediaPlaylist = (HlsMediaPlaylist)HlsDownloader.loadManifest(dataSource, mediaPlaylistDataSpec);
            }
            catch (IOException e) {
                if (allowIncompleteList) continue;
                throw e;
            }
            HlsMediaPlaylist.Segment lastInitSegment = null;
            List<HlsMediaPlaylist.Segment> hlsSegments = mediaPlaylist.segments;
            for (int i = 0; i < hlsSegments.size(); ++i) {
                HlsMediaPlaylist.Segment segment = hlsSegments.get(i);
                HlsMediaPlaylist.Segment initSegment = segment.initializationSegment;
                if (initSegment != null && initSegment != lastInitSegment) {
                    lastInitSegment = initSegment;
                    this.addSegment(mediaPlaylist, initSegment, seenEncryptionKeyUris, segments);
                }
                this.addSegment(mediaPlaylist, segment, seenEncryptionKeyUris, segments);
            }
        }
        return segments;
    }

    private void addMediaPlaylistDataSpecs(List<Uri> mediaPlaylistUrls, List<DataSpec> out) {
        for (int i = 0; i < mediaPlaylistUrls.size(); ++i) {
            out.add(SegmentDownloader.getCompressibleDataSpec((Uri)mediaPlaylistUrls.get(i)));
        }
    }

    private static HlsPlaylist loadManifest(DataSource dataSource, DataSpec dataSpec) throws IOException {
        return (HlsPlaylist)ParsingLoadable.load((DataSource)dataSource, (ParsingLoadable.Parser)new HlsPlaylistParser(), (DataSpec)dataSpec, (int)4);
    }

    private void addSegment(HlsMediaPlaylist mediaPlaylist, HlsMediaPlaylist.Segment segment, HashSet<Uri> seenEncryptionKeyUris, ArrayList<SegmentDownloader.Segment> out) {
        Uri keyUri;
        String baseUri = mediaPlaylist.baseUri;
        long startTimeUs = mediaPlaylist.startTimeUs + segment.relativeStartTimeUs;
        if (segment.fullSegmentEncryptionKeyUri != null && seenEncryptionKeyUris.add(keyUri = UriUtil.resolveToUri((String)baseUri, (String)segment.fullSegmentEncryptionKeyUri))) {
            out.add(new SegmentDownloader.Segment(startTimeUs, SegmentDownloader.getCompressibleDataSpec((Uri)keyUri)));
        }
        Uri segmentUri = UriUtil.resolveToUri((String)baseUri, (String)segment.url);
        DataSpec dataSpec = new DataSpec(segmentUri, segment.byterangeOffset, segment.byterangeLength, null);
        out.add(new SegmentDownloader.Segment(startTimeUs, dataSpec));
    }
}

