/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.DummyTrackOutput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.PrivFrame;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.source.hls.HlsChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaChunk;
import com.google.android.exoplayer2.source.hls.HlsSampleStream;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class HlsSampleStreamWrapper
implements Loader.Callback<Chunk>,
Loader.ReleaseCallback,
SequenceableLoader,
ExtractorOutput,
SampleQueue.UpstreamFormatChangedListener {
    private static final String TAG = "HlsSampleStreamWrapper";
    public static final int SAMPLE_QUEUE_INDEX_PENDING = -1;
    public static final int SAMPLE_QUEUE_INDEX_NO_MAPPING_FATAL = -2;
    public static final int SAMPLE_QUEUE_INDEX_NO_MAPPING_NON_FATAL = -3;
    private final int trackType;
    private final Callback callback;
    private final HlsChunkSource chunkSource;
    private final Allocator allocator;
    private final Format muxedAudioFormat;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final Loader loader;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final HlsChunkSource.HlsChunkHolder nextChunkHolder;
    private final ArrayList<HlsMediaChunk> mediaChunks;
    private final List<HlsMediaChunk> readOnlyMediaChunks;
    private final Runnable maybeFinishPrepareRunnable;
    private final Runnable onTracksEndedRunnable;
    private final Handler handler;
    private final ArrayList<HlsSampleStream> hlsSampleStreams;
    private final Map<String, DrmInitData> overridingDrmInitData;
    private SampleQueue[] sampleQueues;
    private int[] sampleQueueTrackIds;
    private boolean audioSampleQueueMappingDone;
    private int audioSampleQueueIndex;
    private boolean videoSampleQueueMappingDone;
    private int videoSampleQueueIndex;
    private int primarySampleQueueType;
    private int primarySampleQueueIndex;
    private boolean sampleQueuesBuilt;
    private boolean prepared;
    private int enabledTrackGroupCount;
    private Format upstreamTrackFormat;
    private Format downstreamTrackFormat;
    private boolean released;
    private TrackGroupArray trackGroups;
    private TrackGroupArray optionalTrackGroups;
    private int[] trackGroupToSampleQueueIndex;
    private int primaryTrackGroupIndex;
    private boolean haveAudioVideoSampleQueues;
    private boolean[] sampleQueuesEnabledStates;
    private boolean[] sampleQueueIsAudioVideoFlags;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private boolean pendingResetUpstreamFormats;
    private boolean seenFirstTrackSelection;
    private boolean loadingFinished;
    private boolean tracksEnded;
    private long sampleOffsetUs;
    private int chunkUid;

    public HlsSampleStreamWrapper(int trackType, Callback callback, HlsChunkSource chunkSource, Map<String, DrmInitData> overridingDrmInitData, Allocator allocator, long positionUs, Format muxedAudioFormat, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher eventDispatcher) {
        this.trackType = trackType;
        this.callback = callback;
        this.chunkSource = chunkSource;
        this.overridingDrmInitData = overridingDrmInitData;
        this.allocator = allocator;
        this.muxedAudioFormat = muxedAudioFormat;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.eventDispatcher = eventDispatcher;
        this.loader = new Loader("Loader:HlsSampleStreamWrapper");
        this.nextChunkHolder = new HlsChunkSource.HlsChunkHolder();
        this.sampleQueueTrackIds = new int[0];
        this.audioSampleQueueIndex = -1;
        this.videoSampleQueueIndex = -1;
        this.sampleQueues = new SampleQueue[0];
        this.sampleQueueIsAudioVideoFlags = new boolean[0];
        this.sampleQueuesEnabledStates = new boolean[0];
        this.mediaChunks = new ArrayList();
        this.readOnlyMediaChunks = Collections.unmodifiableList(this.mediaChunks);
        this.hlsSampleStreams = new ArrayList();
        this.maybeFinishPrepareRunnable = this::maybeFinishPrepare;
        this.onTracksEndedRunnable = this::onTracksEnded;
        this.handler = new Handler();
        this.lastSeekPositionUs = positionUs;
        this.pendingResetPositionUs = positionUs;
    }

    public void continuePreparing() {
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        }
    }

    public void prepareWithMasterPlaylistInfo(TrackGroupArray trackGroups, int primaryTrackGroupIndex, TrackGroupArray optionalTrackGroups) {
        this.prepared = true;
        this.trackGroups = trackGroups;
        this.optionalTrackGroups = optionalTrackGroups;
        this.primaryTrackGroupIndex = primaryTrackGroupIndex;
        this.handler.post(this.callback::onPrepared);
    }

    public void maybeThrowPrepareError() throws IOException {
        this.maybeThrowError();
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public int getPrimaryTrackGroupIndex() {
        return this.primaryTrackGroupIndex;
    }

    public int bindSampleQueueToSampleStream(int trackGroupIndex) {
        int sampleQueueIndex = this.trackGroupToSampleQueueIndex[trackGroupIndex];
        if (sampleQueueIndex == -1) {
            return this.optionalTrackGroups.indexOf(this.trackGroups.get(trackGroupIndex)) == -1 ? -2 : -3;
        }
        if (this.sampleQueuesEnabledStates[sampleQueueIndex]) {
            return -2;
        }
        this.sampleQueuesEnabledStates[sampleQueueIndex] = true;
        return sampleQueueIndex;
    }

    public void unbindSampleQueue(int trackGroupIndex) {
        int sampleQueueIndex = this.trackGroupToSampleQueueIndex[trackGroupIndex];
        Assertions.checkState((boolean)this.sampleQueuesEnabledStates[sampleQueueIndex]);
        this.sampleQueuesEnabledStates[sampleQueueIndex] = false;
    }

    public boolean selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs, boolean forceReset) {
        int i;
        TrackSelection oldPrimaryTrackSelection;
        Assertions.checkState((boolean)this.prepared);
        int oldEnabledTrackGroupCount = this.enabledTrackGroupCount;
        for (int i2 = 0; i2 < selections.length; ++i2) {
            if (streams[i2] == null || selections[i2] != null && mayRetainStreamFlags[i2]) continue;
            --this.enabledTrackGroupCount;
            ((HlsSampleStream)streams[i2]).unbindSampleQueue();
            streams[i2] = null;
        }
        boolean seekRequired = forceReset || (this.seenFirstTrackSelection ? oldEnabledTrackGroupCount == 0 : positionUs != this.lastSeekPositionUs);
        TrackSelection primaryTrackSelection = oldPrimaryTrackSelection = this.chunkSource.getTrackSelection();
        for (i = 0; i < selections.length; ++i) {
            TrackSelection selection = selections[i];
            if (selection == null) continue;
            int trackGroupIndex = this.trackGroups.indexOf(selection.getTrackGroup());
            if (trackGroupIndex == this.primaryTrackGroupIndex) {
                primaryTrackSelection = selection;
                this.chunkSource.setTrackSelection(selection);
            }
            if (streams[i] != null) continue;
            ++this.enabledTrackGroupCount;
            streams[i] = new HlsSampleStream(this, trackGroupIndex);
            streamResetFlags[i] = true;
            if (this.trackGroupToSampleQueueIndex != null) {
                ((HlsSampleStream)streams[i]).bindSampleQueue();
            }
            if (!this.sampleQueuesBuilt || seekRequired) continue;
            SampleQueue sampleQueue = this.sampleQueues[this.trackGroupToSampleQueueIndex[trackGroupIndex]];
            sampleQueue.rewind();
            seekRequired = sampleQueue.advanceTo(positionUs, true, true) == -1 && sampleQueue.getReadIndex() != 0;
        }
        if (this.enabledTrackGroupCount == 0) {
            this.chunkSource.reset();
            this.downstreamTrackFormat = null;
            this.pendingResetUpstreamFormats = true;
            this.mediaChunks.clear();
            if (this.loader.isLoading()) {
                if (this.sampleQueuesBuilt) {
                    for (SampleQueue sampleQueue : this.sampleQueues) {
                        sampleQueue.discardToEnd();
                    }
                }
                this.loader.cancelLoading();
            } else {
                this.resetSampleQueues();
            }
        } else {
            if (!this.mediaChunks.isEmpty() && !Util.areEqual((Object)primaryTrackSelection, (Object)oldPrimaryTrackSelection)) {
                boolean primarySampleQueueDirty = false;
                if (!this.seenFirstTrackSelection) {
                    long bufferedDurationUs = positionUs < 0L ? -positionUs : 0L;
                    HlsMediaChunk lastMediaChunk = this.getLastMediaChunk();
                    MediaChunkIterator[] mediaChunkIterators = this.chunkSource.createMediaChunkIterators(lastMediaChunk, positionUs);
                    primaryTrackSelection.updateSelectedTrack(positionUs, bufferedDurationUs, -9223372036854775807L, this.readOnlyMediaChunks, mediaChunkIterators);
                    int chunkIndex = this.chunkSource.getTrackGroup().indexOf(lastMediaChunk.trackFormat);
                    if (primaryTrackSelection.getSelectedIndexInTrackGroup() != chunkIndex) {
                        primarySampleQueueDirty = true;
                    }
                } else {
                    primarySampleQueueDirty = true;
                }
                if (primarySampleQueueDirty) {
                    forceReset = true;
                    seekRequired = true;
                    this.pendingResetUpstreamFormats = true;
                }
            }
            if (seekRequired) {
                this.seekToUs(positionUs, forceReset);
                for (i = 0; i < streams.length; ++i) {
                    if (streams[i] == null) continue;
                    streamResetFlags[i] = true;
                }
            }
        }
        this.updateSampleStreams(streams);
        this.seenFirstTrackSelection = true;
        return seekRequired;
    }

    public void discardBuffer(long positionUs, boolean toKeyframe) {
        if (!this.sampleQueuesBuilt || this.isPendingReset()) {
            return;
        }
        int sampleQueueCount = this.sampleQueues.length;
        for (int i = 0; i < sampleQueueCount; ++i) {
            this.sampleQueues[i].discardTo(positionUs, toKeyframe, this.sampleQueuesEnabledStates[i]);
        }
    }

    public boolean seekToUs(long positionUs, boolean forceReset) {
        this.lastSeekPositionUs = positionUs;
        if (this.isPendingReset()) {
            this.pendingResetPositionUs = positionUs;
            return true;
        }
        if (this.sampleQueuesBuilt && !forceReset && this.seekInsideBufferUs(positionUs)) {
            return false;
        }
        this.pendingResetPositionUs = positionUs;
        this.loadingFinished = false;
        this.mediaChunks.clear();
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.loader.clearFatalError();
            this.resetSampleQueues();
        }
        return true;
    }

    public void release() {
        if (this.prepared) {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.discardToEnd();
            }
        }
        this.loader.release((Loader.ReleaseCallback)this);
        this.handler.removeCallbacksAndMessages(null);
        this.released = true;
        this.hlsSampleStreams.clear();
    }

    public void onLoaderReleased() {
        this.resetSampleQueues();
    }

    public void setIsTimestampMaster(boolean isTimestampMaster) {
        this.chunkSource.setIsTimestampMaster(isTimestampMaster);
    }

    public boolean onPlaylistError(Uri playlistUrl, long blacklistDurationMs) {
        return this.chunkSource.onPlaylistError(playlistUrl, blacklistDurationMs);
    }

    public boolean isReady(int sampleQueueIndex) {
        return this.loadingFinished || !this.isPendingReset() && this.sampleQueues[sampleQueueIndex].hasNextSample();
    }

    public void maybeThrowError() throws IOException {
        this.loader.maybeThrowError();
        this.chunkSource.maybeThrowError();
    }

    public int readData(int sampleQueueIndex, FormatHolder formatHolder, DecoderInputBuffer buffer, boolean requireFormat) {
        int result;
        if (this.isPendingReset()) {
            return -3;
        }
        if (!this.mediaChunks.isEmpty()) {
            int discardToMediaChunkIndex;
            for (discardToMediaChunkIndex = 0; discardToMediaChunkIndex < this.mediaChunks.size() - 1 && this.finishedReadingChunk(this.mediaChunks.get(discardToMediaChunkIndex)); ++discardToMediaChunkIndex) {
            }
            Util.removeRange(this.mediaChunks, (int)0, (int)discardToMediaChunkIndex);
            HlsMediaChunk currentChunk = this.mediaChunks.get(0);
            Format trackFormat = currentChunk.trackFormat;
            if (!trackFormat.equals((Object)this.downstreamTrackFormat)) {
                this.eventDispatcher.downstreamFormatChanged(this.trackType, trackFormat, currentChunk.trackSelectionReason, currentChunk.trackSelectionData, currentChunk.startTimeUs);
            }
            this.downstreamTrackFormat = trackFormat;
        }
        if ((result = this.sampleQueues[sampleQueueIndex].read(formatHolder, buffer, requireFormat, this.loadingFinished, this.lastSeekPositionUs)) == -5) {
            DrmInitData drmInitData;
            Format format = formatHolder.format;
            if (sampleQueueIndex == this.primarySampleQueueIndex) {
                int chunkIndex;
                int chunkUid = this.sampleQueues[sampleQueueIndex].peekSourceId();
                for (chunkIndex = 0; chunkIndex < this.mediaChunks.size() && this.mediaChunks.get((int)chunkIndex).uid != chunkUid; ++chunkIndex) {
                }
                Format trackFormat = chunkIndex < this.mediaChunks.size() ? this.mediaChunks.get((int)chunkIndex).trackFormat : this.upstreamTrackFormat;
                format = format.copyWithManifestFormatInfo(trackFormat);
            }
            if (format.drmInitData != null && (drmInitData = this.overridingDrmInitData.get(format.drmInitData.schemeType)) != null) {
                format = format.copyWithDrmInitData(drmInitData);
            }
            formatHolder.format = format;
        }
        return result;
    }

    public int skipData(int sampleQueueIndex, long positionUs) {
        if (this.isPendingReset()) {
            return 0;
        }
        SampleQueue sampleQueue = this.sampleQueues[sampleQueueIndex];
        if (this.loadingFinished && positionUs > sampleQueue.getLargestQueuedTimestampUs()) {
            return sampleQueue.advanceToEnd();
        }
        int skipCount = sampleQueue.advanceTo(positionUs, true, true);
        return skipCount == -1 ? 0 : skipCount;
    }

    public long getBufferedPositionUs() {
        HlsMediaChunk lastCompletedMediaChunk;
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long bufferedPositionUs = this.lastSeekPositionUs;
        HlsMediaChunk lastMediaChunk = this.getLastMediaChunk();
        HlsMediaChunk hlsMediaChunk = lastMediaChunk.isLoadCompleted() ? lastMediaChunk : (lastCompletedMediaChunk = this.mediaChunks.size() > 1 ? this.mediaChunks.get(this.mediaChunks.size() - 2) : null);
        if (lastCompletedMediaChunk != null) {
            bufferedPositionUs = Math.max(bufferedPositionUs, lastCompletedMediaChunk.endTimeUs);
        }
        if (this.sampleQueuesBuilt) {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                bufferedPositionUs = Math.max(bufferedPositionUs, sampleQueue.getLargestQueuedTimestampUs());
            }
        }
        return bufferedPositionUs;
    }

    public long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        return this.loadingFinished ? Long.MIN_VALUE : this.getLastMediaChunk().endTimeUs;
    }

    public boolean continueLoading(long positionUs) {
        long loadPositionUs;
        List<HlsMediaChunk> chunkQueue;
        if (this.loadingFinished || this.loader.isLoading() || this.loader.hasFatalError()) {
            return false;
        }
        if (this.isPendingReset()) {
            chunkQueue = Collections.emptyList();
            loadPositionUs = this.pendingResetPositionUs;
        } else {
            chunkQueue = this.readOnlyMediaChunks;
            HlsMediaChunk lastMediaChunk = this.getLastMediaChunk();
            loadPositionUs = lastMediaChunk.isLoadCompleted() ? lastMediaChunk.endTimeUs : Math.max(this.lastSeekPositionUs, lastMediaChunk.startTimeUs);
        }
        this.chunkSource.getNextChunk(positionUs, loadPositionUs, chunkQueue, this.nextChunkHolder);
        boolean endOfStream = this.nextChunkHolder.endOfStream;
        Chunk loadable = this.nextChunkHolder.chunk;
        Uri playlistUrlToLoad = this.nextChunkHolder.playlistUrl;
        this.nextChunkHolder.clear();
        if (endOfStream) {
            this.pendingResetPositionUs = -9223372036854775807L;
            this.loadingFinished = true;
            return true;
        }
        if (loadable == null) {
            if (playlistUrlToLoad != null) {
                this.callback.onPlaylistRefreshRequired(playlistUrlToLoad);
            }
            return false;
        }
        if (HlsSampleStreamWrapper.isMediaChunk(loadable)) {
            this.pendingResetPositionUs = -9223372036854775807L;
            HlsMediaChunk mediaChunk = (HlsMediaChunk)loadable;
            mediaChunk.init(this);
            this.mediaChunks.add(mediaChunk);
            this.upstreamTrackFormat = mediaChunk.trackFormat;
        }
        long elapsedRealtimeMs = this.loader.startLoading((Loader.Loadable)loadable, (Loader.Callback)this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(loadable.type));
        this.eventDispatcher.loadStarted(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs);
        return true;
    }

    public void reevaluateBuffer(long positionUs) {
    }

    public void onLoadCompleted(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.chunkSource.onChunkLoadCompleted(loadable);
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        } else {
            this.callback.onContinueLoadingRequested(this);
        }
    }

    public void onLoadCanceled(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.eventDispatcher.loadCanceled(loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        if (!released) {
            this.resetSampleQueues();
            if (this.enabledTrackGroupCount > 0) {
                this.callback.onContinueLoadingRequested(this);
            }
        }
    }

    public Loader.LoadErrorAction onLoadError(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        Loader.LoadErrorAction loadErrorAction;
        long bytesLoaded = loadable.bytesLoaded();
        boolean isMediaChunk = HlsSampleStreamWrapper.isMediaChunk(loadable);
        boolean blacklistSucceeded = false;
        long blacklistDurationMs = this.loadErrorHandlingPolicy.getBlacklistDurationMsFor(loadable.type, loadDurationMs, error, errorCount);
        if (blacklistDurationMs != -9223372036854775807L) {
            blacklistSucceeded = this.chunkSource.maybeBlacklistTrack(loadable, blacklistDurationMs);
        }
        if (blacklistSucceeded) {
            if (isMediaChunk && bytesLoaded == 0L) {
                HlsMediaChunk removed = this.mediaChunks.remove(this.mediaChunks.size() - 1);
                Assertions.checkState((removed == loadable ? 1 : 0) != 0);
                if (this.mediaChunks.isEmpty()) {
                    this.pendingResetPositionUs = this.lastSeekPositionUs;
                }
            }
            loadErrorAction = Loader.DONT_RETRY;
        } else {
            long retryDelayMs = this.loadErrorHandlingPolicy.getRetryDelayMsFor(loadable.type, loadDurationMs, error, errorCount);
            loadErrorAction = retryDelayMs != -9223372036854775807L ? Loader.createRetryAction((boolean)false, (long)retryDelayMs) : Loader.DONT_RETRY_FATAL;
        }
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, bytesLoaded, error, !loadErrorAction.isRetry());
        if (blacklistSucceeded) {
            if (!this.prepared) {
                this.continueLoading(this.lastSeekPositionUs);
            } else {
                this.callback.onContinueLoadingRequested(this);
            }
        }
        return loadErrorAction;
    }

    public void init(int chunkUid, boolean shouldSpliceIn, boolean reusingExtractor) {
        if (!reusingExtractor) {
            this.audioSampleQueueMappingDone = false;
            this.videoSampleQueueMappingDone = false;
        }
        this.chunkUid = chunkUid;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.sourceId(chunkUid);
        }
        if (shouldSpliceIn) {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.splice();
            }
        }
    }

    public TrackOutput track(int id, int type) {
        int trackCount = this.sampleQueues.length;
        if (type == 1) {
            if (this.audioSampleQueueIndex != -1) {
                if (this.audioSampleQueueMappingDone) {
                    return this.sampleQueueTrackIds[this.audioSampleQueueIndex] == id ? this.sampleQueues[this.audioSampleQueueIndex] : HlsSampleStreamWrapper.createDummyTrackOutput(id, type);
                }
                this.audioSampleQueueMappingDone = true;
                this.sampleQueueTrackIds[this.audioSampleQueueIndex] = id;
                return this.sampleQueues[this.audioSampleQueueIndex];
            }
            if (this.tracksEnded) {
                return HlsSampleStreamWrapper.createDummyTrackOutput(id, type);
            }
        } else if (type == 2) {
            if (this.videoSampleQueueIndex != -1) {
                if (this.videoSampleQueueMappingDone) {
                    return this.sampleQueueTrackIds[this.videoSampleQueueIndex] == id ? this.sampleQueues[this.videoSampleQueueIndex] : HlsSampleStreamWrapper.createDummyTrackOutput(id, type);
                }
                this.videoSampleQueueMappingDone = true;
                this.sampleQueueTrackIds[this.videoSampleQueueIndex] = id;
                return this.sampleQueues[this.videoSampleQueueIndex];
            }
            if (this.tracksEnded) {
                return HlsSampleStreamWrapper.createDummyTrackOutput(id, type);
            }
        } else {
            for (int i = 0; i < trackCount; ++i) {
                if (this.sampleQueueTrackIds[i] != id) continue;
                return this.sampleQueues[i];
            }
            if (this.tracksEnded) {
                return HlsSampleStreamWrapper.createDummyTrackOutput(id, type);
            }
        }
        PrivTimestampStrippingSampleQueue trackOutput = new PrivTimestampStrippingSampleQueue(this.allocator);
        trackOutput.setSampleOffsetUs(this.sampleOffsetUs);
        trackOutput.sourceId(this.chunkUid);
        trackOutput.setUpstreamFormatChangeListener(this);
        this.sampleQueueTrackIds = Arrays.copyOf(this.sampleQueueTrackIds, trackCount + 1);
        this.sampleQueueTrackIds[trackCount] = id;
        this.sampleQueues = Arrays.copyOf(this.sampleQueues, trackCount + 1);
        this.sampleQueues[trackCount] = trackOutput;
        this.sampleQueueIsAudioVideoFlags = Arrays.copyOf(this.sampleQueueIsAudioVideoFlags, trackCount + 1);
        this.sampleQueueIsAudioVideoFlags[trackCount] = type == 1 || type == 2;
        this.haveAudioVideoSampleQueues |= this.sampleQueueIsAudioVideoFlags[trackCount];
        if (type == 1) {
            this.audioSampleQueueMappingDone = true;
            this.audioSampleQueueIndex = trackCount;
        } else if (type == 2) {
            this.videoSampleQueueMappingDone = true;
            this.videoSampleQueueIndex = trackCount;
        }
        if (HlsSampleStreamWrapper.getTrackTypeScore(type) > HlsSampleStreamWrapper.getTrackTypeScore(this.primarySampleQueueType)) {
            this.primarySampleQueueIndex = trackCount;
            this.primarySampleQueueType = type;
        }
        this.sampleQueuesEnabledStates = Arrays.copyOf(this.sampleQueuesEnabledStates, trackCount + 1);
        return trackOutput;
    }

    public void endTracks() {
        this.tracksEnded = true;
        this.handler.post(this.onTracksEndedRunnable);
    }

    public void seekMap(SeekMap seekMap) {
    }

    public void onUpstreamFormatChanged(Format format) {
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    public void setSampleOffsetUs(long sampleOffsetUs) {
        this.sampleOffsetUs = sampleOffsetUs;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.setSampleOffsetUs(sampleOffsetUs);
        }
    }

    private void updateSampleStreams(SampleStream[] streams) {
        this.hlsSampleStreams.clear();
        for (SampleStream stream : streams) {
            if (stream == null) continue;
            this.hlsSampleStreams.add((HlsSampleStream)stream);
        }
    }

    private boolean finishedReadingChunk(HlsMediaChunk chunk) {
        int chunkUid = chunk.uid;
        int sampleQueueCount = this.sampleQueues.length;
        for (int i = 0; i < sampleQueueCount; ++i) {
            if (!this.sampleQueuesEnabledStates[i] || this.sampleQueues[i].peekSourceId() != chunkUid) continue;
            return false;
        }
        return true;
    }

    private void resetSampleQueues() {
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.reset(this.pendingResetUpstreamFormats);
        }
        this.pendingResetUpstreamFormats = false;
    }

    private void onTracksEnded() {
        this.sampleQueuesBuilt = true;
        this.maybeFinishPrepare();
    }

    private void maybeFinishPrepare() {
        if (this.released || this.trackGroupToSampleQueueIndex != null || !this.sampleQueuesBuilt) {
            return;
        }
        for (SampleQueue sampleQueue : this.sampleQueues) {
            if (sampleQueue.getUpstreamFormat() != null) continue;
            return;
        }
        if (this.trackGroups != null) {
            this.mapSampleQueuesToMatchTrackGroups();
        } else {
            this.buildTracksFromSampleStreams();
            this.prepared = true;
            this.callback.onPrepared();
        }
    }

    private void mapSampleQueuesToMatchTrackGroups() {
        int trackGroupCount = this.trackGroups.length;
        this.trackGroupToSampleQueueIndex = new int[trackGroupCount];
        Arrays.fill(this.trackGroupToSampleQueueIndex, -1);
        block0: for (int i = 0; i < trackGroupCount; ++i) {
            for (int queueIndex = 0; queueIndex < this.sampleQueues.length; ++queueIndex) {
                SampleQueue sampleQueue = this.sampleQueues[queueIndex];
                if (!HlsSampleStreamWrapper.formatsMatch(sampleQueue.getUpstreamFormat(), this.trackGroups.get(i).getFormat(0))) continue;
                this.trackGroupToSampleQueueIndex[i] = queueIndex;
                continue block0;
            }
        }
        for (HlsSampleStream sampleStream : this.hlsSampleStreams) {
            sampleStream.bindSampleQueue();
        }
    }

    private void buildTracksFromSampleStreams() {
        int primaryExtractorTrackType = 6;
        int primaryExtractorTrackIndex = -1;
        int extractorTrackCount = this.sampleQueues.length;
        for (int i = 0; i < extractorTrackCount; ++i) {
            String sampleMimeType = this.sampleQueues[i].getUpstreamFormat().sampleMimeType;
            int trackType = MimeTypes.isVideo((String)sampleMimeType) ? 2 : (MimeTypes.isAudio((String)sampleMimeType) ? 1 : (MimeTypes.isText((String)sampleMimeType) ? 3 : 6));
            if (HlsSampleStreamWrapper.getTrackTypeScore(trackType) > HlsSampleStreamWrapper.getTrackTypeScore(primaryExtractorTrackType)) {
                primaryExtractorTrackType = trackType;
                primaryExtractorTrackIndex = i;
                continue;
            }
            if (trackType != primaryExtractorTrackType || primaryExtractorTrackIndex == -1) continue;
            primaryExtractorTrackIndex = -1;
        }
        TrackGroup chunkSourceTrackGroup = this.chunkSource.getTrackGroup();
        int chunkSourceTrackCount = chunkSourceTrackGroup.length;
        this.primaryTrackGroupIndex = -1;
        this.trackGroupToSampleQueueIndex = new int[extractorTrackCount];
        for (int i = 0; i < extractorTrackCount; ++i) {
            this.trackGroupToSampleQueueIndex[i] = i;
        }
        TrackGroup[] trackGroups = new TrackGroup[extractorTrackCount];
        for (int i = 0; i < extractorTrackCount; ++i) {
            Format sampleFormat = this.sampleQueues[i].getUpstreamFormat();
            if (i == primaryExtractorTrackIndex) {
                Format[] formats = new Format[chunkSourceTrackCount];
                if (chunkSourceTrackCount == 1) {
                    formats[0] = sampleFormat.copyWithManifestFormatInfo(chunkSourceTrackGroup.getFormat(0));
                } else {
                    for (int j = 0; j < chunkSourceTrackCount; ++j) {
                        formats[j] = HlsSampleStreamWrapper.deriveFormat(chunkSourceTrackGroup.getFormat(j), sampleFormat, true);
                    }
                }
                trackGroups[i] = new TrackGroup(formats);
                this.primaryTrackGroupIndex = i;
                continue;
            }
            Format trackFormat = primaryExtractorTrackType == 2 && MimeTypes.isAudio((String)sampleFormat.sampleMimeType) ? this.muxedAudioFormat : null;
            trackGroups[i] = new TrackGroup(new Format[]{HlsSampleStreamWrapper.deriveFormat(trackFormat, sampleFormat, false)});
        }
        this.trackGroups = new TrackGroupArray(trackGroups);
        Assertions.checkState((this.optionalTrackGroups == null ? 1 : 0) != 0);
        this.optionalTrackGroups = TrackGroupArray.EMPTY;
    }

    private HlsMediaChunk getLastMediaChunk() {
        return this.mediaChunks.get(this.mediaChunks.size() - 1);
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != -9223372036854775807L;
    }

    private boolean seekInsideBufferUs(long positionUs) {
        int sampleQueueCount = this.sampleQueues.length;
        for (int i = 0; i < sampleQueueCount; ++i) {
            boolean seekInsideQueue;
            SampleQueue sampleQueue = this.sampleQueues[i];
            sampleQueue.rewind();
            boolean bl = seekInsideQueue = sampleQueue.advanceTo(positionUs, true, false) != -1;
            if (seekInsideQueue || !this.sampleQueueIsAudioVideoFlags[i] && this.haveAudioVideoSampleQueues) continue;
            return false;
        }
        return true;
    }

    private static int getTrackTypeScore(int trackType) {
        switch (trackType) {
            case 2: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    private static Format deriveFormat(Format playlistFormat, Format sampleFormat, boolean propagateBitrate) {
        if (playlistFormat == null) {
            return sampleFormat;
        }
        int bitrate = propagateBitrate ? playlistFormat.bitrate : -1;
        int channelCount = playlistFormat.channelCount != -1 ? playlistFormat.channelCount : sampleFormat.channelCount;
        int sampleTrackType = MimeTypes.getTrackType((String)sampleFormat.sampleMimeType);
        String codecs = Util.getCodecsOfType((String)playlistFormat.codecs, (int)sampleTrackType);
        String mimeType = MimeTypes.getMediaMimeType((String)codecs);
        if (mimeType == null) {
            mimeType = sampleFormat.sampleMimeType;
        }
        return sampleFormat.copyWithContainerInfo(playlistFormat.id, playlistFormat.label, mimeType, codecs, playlistFormat.metadata, bitrate, playlistFormat.width, playlistFormat.height, channelCount, playlistFormat.selectionFlags, playlistFormat.language);
    }

    private static boolean isMediaChunk(Chunk chunk) {
        return chunk instanceof HlsMediaChunk;
    }

    private static boolean formatsMatch(Format manifestFormat, Format sampleFormat) {
        String manifestFormatMimeType = manifestFormat.sampleMimeType;
        String sampleFormatMimeType = sampleFormat.sampleMimeType;
        int manifestFormatTrackType = MimeTypes.getTrackType((String)manifestFormatMimeType);
        if (manifestFormatTrackType != 3) {
            return manifestFormatTrackType == MimeTypes.getTrackType((String)sampleFormatMimeType);
        }
        if (!Util.areEqual((Object)manifestFormatMimeType, (Object)sampleFormatMimeType)) {
            return false;
        }
        if ("application/cea-608".equals(manifestFormatMimeType) || "application/cea-708".equals(manifestFormatMimeType)) {
            return manifestFormat.accessibilityChannel == sampleFormat.accessibilityChannel;
        }
        return true;
    }

    private static DummyTrackOutput createDummyTrackOutput(int id, int type) {
        Log.w((String)TAG, (String)("Unmapped track with id " + id + " of type " + type));
        return new DummyTrackOutput();
    }

    private static final class PrivTimestampStrippingSampleQueue
    extends SampleQueue {
        public PrivTimestampStrippingSampleQueue(Allocator allocator) {
            super(allocator);
        }

        public void format(Format format) {
            super.format(format.copyWithMetadata(this.getAdjustedMetadata(format.metadata)));
        }

        @Nullable
        private Metadata getAdjustedMetadata(@Nullable Metadata metadata) {
            if (metadata == null) {
                return null;
            }
            int length = metadata.length();
            int transportStreamTimestampMetadataIndex = -1;
            for (int i = 0; i < length; ++i) {
                Metadata.Entry metadataEntry = metadata.get(i);
                if (!(metadataEntry instanceof PrivFrame)) continue;
                PrivFrame privFrame = (PrivFrame)metadataEntry;
                if (!"com.apple.streaming.transportStreamTimestamp".equals(privFrame.owner)) continue;
                transportStreamTimestampMetadataIndex = i;
                break;
            }
            if (transportStreamTimestampMetadataIndex == -1) {
                return metadata;
            }
            if (length == 1) {
                return null;
            }
            Metadata.Entry[] newMetadataEntries = new Metadata.Entry[length - 1];
            for (int i = 0; i < length; ++i) {
                if (i == transportStreamTimestampMetadataIndex) continue;
                int newIndex = i < transportStreamTimestampMetadataIndex ? i : i - 1;
                newMetadataEntries[newIndex] = metadata.get(i);
            }
            return new Metadata(newMetadataEntries);
        }
    }

    public static interface Callback
    extends SequenceableLoader.Callback<HlsSampleStreamWrapper> {
        public void onPrepared();

        public void onPlaylistRefreshRequired(Uri var1);
    }
}

