/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.BehindLiveWindowException;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.chunk.BaseMediaChunkIterator;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.DataChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsMediaChunk;
import com.google.android.exoplayer2.source.hls.TimestampAdjusterProvider;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.google.android.exoplayer2.trackselection.BaseTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.UriUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class HlsChunkSource {
    private static final int KEY_CACHE_SIZE = 4;
    private final HlsExtractorFactory extractorFactory;
    private final DataSource mediaDataSource;
    private final DataSource encryptionDataSource;
    private final TimestampAdjusterProvider timestampAdjusterProvider;
    private final Uri[] playlistUrls;
    private final Format[] playlistFormats;
    private final HlsPlaylistTracker playlistTracker;
    private final TrackGroup trackGroup;
    private final List<Format> muxedCaptionFormats;
    private final FullSegmentEncryptionKeyCache keyCache;
    private boolean isTimestampMaster;
    private byte[] scratchSpace;
    private IOException fatalError;
    private Uri expectedPlaylistUrl;
    private boolean independentSegments;
    private TrackSelection trackSelection;
    private long liveEdgeInPeriodTimeUs;
    private boolean seenExpectedPlaylistError;

    public HlsChunkSource(HlsExtractorFactory extractorFactory, HlsPlaylistTracker playlistTracker, Uri[] playlistUrls, Format[] playlistFormats, HlsDataSourceFactory dataSourceFactory, @Nullable TransferListener mediaTransferListener, TimestampAdjusterProvider timestampAdjusterProvider, List<Format> muxedCaptionFormats) {
        this.extractorFactory = extractorFactory;
        this.playlistTracker = playlistTracker;
        this.playlistUrls = playlistUrls;
        this.playlistFormats = playlistFormats;
        this.timestampAdjusterProvider = timestampAdjusterProvider;
        this.muxedCaptionFormats = muxedCaptionFormats;
        this.keyCache = new FullSegmentEncryptionKeyCache();
        this.liveEdgeInPeriodTimeUs = -9223372036854775807L;
        this.mediaDataSource = dataSourceFactory.createDataSource(1);
        if (mediaTransferListener != null) {
            this.mediaDataSource.addTransferListener(mediaTransferListener);
        }
        this.encryptionDataSource = dataSourceFactory.createDataSource(3);
        this.trackGroup = new TrackGroup(playlistFormats);
        int[] initialTrackSelection = new int[playlistUrls.length];
        for (int i = 0; i < playlistUrls.length; ++i) {
            initialTrackSelection[i] = i;
        }
        this.trackSelection = new InitializationTrackSelection(this.trackGroup, initialTrackSelection);
    }

    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        if (this.expectedPlaylistUrl != null && this.seenExpectedPlaylistError) {
            this.playlistTracker.maybeThrowPlaylistRefreshError(this.expectedPlaylistUrl);
        }
    }

    public TrackGroup getTrackGroup() {
        return this.trackGroup;
    }

    public void setTrackSelection(TrackSelection trackSelection) {
        this.trackSelection = trackSelection;
    }

    public TrackSelection getTrackSelection() {
        return this.trackSelection;
    }

    public void reset() {
        this.fatalError = null;
    }

    public void setIsTimestampMaster(boolean isTimestampMaster) {
        this.isTimestampMaster = isTimestampMaster;
    }

    public void getNextChunk(long playbackPositionUs, long loadPositionUs, List<HlsMediaChunk> queue, HlsChunkHolder out) {
        HlsMediaChunk previous = queue.isEmpty() ? null : queue.get(queue.size() - 1);
        int oldTrackIndex = previous == null ? -1 : this.trackGroup.indexOf(previous.trackFormat);
        long bufferedDurationUs = loadPositionUs - playbackPositionUs;
        long timeToLiveEdgeUs = this.resolveTimeToLiveEdgeUs(playbackPositionUs);
        if (previous != null && !this.independentSegments) {
            long subtractedDurationUs = previous.getDurationUs();
            bufferedDurationUs = Math.max(0L, bufferedDurationUs - subtractedDurationUs);
            if (timeToLiveEdgeUs != -9223372036854775807L) {
                timeToLiveEdgeUs = Math.max(0L, timeToLiveEdgeUs - subtractedDurationUs);
            }
        }
        MediaChunkIterator[] mediaChunkIterators = this.createMediaChunkIterators(previous, loadPositionUs);
        this.trackSelection.updateSelectedTrack(playbackPositionUs, bufferedDurationUs, timeToLiveEdgeUs, queue, mediaChunkIterators);
        int selectedTrackIndex = this.trackSelection.getSelectedIndexInTrackGroup();
        boolean switchingTrack = oldTrackIndex != selectedTrackIndex;
        Uri selectedPlaylistUrl = this.playlistUrls[selectedTrackIndex];
        if (!this.playlistTracker.isSnapshotValid(selectedPlaylistUrl)) {
            out.playlistUrl = selectedPlaylistUrl;
            this.seenExpectedPlaylistError &= selectedPlaylistUrl.equals((Object)this.expectedPlaylistUrl);
            this.expectedPlaylistUrl = selectedPlaylistUrl;
            return;
        }
        HlsMediaPlaylist mediaPlaylist = this.playlistTracker.getPlaylistSnapshot(selectedPlaylistUrl, true);
        this.independentSegments = mediaPlaylist.hasIndependentSegments;
        this.updateLiveEdgeTimeUs(mediaPlaylist);
        long startOfPlaylistInPeriodUs = mediaPlaylist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
        long chunkMediaSequence = this.getChunkMediaSequence(previous, switchingTrack, mediaPlaylist, startOfPlaylistInPeriodUs, loadPositionUs);
        if (chunkMediaSequence < mediaPlaylist.mediaSequence && previous != null && switchingTrack) {
            selectedTrackIndex = oldTrackIndex;
            selectedPlaylistUrl = this.playlistUrls[selectedTrackIndex];
            mediaPlaylist = this.playlistTracker.getPlaylistSnapshot(selectedPlaylistUrl, true);
            startOfPlaylistInPeriodUs = mediaPlaylist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
            chunkMediaSequence = previous.getNextChunkIndex();
        }
        if (chunkMediaSequence < mediaPlaylist.mediaSequence) {
            this.fatalError = new BehindLiveWindowException();
            return;
        }
        int segmentIndexInPlaylist = (int)(chunkMediaSequence - mediaPlaylist.mediaSequence);
        if (segmentIndexInPlaylist >= mediaPlaylist.segments.size()) {
            if (mediaPlaylist.hasEndTag) {
                out.endOfStream = true;
            } else {
                out.playlistUrl = selectedPlaylistUrl;
                this.seenExpectedPlaylistError &= selectedPlaylistUrl.equals((Object)this.expectedPlaylistUrl);
                this.expectedPlaylistUrl = selectedPlaylistUrl;
            }
            return;
        }
        this.seenExpectedPlaylistError = false;
        this.expectedPlaylistUrl = null;
        HlsMediaPlaylist.Segment segment = mediaPlaylist.segments.get(segmentIndexInPlaylist);
        Uri initSegmentKeyUri = HlsChunkSource.getFullEncryptionKeyUri(mediaPlaylist, segment.initializationSegment);
        out.chunk = this.maybeCreateEncryptionChunkFor(initSegmentKeyUri, selectedTrackIndex);
        if (out.chunk != null) {
            return;
        }
        Uri mediaSegmentKeyUri = HlsChunkSource.getFullEncryptionKeyUri(mediaPlaylist, segment);
        out.chunk = this.maybeCreateEncryptionChunkFor(mediaSegmentKeyUri, selectedTrackIndex);
        if (out.chunk != null) {
            return;
        }
        out.chunk = HlsMediaChunk.createInstance(this.extractorFactory, this.mediaDataSource, this.playlistFormats[selectedTrackIndex], startOfPlaylistInPeriodUs, mediaPlaylist, segmentIndexInPlaylist, selectedPlaylistUrl, this.muxedCaptionFormats, this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), this.isTimestampMaster, this.timestampAdjusterProvider, previous, this.keyCache.get(mediaSegmentKeyUri), this.keyCache.get(initSegmentKeyUri));
    }

    public void onChunkLoadCompleted(Chunk chunk) {
        if (chunk instanceof EncryptionKeyChunk) {
            EncryptionKeyChunk encryptionKeyChunk = (EncryptionKeyChunk)chunk;
            this.scratchSpace = encryptionKeyChunk.getDataHolder();
            this.keyCache.put(encryptionKeyChunk.dataSpec.uri, encryptionKeyChunk.getResult());
        }
    }

    public boolean maybeBlacklistTrack(Chunk chunk, long blacklistDurationMs) {
        return this.trackSelection.blacklist(this.trackSelection.indexOf(this.trackGroup.indexOf(chunk.trackFormat)), blacklistDurationMs);
    }

    public boolean onPlaylistError(Uri playlistUrl, long blacklistDurationMs) {
        int trackGroupIndex = -1;
        for (int i = 0; i < this.playlistUrls.length; ++i) {
            if (!this.playlistUrls[i].equals((Object)playlistUrl)) continue;
            trackGroupIndex = i;
            break;
        }
        if (trackGroupIndex == -1) {
            return true;
        }
        int trackSelectionIndex = this.trackSelection.indexOf(trackGroupIndex);
        if (trackSelectionIndex == -1) {
            return true;
        }
        this.seenExpectedPlaylistError |= playlistUrl.equals((Object)this.expectedPlaylistUrl);
        return blacklistDurationMs == -9223372036854775807L || this.trackSelection.blacklist(trackSelectionIndex, blacklistDurationMs);
    }

    public MediaChunkIterator[] createMediaChunkIterators(@Nullable HlsMediaChunk previous, long loadPositionUs) {
        int oldTrackIndex = previous == null ? -1 : this.trackGroup.indexOf(previous.trackFormat);
        MediaChunkIterator[] chunkIterators = new MediaChunkIterator[this.trackSelection.length()];
        for (int i = 0; i < chunkIterators.length; ++i) {
            long startOfPlaylistInPeriodUs;
            HlsMediaPlaylist playlist;
            int trackIndex = this.trackSelection.getIndexInTrackGroup(i);
            Uri playlistUrl = this.playlistUrls[trackIndex];
            if (!this.playlistTracker.isSnapshotValid(playlistUrl)) {
                chunkIterators[i] = MediaChunkIterator.EMPTY;
                continue;
            }
            boolean switchingTrack = trackIndex != oldTrackIndex;
            long chunkMediaSequence = this.getChunkMediaSequence(previous, switchingTrack, playlist = this.playlistTracker.getPlaylistSnapshot(playlistUrl, false), startOfPlaylistInPeriodUs = playlist.startTimeUs - this.playlistTracker.getInitialStartTimeUs(), loadPositionUs);
            if (chunkMediaSequence < playlist.mediaSequence) {
                chunkIterators[i] = MediaChunkIterator.EMPTY;
                continue;
            }
            int chunkIndex = (int)(chunkMediaSequence - playlist.mediaSequence);
            chunkIterators[i] = new HlsMediaPlaylistSegmentIterator(playlist, startOfPlaylistInPeriodUs, chunkIndex);
        }
        return chunkIterators;
    }

    private long getChunkMediaSequence(@Nullable HlsMediaChunk previous, boolean switchingTrack, HlsMediaPlaylist mediaPlaylist, long startOfPlaylistInPeriodUs, long loadPositionUs) {
        if (previous == null || switchingTrack) {
            long targetPositionInPeriodUs;
            long endOfPlaylistInPeriodUs = startOfPlaylistInPeriodUs + mediaPlaylist.durationUs;
            long l = targetPositionInPeriodUs = previous == null || this.independentSegments ? loadPositionUs : previous.startTimeUs;
            if (!mediaPlaylist.hasEndTag && targetPositionInPeriodUs >= endOfPlaylistInPeriodUs) {
                return mediaPlaylist.mediaSequence + (long)mediaPlaylist.segments.size();
            }
            long targetPositionInPlaylistUs = targetPositionInPeriodUs - startOfPlaylistInPeriodUs;
            return (long)Util.binarySearchFloor(mediaPlaylist.segments, (Comparable)Long.valueOf(targetPositionInPlaylistUs), (boolean)true, (!this.playlistTracker.isLive() || previous == null ? 1 : 0) != 0) + mediaPlaylist.mediaSequence;
        }
        return previous.getNextChunkIndex();
    }

    private long resolveTimeToLiveEdgeUs(long playbackPositionUs) {
        boolean resolveTimeToLiveEdgePossible = this.liveEdgeInPeriodTimeUs != -9223372036854775807L;
        return resolveTimeToLiveEdgePossible ? this.liveEdgeInPeriodTimeUs - playbackPositionUs : -9223372036854775807L;
    }

    private void updateLiveEdgeTimeUs(HlsMediaPlaylist mediaPlaylist) {
        this.liveEdgeInPeriodTimeUs = mediaPlaylist.hasEndTag ? -9223372036854775807L : mediaPlaylist.getEndTimeUs() - this.playlistTracker.getInitialStartTimeUs();
    }

    @Nullable
    private Chunk maybeCreateEncryptionChunkFor(@Nullable Uri keyUri, int selectedTrackIndex) {
        if (keyUri == null) {
            return null;
        }
        if (this.keyCache.containsKey(keyUri)) {
            this.keyCache.put(keyUri, (byte[])this.keyCache.remove(keyUri));
            return null;
        }
        DataSpec dataSpec = new DataSpec(keyUri, 0L, -1L, null, 1);
        return new EncryptionKeyChunk(this.encryptionDataSource, dataSpec, this.playlistFormats[selectedTrackIndex], this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), this.scratchSpace);
    }

    @Nullable
    private static Uri getFullEncryptionKeyUri(HlsMediaPlaylist playlist, @Nullable HlsMediaPlaylist.Segment segment) {
        if (segment == null || segment.fullSegmentEncryptionKeyUri == null) {
            return null;
        }
        return UriUtil.resolveToUri((String)playlist.baseUri, (String)segment.fullSegmentEncryptionKeyUri);
    }

    private static final class FullSegmentEncryptionKeyCache
    extends LinkedHashMap<Uri, byte[]> {
        public FullSegmentEncryptionKeyCache() {
            super(8, 1.0f, false);
        }

        @Override
        public byte[] get(Object keyUri) {
            if (keyUri == null) {
                return null;
            }
            return (byte[])super.get(keyUri);
        }

        @Override
        public byte[] put(Uri keyUri, byte[] key) {
            return (byte[])super.put(keyUri, Assertions.checkNotNull((Object)key));
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Uri, byte[]> entry) {
            return this.size() > 4;
        }
    }

    private static final class HlsMediaPlaylistSegmentIterator
    extends BaseMediaChunkIterator {
        private final HlsMediaPlaylist playlist;
        private final long startOfPlaylistInPeriodUs;

        public HlsMediaPlaylistSegmentIterator(HlsMediaPlaylist playlist, long startOfPlaylistInPeriodUs, int chunkIndex) {
            super((long)chunkIndex, (long)(playlist.segments.size() - 1));
            this.playlist = playlist;
            this.startOfPlaylistInPeriodUs = startOfPlaylistInPeriodUs;
        }

        public DataSpec getDataSpec() {
            this.checkInBounds();
            HlsMediaPlaylist.Segment segment = this.playlist.segments.get((int)this.getCurrentIndex());
            Uri chunkUri = UriUtil.resolveToUri((String)this.playlist.baseUri, (String)segment.url);
            return new DataSpec(chunkUri, segment.byterangeOffset, segment.byterangeLength, null);
        }

        public long getChunkStartTimeUs() {
            this.checkInBounds();
            HlsMediaPlaylist.Segment segment = this.playlist.segments.get((int)this.getCurrentIndex());
            return this.startOfPlaylistInPeriodUs + segment.relativeStartTimeUs;
        }

        public long getChunkEndTimeUs() {
            this.checkInBounds();
            HlsMediaPlaylist.Segment segment = this.playlist.segments.get((int)this.getCurrentIndex());
            long segmentStartTimeInPeriodUs = this.startOfPlaylistInPeriodUs + segment.relativeStartTimeUs;
            return segmentStartTimeInPeriodUs + segment.durationUs;
        }
    }

    private static final class EncryptionKeyChunk
    extends DataChunk {
        private byte[] result;

        public EncryptionKeyChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, Object trackSelectionData, byte[] scratchSpace) {
            super(dataSource, dataSpec, 3, trackFormat, trackSelectionReason, trackSelectionData, scratchSpace);
        }

        protected void consume(byte[] data, int limit) {
            this.result = Arrays.copyOf(data, limit);
        }

        public byte[] getResult() {
            return this.result;
        }
    }

    private static final class InitializationTrackSelection
    extends BaseTrackSelection {
        private int selectedIndex;

        public InitializationTrackSelection(TrackGroup group, int[] tracks) {
            super(group, tracks);
            this.selectedIndex = this.indexOf(group.getFormat(0));
        }

        public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
            long nowMs = SystemClock.elapsedRealtime();
            if (!this.isBlacklisted(this.selectedIndex, nowMs)) {
                return;
            }
            for (int i = this.length - 1; i >= 0; --i) {
                if (this.isBlacklisted(i, nowMs)) continue;
                this.selectedIndex = i;
                return;
            }
            throw new IllegalStateException();
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public int getSelectionReason() {
            return 0;
        }

        public Object getSelectionData() {
            return null;
        }
    }

    public static final class HlsChunkHolder {
        public Chunk chunk;
        public boolean endOfStream;
        public Uri playlistUrl;

        public HlsChunkHolder() {
            this.clear();
        }

        public void clear() {
            this.chunk = null;
            this.endOfStream = false;
            this.playlistUrl = null;
        }
    }
}

