/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp4;

import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;

final class Sniffer {
    private static final int SEARCH_LENGTH = 4096;
    private static final int[] COMPATIBLE_BRANDS = new int[]{1769172845, 1769172786, 1769172787, 1769172788, 1769172789, 1769172790, 1769172793, 1635148593, 1752589105, 1751479857, 1635135537, 1836069937, 1836069938, 862401121, 862401122, 862417462, 0x33677336, 862414134, 0x33676736, 1295275552, 1295270176, 1714714144, 1801741417, 1295275600, 1903435808, 1297305174, 1684175153, 1769172332, 1885955686};

    public static boolean sniffFragmented(ExtractorInput input) throws IOException {
        return Sniffer.sniffInternal(input, true);
    }

    public static boolean sniffUnfragmented(ExtractorInput input) throws IOException {
        return Sniffer.sniffInternal(input, false);
    }

    private static boolean sniffInternal(ExtractorInput input, boolean fragmented) throws IOException {
        long inputLength = input.getLength();
        int bytesToSearch = (int)(inputLength == -1L || inputLength > 4096L ? 4096L : inputLength);
        ParsableByteArray buffer = new ParsableByteArray(64);
        int bytesSearched = 0;
        boolean foundGoodFileType = false;
        boolean isFragmented = false;
        while (bytesSearched < bytesToSearch) {
            long fileEndPosition;
            int headerSize = 8;
            buffer.reset(headerSize);
            boolean success = input.peekFully(buffer.getData(), 0, headerSize, true);
            if (!success) break;
            long atomSize = buffer.readUnsignedInt();
            int atomType = buffer.readInt();
            if (atomSize == 1L) {
                headerSize = 16;
                input.peekFully(buffer.getData(), 8, 8);
                buffer.setLimit(16);
                atomSize = buffer.readLong();
            } else if (atomSize == 0L && (fileEndPosition = input.getLength()) != -1L) {
                atomSize = fileEndPosition - input.getPeekPosition() + (long)headerSize;
            }
            if (atomSize < (long)headerSize) {
                return false;
            }
            bytesSearched += headerSize;
            if (atomType == 1836019574) {
                if (inputLength == -1L || (long)(bytesToSearch += (int)atomSize) <= inputLength) continue;
                bytesToSearch = (int)inputLength;
                continue;
            }
            if (atomType == 0x6D6F6F66 || atomType == 1836475768) {
                isFragmented = true;
                break;
            }
            if ((long)bytesSearched + atomSize - (long)headerSize >= (long)bytesToSearch) break;
            int atomDataSize = (int)(atomSize - (long)headerSize);
            bytesSearched += atomDataSize;
            if (atomType == 1718909296) {
                if (atomDataSize < 8) {
                    return false;
                }
                buffer.reset(atomDataSize);
                input.peekFully(buffer.getData(), 0, atomDataSize);
                int brandsCount = atomDataSize / 4;
                for (int i = 0; i < brandsCount; ++i) {
                    if (i == 1) {
                        buffer.skipBytes(4);
                        continue;
                    }
                    if (!Sniffer.isCompatibleBrand(buffer.readInt())) continue;
                    foundGoodFileType = true;
                    break;
                }
                if (foundGoodFileType) continue;
                return false;
            }
            if (atomDataSize == 0) continue;
            input.advancePeekPosition(atomDataSize);
        }
        return foundGoodFileType && fragmented == isFragmented;
    }

    private static boolean isCompatibleBrand(int brand) {
        if (brand >>> 8 == 3368816) {
            return true;
        }
        for (int compatibleBrand : COMPATIBLE_BRANDS) {
            if (compatibleBrand != brand) continue;
            return true;
        }
        return false;
    }

    private Sniffer() {
    }
}

