/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.offline;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.offline.DownloadException;
import com.google.android.exoplayer2.offline.DownloaderConstructorHelper;
import com.google.android.exoplayer2.offline.SegmentDownloader;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.DashUtil;
import com.google.android.exoplayer2.source.dash.DashWrappingSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.RepresentationKey;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DashDownloader
extends SegmentDownloader<DashManifest, RepresentationKey> {
    public DashDownloader(Uri manifestUri, List<RepresentationKey> representationKeys, DownloaderConstructorHelper constructorHelper) {
        super(manifestUri, representationKeys, constructorHelper);
    }

    protected DashManifest getManifest(DataSource dataSource, Uri uri) throws IOException {
        return DashUtil.loadManifest(dataSource, uri);
    }

    protected List<SegmentDownloader.Segment> getSegments(DataSource dataSource, DashManifest manifest, boolean allowIncompleteList) throws InterruptedException, IOException {
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        for (int i = 0; i < manifest.getPeriodCount(); ++i) {
            Period period = manifest.getPeriod(i);
            long periodStartUs = C.msToUs((long)period.startMs);
            long periodDurationUs = manifest.getPeriodDurationUs(i);
            List<AdaptationSet> adaptationSets = period.adaptationSets;
            for (int j = 0; j < adaptationSets.size(); ++j) {
                DashDownloader.addSegmentsForAdaptationSet(dataSource, adaptationSets.get(j), periodStartUs, periodDurationUs, allowIncompleteList, segments);
            }
        }
        return segments;
    }

    private static void addSegmentsForAdaptationSet(DataSource dataSource, AdaptationSet adaptationSet, long periodStartUs, long periodDurationUs, boolean allowIncompleteList, ArrayList<SegmentDownloader.Segment> out) throws IOException, InterruptedException {
        for (int i = 0; i < adaptationSet.representations.size(); ++i) {
            RangedUri indexUri;
            DashSegmentIndex index;
            Representation representation = adaptationSet.representations.get(i);
            try {
                index = DashDownloader.getSegmentIndex(dataSource, adaptationSet.type, representation);
                if (index == null) {
                    throw new DownloadException("Missing segment index");
                }
            }
            catch (IOException e) {
                if (allowIncompleteList) continue;
                throw e;
            }
            int segmentCount = index.getSegmentCount(periodDurationUs);
            if (segmentCount == -1) {
                throw new DownloadException("Unbounded segment index");
            }
            String baseUrl = representation.baseUrl;
            RangedUri initializationUri = representation.getInitializationUri();
            if (initializationUri != null) {
                DashDownloader.addSegment(periodStartUs, baseUrl, initializationUri, out);
            }
            if ((indexUri = representation.getIndexUri()) != null) {
                DashDownloader.addSegment(periodStartUs, baseUrl, indexUri, out);
            }
            long firstSegmentNum = index.getFirstSegmentNum();
            long lastSegmentNum = firstSegmentNum + (long)segmentCount - 1L;
            for (long j = firstSegmentNum; j <= lastSegmentNum; ++j) {
                DashDownloader.addSegment(periodStartUs + index.getTimeUs(j), baseUrl, index.getSegmentUrl(j), out);
            }
        }
    }

    private static void addSegment(long startTimeUs, String baseUrl, RangedUri rangedUri, ArrayList<SegmentDownloader.Segment> out) {
        DataSpec dataSpec = new DataSpec(rangedUri.resolveUri(baseUrl), rangedUri.start, rangedUri.length, null);
        out.add(new SegmentDownloader.Segment(startTimeUs, dataSpec));
    }

    @Nullable
    private static DashSegmentIndex getSegmentIndex(DataSource dataSource, int trackType, Representation representation) throws IOException, InterruptedException {
        DashSegmentIndex index = representation.getIndex();
        if (index != null) {
            return index;
        }
        ChunkIndex seekMap = DashUtil.loadChunkIndex(dataSource, trackType, representation);
        return seekMap == null ? null : new DashWrappingSegmentIndex(seekMap, representation.presentationTimeOffsetUs);
    }
}

