/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import android.util.Xml;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.Descriptor;
import com.google.android.exoplayer2.source.dash.manifest.EventStream;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.SegmentBase;
import com.google.android.exoplayer2.source.dash.manifest.UrlTemplate;
import com.google.android.exoplayer2.source.dash.manifest.UtcTimingElement;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.UriUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.util.XmlPullParserUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class DashManifestParser
extends DefaultHandler
implements ParsingLoadable.Parser<DashManifest> {
    private static final String TAG = "MpdParser";
    private static final Pattern FRAME_RATE_PATTERN = Pattern.compile("(\\d+)(?:/(\\d+))?");
    private static final Pattern CEA_608_ACCESSIBILITY_PATTERN = Pattern.compile("CC([1-4])=.*");
    private static final Pattern CEA_708_ACCESSIBILITY_PATTERN = Pattern.compile("([1-9]|[1-5][0-9]|6[0-3])=.*");
    private final String contentId;
    private final XmlPullParserFactory xmlParserFactory;

    public DashManifestParser() {
        this(null);
    }

    public DashManifestParser(String contentId) {
        this.contentId = contentId;
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    public DashManifest parse(Uri uri, InputStream inputStream) throws IOException {
        try {
            XmlPullParser xpp = this.xmlParserFactory.newPullParser();
            xpp.setInput(inputStream, null);
            int eventType = xpp.next();
            if (eventType != 2 || !"MPD".equals(xpp.getName())) {
                throw new ParserException("inputStream does not contain a valid media presentation description");
            }
            return this.parseMediaPresentationDescription(xpp, uri.toString());
        }
        catch (XmlPullParserException e) {
            throw new ParserException((Throwable)e);
        }
    }

    protected DashManifest parseMediaPresentationDescription(XmlPullParser xpp, String baseUrl) throws XmlPullParserException, IOException {
        long availabilityStartTime = DashManifestParser.parseDateTime(xpp, "availabilityStartTime", -9223372036854775807L);
        long durationMs = DashManifestParser.parseDuration(xpp, "mediaPresentationDuration", -9223372036854775807L);
        long minBufferTimeMs = DashManifestParser.parseDuration(xpp, "minBufferTime", -9223372036854775807L);
        String typeString = xpp.getAttributeValue(null, "type");
        boolean dynamic = typeString != null && "dynamic".equals(typeString);
        long minUpdateTimeMs = dynamic ? DashManifestParser.parseDuration(xpp, "minimumUpdatePeriod", -9223372036854775807L) : -9223372036854775807L;
        long timeShiftBufferDepthMs = dynamic ? DashManifestParser.parseDuration(xpp, "timeShiftBufferDepth", -9223372036854775807L) : -9223372036854775807L;
        long suggestedPresentationDelayMs = dynamic ? DashManifestParser.parseDuration(xpp, "suggestedPresentationDelay", -9223372036854775807L) : -9223372036854775807L;
        long publishTimeMs = DashManifestParser.parseDateTime(xpp, "publishTime", -9223372036854775807L);
        UtcTimingElement utcTiming = null;
        Uri location = null;
        ArrayList<Period> periods = new ArrayList<Period>();
        long nextPeriodStartMs = dynamic ? -9223372036854775807L : 0L;
        boolean seenEarlyAccessPeriod = false;
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = DashManifestParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"UTCTiming")) {
                utcTiming = this.parseUtcTiming(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Location")) {
                location = Uri.parse((String)xpp.nextText());
                continue;
            }
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Period") || seenEarlyAccessPeriod) continue;
            Pair<Period, Long> periodWithDurationMs = this.parsePeriod(xpp, baseUrl, nextPeriodStartMs);
            Period period = (Period)periodWithDurationMs.first;
            if (period.startMs == -9223372036854775807L) {
                if (dynamic) {
                    seenEarlyAccessPeriod = true;
                    continue;
                }
                throw new ParserException("Unable to determine start of period " + periods.size());
            }
            long periodDurationMs = (Long)periodWithDurationMs.second;
            nextPeriodStartMs = periodDurationMs == -9223372036854775807L ? -9223372036854775807L : period.startMs + periodDurationMs;
            periods.add(period);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"MPD"));
        if (durationMs == -9223372036854775807L) {
            if (nextPeriodStartMs != -9223372036854775807L) {
                durationMs = nextPeriodStartMs;
            } else if (!dynamic) {
                throw new ParserException("Unable to determine duration of static manifest.");
            }
        }
        if (periods.isEmpty()) {
            throw new ParserException("No periods found.");
        }
        return this.buildMediaPresentationDescription(availabilityStartTime, durationMs, minBufferTimeMs, dynamic, minUpdateTimeMs, timeShiftBufferDepthMs, suggestedPresentationDelayMs, publishTimeMs, utcTiming, location, periods);
    }

    protected DashManifest buildMediaPresentationDescription(long availabilityStartTime, long durationMs, long minBufferTimeMs, boolean dynamic, long minUpdateTimeMs, long timeShiftBufferDepthMs, long suggestedPresentationDelayMs, long publishTimeMs, UtcTimingElement utcTiming, Uri location, List<Period> periods) {
        return new DashManifest(availabilityStartTime, durationMs, minBufferTimeMs, dynamic, minUpdateTimeMs, timeShiftBufferDepthMs, suggestedPresentationDelayMs, publishTimeMs, utcTiming, location, periods);
    }

    protected UtcTimingElement parseUtcTiming(XmlPullParser xpp) {
        String schemeIdUri = xpp.getAttributeValue(null, "schemeIdUri");
        String value = xpp.getAttributeValue(null, "value");
        return this.buildUtcTimingElement(schemeIdUri, value);
    }

    protected UtcTimingElement buildUtcTimingElement(String schemeIdUri, String value) {
        return new UtcTimingElement(schemeIdUri, value);
    }

    protected Pair<Period, Long> parsePeriod(XmlPullParser xpp, String baseUrl, long defaultStartMs) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        long startMs = DashManifestParser.parseDuration(xpp, "start", defaultStartMs);
        long durationMs = DashManifestParser.parseDuration(xpp, "duration", -9223372036854775807L);
        SegmentBase segmentBase = null;
        ArrayList<AdaptationSet> adaptationSets = new ArrayList<AdaptationSet>();
        ArrayList<EventStream> eventStreams = new ArrayList<EventStream>();
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = DashManifestParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"AdaptationSet")) {
                adaptationSets.add(this.parseAdaptationSet(xpp, baseUrl, segmentBase));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"EventStream")) {
                eventStreams.add(this.parseEventStream(xpp));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, null);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, null);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentTemplate")) continue;
            segmentBase = this.parseSegmentTemplate(xpp, null);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"Period"));
        return Pair.create((Object)this.buildPeriod(id, startMs, adaptationSets, eventStreams), (Object)durationMs);
    }

    protected Period buildPeriod(String id, long startMs, List<AdaptationSet> adaptationSets, List<EventStream> eventStreams) {
        return new Period(id, startMs, adaptationSets, eventStreams);
    }

    protected AdaptationSet parseAdaptationSet(XmlPullParser xpp, String baseUrl, SegmentBase segmentBase) throws XmlPullParserException, IOException {
        int id = DashManifestParser.parseInt(xpp, "id", -1);
        int contentType = this.parseContentType(xpp);
        String mimeType = xpp.getAttributeValue(null, "mimeType");
        String codecs = xpp.getAttributeValue(null, "codecs");
        int width = DashManifestParser.parseInt(xpp, "width", -1);
        int height = DashManifestParser.parseInt(xpp, "height", -1);
        float frameRate = DashManifestParser.parseFrameRate(xpp, -1.0f);
        int audioChannels = -1;
        int audioSamplingRate = DashManifestParser.parseInt(xpp, "audioSamplingRate", -1);
        String language = xpp.getAttributeValue(null, "lang");
        String drmSchemeType = null;
        ArrayList<DrmInitData.SchemeData> drmSchemeDatas = new ArrayList<DrmInitData.SchemeData>();
        ArrayList<Descriptor> inbandEventStreams = new ArrayList<Descriptor>();
        ArrayList<Descriptor> accessibilityDescriptors = new ArrayList<Descriptor>();
        ArrayList<Descriptor> supplementalProperties = new ArrayList<Descriptor>();
        ArrayList<RepresentationInfo> representationInfos = new ArrayList<RepresentationInfo>();
        int selectionFlags = 0;
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = DashManifestParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"ContentProtection")) {
                Pair<String, DrmInitData.SchemeData> contentProtection = this.parseContentProtection(xpp);
                if (contentProtection.first != null) {
                    drmSchemeType = (String)contentProtection.first;
                }
                if (contentProtection.second == null) continue;
                drmSchemeDatas.add((DrmInitData.SchemeData)contentProtection.second);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"ContentComponent")) {
                language = DashManifestParser.checkLanguageConsistency(language, xpp.getAttributeValue(null, "lang"));
                contentType = DashManifestParser.checkContentTypeConsistency(contentType, this.parseContentType(xpp));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Role")) {
                selectionFlags |= this.parseRole(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"AudioChannelConfiguration")) {
                audioChannels = this.parseAudioChannelConfiguration(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Accessibility")) {
                accessibilityDescriptors.add(DashManifestParser.parseDescriptor(xpp, "Accessibility"));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SupplementalProperty")) {
                supplementalProperties.add(DashManifestParser.parseDescriptor(xpp, "SupplementalProperty"));
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Representation")) {
                RepresentationInfo representationInfo = this.parseRepresentation(xpp, baseUrl, mimeType, codecs, width, height, frameRate, audioChannels, audioSamplingRate, language, selectionFlags, accessibilityDescriptors, segmentBase);
                contentType = DashManifestParser.checkContentTypeConsistency(contentType, this.getContentType(representationInfo.format));
                representationInfos.add(representationInfo);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, (SegmentBase.SegmentList)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentTemplate")) {
                segmentBase = this.parseSegmentTemplate(xpp, (SegmentBase.SegmentTemplate)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"InbandEventStream")) {
                inbandEventStreams.add(DashManifestParser.parseDescriptor(xpp, "InbandEventStream"));
                continue;
            }
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp)) continue;
            this.parseAdaptationSetChild(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"AdaptationSet"));
        ArrayList<Representation> representations = new ArrayList<Representation>(representationInfos.size());
        for (int i = 0; i < representationInfos.size(); ++i) {
            representations.add(this.buildRepresentation((RepresentationInfo)representationInfos.get(i), this.contentId, drmSchemeType, drmSchemeDatas, inbandEventStreams));
        }
        return this.buildAdaptationSet(id, contentType, representations, accessibilityDescriptors, supplementalProperties);
    }

    protected AdaptationSet buildAdaptationSet(int id, int contentType, List<Representation> representations, List<Descriptor> accessibilityDescriptors, List<Descriptor> supplementalProperties) {
        return new AdaptationSet(id, contentType, representations, accessibilityDescriptors, supplementalProperties);
    }

    protected int parseContentType(XmlPullParser xpp) {
        String contentType = xpp.getAttributeValue(null, "contentType");
        return TextUtils.isEmpty((CharSequence)contentType) ? -1 : ("audio".equals(contentType) ? 1 : ("video".equals(contentType) ? 2 : ("text".equals(contentType) ? 3 : -1)));
    }

    protected int getContentType(Format format) {
        String sampleMimeType = format.sampleMimeType;
        if (TextUtils.isEmpty((CharSequence)sampleMimeType)) {
            return -1;
        }
        if (MimeTypes.isVideo((String)sampleMimeType)) {
            return 2;
        }
        if (MimeTypes.isAudio((String)sampleMimeType)) {
            return 1;
        }
        if (DashManifestParser.mimeTypeIsRawText(sampleMimeType)) {
            return 3;
        }
        return -1;
    }

    protected Pair<String, DrmInitData.SchemeData> parseContentProtection(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String schemeType = null;
        String licenseServerUrl = null;
        byte[] data = null;
        UUID uuid = null;
        boolean requiresSecureDecoder = false;
        String schemeIdUri = xpp.getAttributeValue(null, "schemeIdUri");
        if (schemeIdUri != null) {
            switch (Util.toLowerInvariant((String)schemeIdUri)) {
                case "urn:mpeg:dash:mp4protection:2011": {
                    schemeType = xpp.getAttributeValue(null, "value");
                    String defaultKid = XmlPullParserUtil.getAttributeValueIgnorePrefix((XmlPullParser)xpp, (String)"default_KID");
                    if (TextUtils.isEmpty((CharSequence)defaultKid) || "00000000-0000-0000-0000-000000000000".equals(defaultKid)) break;
                    String[] defaultKidStrings = defaultKid.split("\\s+");
                    UUID[] defaultKids = new UUID[defaultKidStrings.length];
                    for (int i = 0; i < defaultKidStrings.length; ++i) {
                        defaultKids[i] = UUID.fromString(defaultKidStrings[i]);
                    }
                    data = PsshAtomUtil.buildPsshAtom((UUID)C.COMMON_PSSH_UUID, (UUID[])defaultKids, null);
                    uuid = C.COMMON_PSSH_UUID;
                    break;
                }
                case "urn:uuid:9a04f079-9840-4286-ab92-e65be0885f95": {
                    uuid = C.PLAYREADY_UUID;
                    break;
                }
                case "urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed": {
                    uuid = C.WIDEVINE_UUID;
                    break;
                }
            }
        }
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"ms:laurl")) {
                licenseServerUrl = xpp.getAttributeValue(null, "licenseUrl");
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"widevine:license")) {
                String robustnessLevel = xpp.getAttributeValue(null, "robustness_level");
                requiresSecureDecoder = robustnessLevel != null && robustnessLevel.startsWith("HW");
                continue;
            }
            if (data != null) continue;
            if (XmlPullParserUtil.isStartTagIgnorePrefix((XmlPullParser)xpp, (String)"pssh") && xpp.next() == 4) {
                data = Base64.decode((String)xpp.getText(), (int)0);
                uuid = PsshAtomUtil.parseUuid((byte[])data);
                if (uuid != null) continue;
                Log.w((String)TAG, (String)"Skipping malformed cenc:pssh data");
                data = null;
                continue;
            }
            if (!C.PLAYREADY_UUID.equals(uuid) || !XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"mspr:pro") || xpp.next() != 4) continue;
            data = PsshAtomUtil.buildPsshAtom((UUID)C.PLAYREADY_UUID, (byte[])Base64.decode((String)xpp.getText(), (int)0));
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"ContentProtection"));
        DrmInitData.SchemeData schemeData = uuid != null ? new DrmInitData.SchemeData(uuid, licenseServerUrl, "video/mp4", data, requiresSecureDecoder) : null;
        return Pair.create((Object)schemeType, (Object)schemeData);
    }

    protected int parseRole(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String schemeIdUri = DashManifestParser.parseString(xpp, "schemeIdUri", null);
        String value = DashManifestParser.parseString(xpp, "value", null);
        do {
            xpp.next();
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"Role"));
        return "urn:mpeg:dash:role:2011".equals(schemeIdUri) && "main".equals(value) ? 1 : 0;
    }

    protected void parseAdaptationSetChild(XmlPullParser xpp) throws XmlPullParserException, IOException {
    }

    protected RepresentationInfo parseRepresentation(XmlPullParser xpp, String baseUrl, String adaptationSetMimeType, String adaptationSetCodecs, int adaptationSetWidth, int adaptationSetHeight, float adaptationSetFrameRate, int adaptationSetAudioChannels, int adaptationSetAudioSamplingRate, String adaptationSetLanguage, int adaptationSetSelectionFlags, List<Descriptor> adaptationSetAccessibilityDescriptors, SegmentBase segmentBase) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        int bandwidth = DashManifestParser.parseInt(xpp, "bandwidth", -1);
        String mimeType = DashManifestParser.parseString(xpp, "mimeType", adaptationSetMimeType);
        String codecs = DashManifestParser.parseString(xpp, "codecs", adaptationSetCodecs);
        int width = DashManifestParser.parseInt(xpp, "width", adaptationSetWidth);
        int height = DashManifestParser.parseInt(xpp, "height", adaptationSetHeight);
        float frameRate = DashManifestParser.parseFrameRate(xpp, adaptationSetFrameRate);
        int audioChannels = adaptationSetAudioChannels;
        int audioSamplingRate = DashManifestParser.parseInt(xpp, "audioSamplingRate", adaptationSetAudioSamplingRate);
        String drmSchemeType = null;
        ArrayList<DrmInitData.SchemeData> drmSchemeDatas = new ArrayList<DrmInitData.SchemeData>();
        ArrayList<Descriptor> inbandEventStreams = new ArrayList<Descriptor>();
        ArrayList<Descriptor> supplementalProperties = new ArrayList<Descriptor>();
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = DashManifestParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"AudioChannelConfiguration")) {
                audioChannels = this.parseAudioChannelConfiguration(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, (SegmentBase.SegmentList)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentTemplate")) {
                segmentBase = this.parseSegmentTemplate(xpp, (SegmentBase.SegmentTemplate)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"ContentProtection")) {
                Pair<String, DrmInitData.SchemeData> contentProtection = this.parseContentProtection(xpp);
                if (contentProtection.first != null) {
                    drmSchemeType = (String)contentProtection.first;
                }
                if (contentProtection.second == null) continue;
                drmSchemeDatas.add((DrmInitData.SchemeData)contentProtection.second);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"InbandEventStream")) {
                inbandEventStreams.add(DashManifestParser.parseDescriptor(xpp, "InbandEventStream"));
                continue;
            }
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SupplementalProperty")) continue;
            supplementalProperties.add(DashManifestParser.parseDescriptor(xpp, "SupplementalProperty"));
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"Representation"));
        Format format = this.buildFormat(id, mimeType, width, height, frameRate, audioChannels, audioSamplingRate, bandwidth, adaptationSetLanguage, adaptationSetSelectionFlags, adaptationSetAccessibilityDescriptors, codecs, supplementalProperties);
        segmentBase = segmentBase != null ? segmentBase : new SegmentBase.SingleSegmentBase();
        return new RepresentationInfo(format, baseUrl, segmentBase, drmSchemeType, drmSchemeDatas, inbandEventStreams, -1L);
    }

    protected Format buildFormat(String id, String containerMimeType, int width, int height, float frameRate, int audioChannels, int audioSamplingRate, int bitrate, String language, int selectionFlags, List<Descriptor> accessibilityDescriptors, String codecs, List<Descriptor> supplementalProperties) {
        String sampleMimeType = DashManifestParser.getSampleMimeType(containerMimeType, codecs);
        if (sampleMimeType != null) {
            if ("audio/eac3".equals(sampleMimeType)) {
                sampleMimeType = DashManifestParser.parseEac3SupplementalProperties(supplementalProperties);
            }
            if (MimeTypes.isVideo((String)sampleMimeType)) {
                return Format.createVideoContainerFormat((String)id, (String)containerMimeType, (String)sampleMimeType, (String)codecs, (int)bitrate, (int)width, (int)height, (float)frameRate, null, (int)selectionFlags);
            }
            if (MimeTypes.isAudio((String)sampleMimeType)) {
                return Format.createAudioContainerFormat((String)id, (String)containerMimeType, (String)sampleMimeType, (String)codecs, (int)bitrate, (int)audioChannels, (int)audioSamplingRate, null, (int)selectionFlags, (String)language);
            }
            if (DashManifestParser.mimeTypeIsRawText(sampleMimeType)) {
                int accessibilityChannel = "application/cea-608".equals(sampleMimeType) ? DashManifestParser.parseCea608AccessibilityChannel(accessibilityDescriptors) : ("application/cea-708".equals(sampleMimeType) ? DashManifestParser.parseCea708AccessibilityChannel(accessibilityDescriptors) : -1);
                return Format.createTextContainerFormat((String)id, (String)containerMimeType, (String)sampleMimeType, (String)codecs, (int)bitrate, (int)selectionFlags, (String)language, (int)accessibilityChannel);
            }
        }
        return Format.createContainerFormat((String)id, (String)containerMimeType, (String)sampleMimeType, (String)codecs, (int)bitrate, (int)selectionFlags, (String)language);
    }

    protected Representation buildRepresentation(RepresentationInfo representationInfo, String contentId, String extraDrmSchemeType, ArrayList<DrmInitData.SchemeData> extraDrmSchemeDatas, ArrayList<Descriptor> extraInbandEventStreams) {
        Format format = representationInfo.format;
        String drmSchemeType = representationInfo.drmSchemeType != null ? representationInfo.drmSchemeType : extraDrmSchemeType;
        ArrayList<DrmInitData.SchemeData> drmSchemeDatas = representationInfo.drmSchemeDatas;
        drmSchemeDatas.addAll(extraDrmSchemeDatas);
        if (!drmSchemeDatas.isEmpty()) {
            DashManifestParser.filterRedundantIncompleteSchemeDatas(drmSchemeDatas);
            DrmInitData drmInitData = new DrmInitData(drmSchemeType, drmSchemeDatas);
            format = format.copyWithDrmInitData(drmInitData);
        }
        ArrayList<Descriptor> inbandEventStreams = representationInfo.inbandEventStreams;
        inbandEventStreams.addAll(extraInbandEventStreams);
        return Representation.newInstance(contentId, representationInfo.revisionId, format, representationInfo.baseUrl, representationInfo.segmentBase, inbandEventStreams);
    }

    protected SegmentBase.SingleSegmentBase parseSegmentBase(XmlPullParser xpp, SegmentBase.SingleSegmentBase parent) throws XmlPullParserException, IOException {
        long timescale = DashManifestParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = DashManifestParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long indexStart = parent != null ? parent.indexStart : 0L;
        long indexLength = parent != null ? parent.indexLength : 0L;
        String indexRangeText = xpp.getAttributeValue(null, "indexRange");
        if (indexRangeText != null) {
            String[] indexRange = indexRangeText.split("-");
            indexStart = Long.parseLong(indexRange[0]);
            indexLength = Long.parseLong(indexRange[1]) - indexStart + 1L;
        }
        RangedUri initialization = parent != null ? parent.initialization : null;
        do {
            xpp.next();
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Initialization")) continue;
            initialization = this.parseInitialization(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"SegmentBase"));
        return this.buildSingleSegmentBase(initialization, timescale, presentationTimeOffset, indexStart, indexLength);
    }

    protected SegmentBase.SingleSegmentBase buildSingleSegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset, long indexStart, long indexLength) {
        return new SegmentBase.SingleSegmentBase(initialization, timescale, presentationTimeOffset, indexStart, indexLength);
    }

    protected SegmentBase.SegmentList parseSegmentList(XmlPullParser xpp, SegmentBase.SegmentList parent) throws XmlPullParserException, IOException {
        long timescale = DashManifestParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = DashManifestParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = DashManifestParser.parseLong(xpp, "duration", parent != null ? parent.duration : -9223372036854775807L);
        long startNumber = DashManifestParser.parseLong(xpp, "startNumber", parent != null ? parent.startNumber : 1L);
        RangedUri initialization = null;
        List timeline = null;
        ArrayList<RangedUri> segments = null;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Initialization")) {
                initialization = this.parseInitialization(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentTimeline")) {
                timeline = this.parseSegmentTimeline(xpp);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentURL")) continue;
            if (segments == null) {
                segments = new ArrayList<RangedUri>();
            }
            segments.add(this.parseSegmentUrl(xpp));
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"SegmentList"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
            segments = segments != null ? segments : parent.mediaSegments;
        }
        return this.buildSegmentList(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, segments);
    }

    protected SegmentBase.SegmentList buildSegmentList(RangedUri initialization, long timescale, long presentationTimeOffset, long startNumber, long duration, List<SegmentBase.SegmentTimelineElement> timeline, List<RangedUri> segments) {
        return new SegmentBase.SegmentList(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, segments);
    }

    protected SegmentBase.SegmentTemplate parseSegmentTemplate(XmlPullParser xpp, SegmentBase.SegmentTemplate parent) throws XmlPullParserException, IOException {
        long timescale = DashManifestParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = DashManifestParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = DashManifestParser.parseLong(xpp, "duration", parent != null ? parent.duration : -9223372036854775807L);
        long startNumber = DashManifestParser.parseLong(xpp, "startNumber", parent != null ? parent.startNumber : 1L);
        UrlTemplate mediaTemplate = this.parseUrlTemplate(xpp, "media", parent != null ? parent.mediaTemplate : null);
        UrlTemplate initializationTemplate = this.parseUrlTemplate(xpp, "initialization", parent != null ? parent.initializationTemplate : null);
        RangedUri initialization = null;
        List timeline = null;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Initialization")) {
                initialization = this.parseInitialization(xpp);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"SegmentTimeline")) continue;
            timeline = this.parseSegmentTimeline(xpp);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"SegmentTemplate"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
        }
        return this.buildSegmentTemplate(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, initializationTemplate, mediaTemplate);
    }

    protected SegmentBase.SegmentTemplate buildSegmentTemplate(RangedUri initialization, long timescale, long presentationTimeOffset, long startNumber, long duration, List<SegmentBase.SegmentTimelineElement> timeline, UrlTemplate initializationTemplate, UrlTemplate mediaTemplate) {
        return new SegmentBase.SegmentTemplate(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, initializationTemplate, mediaTemplate);
    }

    protected EventStream parseEventStream(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String schemeIdUri = DashManifestParser.parseString(xpp, "schemeIdUri", "");
        String value = DashManifestParser.parseString(xpp, "value", "");
        long timescale = DashManifestParser.parseLong(xpp, "timescale", 1L);
        ArrayList<EventMessage> eventMessages = new ArrayList<EventMessage>();
        ByteArrayOutputStream scratchOutputStream = new ByteArrayOutputStream(512);
        do {
            xpp.next();
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"Event")) continue;
            EventMessage event = this.parseEvent(xpp, schemeIdUri, value, timescale, scratchOutputStream);
            eventMessages.add(event);
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"EventStream"));
        long[] presentationTimesUs = new long[eventMessages.size()];
        EventMessage[] events = new EventMessage[eventMessages.size()];
        for (int i = 0; i < eventMessages.size(); ++i) {
            EventMessage event = (EventMessage)eventMessages.get(i);
            presentationTimesUs[i] = event.presentationTimeUs;
            events[i] = event;
        }
        return this.buildEventStream(schemeIdUri, value, timescale, presentationTimesUs, events);
    }

    protected EventStream buildEventStream(String schemeIdUri, String value, long timescale, long[] presentationTimesUs, EventMessage[] events) {
        return new EventStream(schemeIdUri, value, timescale, presentationTimesUs, events);
    }

    protected EventMessage parseEvent(XmlPullParser xpp, String schemeIdUri, String value, long timescale, ByteArrayOutputStream scratchOutputStream) throws IOException, XmlPullParserException {
        long id = DashManifestParser.parseLong(xpp, "id", 0L);
        long duration = DashManifestParser.parseLong(xpp, "duration", -9223372036854775807L);
        long presentationTime = DashManifestParser.parseLong(xpp, "presentationTime", 0L);
        long durationMs = Util.scaleLargeTimestamp((long)duration, (long)1000L, (long)timescale);
        long presentationTimesUs = Util.scaleLargeTimestamp((long)presentationTime, (long)1000000L, (long)timescale);
        byte[] eventObject = this.parseEventObject(xpp, scratchOutputStream);
        return this.buildEvent(schemeIdUri, value, id, durationMs, eventObject, presentationTimesUs);
    }

    protected byte[] parseEventObject(XmlPullParser xpp, ByteArrayOutputStream scratchOutputStream) throws XmlPullParserException, IOException {
        scratchOutputStream.reset();
        XmlSerializer xmlSerializer = Xml.newSerializer();
        xmlSerializer.setOutput((OutputStream)scratchOutputStream, null);
        xpp.nextToken();
        while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"Event")) {
            switch (xpp.getEventType()) {
                case 0: {
                    xmlSerializer.startDocument(null, Boolean.valueOf(false));
                    break;
                }
                case 1: {
                    xmlSerializer.endDocument();
                    break;
                }
                case 2: {
                    xmlSerializer.startTag(xpp.getNamespace(), xpp.getName());
                    for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                        xmlSerializer.attribute(xpp.getAttributeNamespace(i), xpp.getAttributeName(i), xpp.getAttributeValue(i));
                    }
                    break;
                }
                case 3: {
                    xmlSerializer.endTag(xpp.getNamespace(), xpp.getName());
                    break;
                }
                case 4: {
                    xmlSerializer.text(xpp.getText());
                    break;
                }
                case 5: {
                    xmlSerializer.cdsect(xpp.getText());
                    break;
                }
                case 6: {
                    xmlSerializer.entityRef(xpp.getText());
                    break;
                }
                case 7: {
                    xmlSerializer.ignorableWhitespace(xpp.getText());
                    break;
                }
                case 8: {
                    xmlSerializer.processingInstruction(xpp.getText());
                    break;
                }
                case 9: {
                    xmlSerializer.comment(xpp.getText());
                    break;
                }
                case 10: {
                    xmlSerializer.docdecl(xpp.getText());
                    break;
                }
            }
            xpp.nextToken();
        }
        xmlSerializer.flush();
        return scratchOutputStream.toByteArray();
    }

    protected EventMessage buildEvent(String schemeIdUri, String value, long id, long durationMs, byte[] messageData, long presentationTimeUs) {
        return new EventMessage(schemeIdUri, value, durationMs, id, messageData, presentationTimeUs);
    }

    protected List<SegmentBase.SegmentTimelineElement> parseSegmentTimeline(XmlPullParser xpp) throws XmlPullParserException, IOException {
        ArrayList<SegmentBase.SegmentTimelineElement> segmentTimeline = new ArrayList<SegmentBase.SegmentTimelineElement>();
        long elapsedTime = 0L;
        do {
            xpp.next();
            if (!XmlPullParserUtil.isStartTag((XmlPullParser)xpp, (String)"S")) continue;
            elapsedTime = DashManifestParser.parseLong(xpp, "t", elapsedTime);
            long duration = DashManifestParser.parseLong(xpp, "d", -9223372036854775807L);
            int count = 1 + DashManifestParser.parseInt(xpp, "r", 0);
            for (int i = 0; i < count; ++i) {
                segmentTimeline.add(this.buildSegmentTimelineElement(elapsedTime, duration));
                elapsedTime += duration;
            }
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"SegmentTimeline"));
        return segmentTimeline;
    }

    protected SegmentBase.SegmentTimelineElement buildSegmentTimelineElement(long elapsedTime, long duration) {
        return new SegmentBase.SegmentTimelineElement(elapsedTime, duration);
    }

    protected UrlTemplate parseUrlTemplate(XmlPullParser xpp, String name, UrlTemplate defaultValue) {
        String valueString = xpp.getAttributeValue(null, name);
        if (valueString != null) {
            return UrlTemplate.compile(valueString);
        }
        return defaultValue;
    }

    protected RangedUri parseInitialization(XmlPullParser xpp) {
        return this.parseRangedUrl(xpp, "sourceURL", "range");
    }

    protected RangedUri parseSegmentUrl(XmlPullParser xpp) {
        return this.parseRangedUrl(xpp, "media", "mediaRange");
    }

    protected RangedUri parseRangedUrl(XmlPullParser xpp, String urlAttribute, String rangeAttribute) {
        String urlText = xpp.getAttributeValue(null, urlAttribute);
        long rangeStart = 0L;
        long rangeLength = -1L;
        String rangeText = xpp.getAttributeValue(null, rangeAttribute);
        if (rangeText != null) {
            String[] rangeTextArray = rangeText.split("-");
            rangeStart = Long.parseLong(rangeTextArray[0]);
            if (rangeTextArray.length == 2) {
                rangeLength = Long.parseLong(rangeTextArray[1]) - rangeStart + 1L;
            }
        }
        return this.buildRangedUri(urlText, rangeStart, rangeLength);
    }

    protected RangedUri buildRangedUri(String urlText, long rangeStart, long rangeLength) {
        return new RangedUri(urlText, rangeStart, rangeLength);
    }

    protected int parseAudioChannelConfiguration(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String schemeIdUri = DashManifestParser.parseString(xpp, "schemeIdUri", null);
        int audioChannels = "urn:mpeg:dash:23003:3:audio_channel_configuration:2011".equals(schemeIdUri) ? DashManifestParser.parseInt(xpp, "value", -1) : ("tag:dolby.com,2014:dash:audio_channel_configuration:2011".equals(schemeIdUri) ? DashManifestParser.parseDolbyChannelConfiguration(xpp) : -1);
        do {
            xpp.next();
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)"AudioChannelConfiguration"));
        return audioChannels;
    }

    private static void filterRedundantIncompleteSchemeDatas(ArrayList<DrmInitData.SchemeData> schemeDatas) {
        block0: for (int i = schemeDatas.size() - 1; i >= 0; --i) {
            DrmInitData.SchemeData schemeData = schemeDatas.get(i);
            if (schemeData.hasData()) continue;
            for (int j = 0; j < schemeDatas.size(); ++j) {
                if (!schemeDatas.get(j).canReplace(schemeData)) continue;
                schemeDatas.remove(i);
                continue block0;
            }
        }
    }

    private static String getSampleMimeType(String containerMimeType, String codecs) {
        if (MimeTypes.isAudio((String)containerMimeType)) {
            return MimeTypes.getAudioMediaMimeType((String)codecs);
        }
        if (MimeTypes.isVideo((String)containerMimeType)) {
            return MimeTypes.getVideoMediaMimeType((String)codecs);
        }
        if (DashManifestParser.mimeTypeIsRawText(containerMimeType)) {
            return containerMimeType;
        }
        if ("application/mp4".equals(containerMimeType)) {
            if ("stpp".equals(codecs)) {
                return "application/ttml+xml";
            }
            if ("wvtt".equals(codecs)) {
                return "application/x-mp4-vtt";
            }
        } else if ("application/x-rawcc".equals(containerMimeType)) {
            if (codecs != null) {
                if (codecs.contains("cea708")) {
                    return "application/cea-708";
                }
                if (codecs.contains("eia608") || codecs.contains("cea608")) {
                    return "application/cea-608";
                }
            }
            return null;
        }
        return null;
    }

    private static boolean mimeTypeIsRawText(String mimeType) {
        return MimeTypes.isText((String)mimeType) || "application/ttml+xml".equals(mimeType) || "application/x-mp4-vtt".equals(mimeType) || "application/cea-708".equals(mimeType) || "application/cea-608".equals(mimeType);
    }

    private static String checkLanguageConsistency(String firstLanguage, String secondLanguage) {
        if (firstLanguage == null) {
            return secondLanguage;
        }
        if (secondLanguage == null) {
            return firstLanguage;
        }
        Assertions.checkState((boolean)firstLanguage.equals(secondLanguage));
        return firstLanguage;
    }

    private static int checkContentTypeConsistency(int firstType, int secondType) {
        if (firstType == -1) {
            return secondType;
        }
        if (secondType == -1) {
            return firstType;
        }
        Assertions.checkState((firstType == secondType ? 1 : 0) != 0);
        return firstType;
    }

    protected static Descriptor parseDescriptor(XmlPullParser xpp, String tag) throws XmlPullParserException, IOException {
        String schemeIdUri = DashManifestParser.parseString(xpp, "schemeIdUri", "");
        String value = DashManifestParser.parseString(xpp, "value", null);
        String id = DashManifestParser.parseString(xpp, "id", null);
        do {
            xpp.next();
        } while (!XmlPullParserUtil.isEndTag((XmlPullParser)xpp, (String)tag));
        return new Descriptor(schemeIdUri, value, id);
    }

    protected static int parseCea608AccessibilityChannel(List<Descriptor> accessibilityDescriptors) {
        for (int i = 0; i < accessibilityDescriptors.size(); ++i) {
            Descriptor descriptor = accessibilityDescriptors.get(i);
            if (!"urn:scte:dash:cc:cea-608:2015".equals(descriptor.schemeIdUri) || descriptor.value == null) continue;
            Matcher accessibilityValueMatcher = CEA_608_ACCESSIBILITY_PATTERN.matcher(descriptor.value);
            if (accessibilityValueMatcher.matches()) {
                return Integer.parseInt(accessibilityValueMatcher.group(1));
            }
            Log.w((String)TAG, (String)("Unable to parse CEA-608 channel number from: " + descriptor.value));
        }
        return -1;
    }

    protected static int parseCea708AccessibilityChannel(List<Descriptor> accessibilityDescriptors) {
        for (int i = 0; i < accessibilityDescriptors.size(); ++i) {
            Descriptor descriptor = accessibilityDescriptors.get(i);
            if (!"urn:scte:dash:cc:cea-708:2015".equals(descriptor.schemeIdUri) || descriptor.value == null) continue;
            Matcher accessibilityValueMatcher = CEA_708_ACCESSIBILITY_PATTERN.matcher(descriptor.value);
            if (accessibilityValueMatcher.matches()) {
                return Integer.parseInt(accessibilityValueMatcher.group(1));
            }
            Log.w((String)TAG, (String)("Unable to parse CEA-708 service block number from: " + descriptor.value));
        }
        return -1;
    }

    protected static String parseEac3SupplementalProperties(List<Descriptor> supplementalProperties) {
        for (int i = 0; i < supplementalProperties.size(); ++i) {
            Descriptor descriptor = supplementalProperties.get(i);
            String schemeIdUri = descriptor.schemeIdUri;
            if (!"tag:dolby.com,2014:dash:DolbyDigitalPlusExtensionType:2014".equals(schemeIdUri) || !"ec+3".equals(descriptor.value)) continue;
            return "audio/eac3-joc";
        }
        return "audio/eac3";
    }

    protected static float parseFrameRate(XmlPullParser xpp, float defaultValue) {
        Matcher frameRateMatcher;
        float frameRate = defaultValue;
        String frameRateAttribute = xpp.getAttributeValue(null, "frameRate");
        if (frameRateAttribute != null && (frameRateMatcher = FRAME_RATE_PATTERN.matcher(frameRateAttribute)).matches()) {
            int numerator = Integer.parseInt(frameRateMatcher.group(1));
            String denominatorString = frameRateMatcher.group(2);
            frameRate = !TextUtils.isEmpty((CharSequence)denominatorString) ? (float)numerator / (float)Integer.parseInt(denominatorString) : (float)numerator;
        }
        return frameRate;
    }

    protected static long parseDuration(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Util.parseXsDuration((String)value);
    }

    protected static long parseDateTime(XmlPullParser xpp, String name, long defaultValue) throws ParserException {
        String value = xpp.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Util.parseXsDateTime((String)value);
    }

    protected static String parseBaseUrl(XmlPullParser xpp, String parentBaseUrl) throws XmlPullParserException, IOException {
        xpp.next();
        return UriUtil.resolve((String)parentBaseUrl, (String)xpp.getText());
    }

    protected static int parseInt(XmlPullParser xpp, String name, int defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    protected static long parseLong(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    protected static String parseString(XmlPullParser xpp, String name, String defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : value;
    }

    protected static int parseDolbyChannelConfiguration(XmlPullParser xpp) {
        String value = Util.toLowerInvariant((String)xpp.getAttributeValue(null, "value"));
        if (value == null) {
            return -1;
        }
        switch (value) {
            case "4000": {
                return 1;
            }
            case "a000": {
                return 2;
            }
            case "f801": {
                return 6;
            }
            case "fa01": {
                return 8;
            }
        }
        return -1;
    }

    protected static final class RepresentationInfo {
        public final Format format;
        public final String baseUrl;
        public final SegmentBase segmentBase;
        public final String drmSchemeType;
        public final ArrayList<DrmInitData.SchemeData> drmSchemeDatas;
        public final ArrayList<Descriptor> inbandEventStreams;
        public final long revisionId;

        public RepresentationInfo(Format format, String baseUrl, SegmentBase segmentBase, String drmSchemeType, ArrayList<DrmInitData.SchemeData> drmSchemeDatas, ArrayList<Descriptor> inbandEventStreams, long revisionId) {
            this.format = format;
            this.baseUrl = baseUrl;
            this.segmentBase = segmentBase;
            this.drmSchemeType = drmSchemeType;
            this.drmSchemeDatas = drmSchemeDatas;
            this.inbandEventStreams = inbandEventStreams;
            this.revisionId = revisionId;
        }
    }
}

