/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;

public final class DashWrappingSegmentIndex
implements DashSegmentIndex {
    private final ChunkIndex chunkIndex;

    public DashWrappingSegmentIndex(ChunkIndex chunkIndex) {
        this.chunkIndex = chunkIndex;
    }

    @Override
    public long getFirstSegmentNum() {
        return 0L;
    }

    @Override
    public int getSegmentCount(long periodDurationUs) {
        return this.chunkIndex.length;
    }

    @Override
    public long getTimeUs(long segmentNum) {
        return this.chunkIndex.timesUs[(int)segmentNum];
    }

    @Override
    public long getDurationUs(long segmentNum, long periodDurationUs) {
        return this.chunkIndex.durationsUs[(int)segmentNum];
    }

    @Override
    public RangedUri getSegmentUrl(long segmentNum) {
        return new RangedUri(null, this.chunkIndex.offsets[(int)segmentNum], this.chunkIndex.sizes[(int)segmentNum]);
    }

    @Override
    public long getSegmentNum(long timeUs, long periodDurationUs) {
        return this.chunkIndex.getChunkIndex(timeUs);
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

