/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.stack.primitive;

import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.stack.MutableStack;

/**
 * This file was automatically generated from template file mutablePrimitiveStack.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleStack extends DoubleStack
{
    /**
     * Adds an item to the top of the stack.
     */
    void push(double item);

    /**
     * Removes and returns the top element of the stack.
     */
    double pop();

    /**
     * Removes and returns a DoubleList of the number of elements specified by the count, beginning with the top of the stack.
     */
    DoubleList pop(int count);

    /**
     * Clears the Stack
     */
    void clear();

    MutableDoubleStack select(DoublePredicate predicate);

    MutableDoubleStack reject(DoublePredicate predicate);

    <V> MutableStack<V> collect(DoubleToObjectFunction<? extends V> function);

    MutableDoubleStack asUnmodifiable();

    MutableDoubleStack asSynchronized();
}
