/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.function.primitive.ShortToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.predicate.primitive.ShortBytePredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableShortByteMap extends ShortByteMap
{
    void clear();

    void put(short key, byte value);

    void putAll(ShortByteMap map);

    void removeKey(short key);

    void remove(short key);

    byte removeKeyIfAbsent(short key, byte value);

    byte getIfAbsentPut(short key, byte value);

    byte getIfAbsentPut(short key, ByteFunction0 function);

    byte getIfAbsentPutWithKey(short key, ShortToByteFunction function);

    <P> byte getIfAbsentPutWith(short key, ByteFunction<? super P> function, P parameter);

    byte updateValue(short key, byte initialValueIfAbsent, ByteToByteFunction function);

    MutableShortByteMap select(ShortBytePredicate predicate);

    MutableShortByteMap reject(ShortBytePredicate predicate);

    MutableByteCollection select(BytePredicate predicate);

    MutableByteCollection reject(BytePredicate predicate);

    <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function);

    MutableShortByteMap withKeyValue(short key, byte value);

    MutableShortByteMap withoutKey(short key);

    MutableShortByteMap withoutAllKeys(ShortIterable keys);

    MutableShortByteMap asUnmodifiable();

    MutableShortByteMap asSynchronized();

    byte addToValue(short key, byte toBeAdded);
}
