/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleDoublePredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleDoubleMap extends DoubleDoubleMap
{
    void clear();

    void put(double key, double value);

    void putAll(DoubleDoubleMap map);

    void removeKey(double key);

    void remove(double key);

    double removeKeyIfAbsent(double key, double value);

    double getIfAbsentPut(double key, double value);

    double getIfAbsentPut(double key, DoubleFunction0 function);

    double getIfAbsentPutWithKey(double key, DoubleToDoubleFunction function);

    <P> double getIfAbsentPutWith(double key, DoubleFunction<? super P> function, P parameter);

    double updateValue(double key, double initialValueIfAbsent, DoubleToDoubleFunction function);

    MutableDoubleDoubleMap select(DoubleDoublePredicate predicate);

    MutableDoubleDoubleMap reject(DoubleDoublePredicate predicate);

    MutableDoubleCollection select(DoublePredicate predicate);

    MutableDoubleCollection reject(DoublePredicate predicate);

    <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function);

    MutableDoubleDoubleMap withKeyValue(double key, double value);

    MutableDoubleDoubleMap withoutKey(double key);

    MutableDoubleDoubleMap withoutAllKeys(DoubleIterable keys);

    MutableDoubleDoubleMap asUnmodifiable();

    MutableDoubleDoubleMap asSynchronized();

    double addToValue(double key, double toBeAdded);
}
