/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.function.primitive.ByteToLongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.predicate.primitive.ByteLongPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableByteLongMap extends ByteLongMap
{
    void clear();

    void put(byte key, long value);

    void putAll(ByteLongMap map);

    void removeKey(byte key);

    void remove(byte key);

    long removeKeyIfAbsent(byte key, long value);

    long getIfAbsentPut(byte key, long value);

    long getIfAbsentPut(byte key, LongFunction0 function);

    long getIfAbsentPutWithKey(byte key, ByteToLongFunction function);

    <P> long getIfAbsentPutWith(byte key, LongFunction<? super P> function, P parameter);

    long updateValue(byte key, long initialValueIfAbsent, LongToLongFunction function);

    MutableByteLongMap select(ByteLongPredicate predicate);

    MutableByteLongMap reject(ByteLongPredicate predicate);

    MutableLongCollection select(LongPredicate predicate);

    MutableLongCollection reject(LongPredicate predicate);

    <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function);

    MutableByteLongMap withKeyValue(byte key, long value);

    MutableByteLongMap withoutKey(byte key);

    MutableByteLongMap withoutAllKeys(ByteIterable keys);

    MutableByteLongMap asUnmodifiable();

    MutableByteLongMap asSynchronized();

    long addToValue(byte key, long toBeAdded);
}
