/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableByteList extends MutableByteCollection, ByteList
{
    void addAtIndex(int index, byte element);

    boolean addAllAtIndex(int index, byte... source);

    boolean addAllAtIndex(int index, ByteIterable source);

    byte removeAtIndex(int index);

    byte set(int index, byte element);

    MutableByteList select(BytePredicate predicate);

    MutableByteList reject(BytePredicate predicate);

    MutableByteList with(byte element);

    MutableByteList without(byte element);

    MutableByteList withAll(ByteIterable elements);

    MutableByteList withoutAll(ByteIterable elements);

    <V> MutableList<V> collect(ByteToObjectFunction<? extends V> function);

    MutableByteList reverseThis();

    MutableByteList toReversed();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableByteList sortThis();

    MutableByteList asUnmodifiable();

    MutableByteList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableByteList toImmutable();

    MutableByteList subList(int fromIndex, int toIndex);
}
