/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableByteFloatMap;
import com.gs.collections.api.map.primitive.ByteFloatMap;

/**
 * A factory which creates instances of type {@link ImmutableByteFloatMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableByteFloatMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    ImmutableByteFloatMap of();

    ImmutableByteFloatMap with();

    /**
     * Same as {@link #with(byte, float)}.
     */
    ImmutableByteFloatMap of(byte key, float value);

    ImmutableByteFloatMap with(byte key, float value);

    /**
     * Same as {@link #withAll(ByteFloatMap)}.
     */
    ImmutableByteFloatMap ofAll(ByteFloatMap map);

    ImmutableByteFloatMap withAll(ByteFloatMap map);
}
