/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.collection.primitive;

import java.util.Collection;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;

/**
 * This file was automatically generated from template file mutablePrimitiveCollection.stg.
 *
 * @since 3.0.
 */
public interface MutableShortCollection extends ShortIterable
{
    boolean add(short element);

    boolean addAll(short... source);

    boolean addAll(ShortIterable source);

    boolean remove(short value);

    boolean removeAll(ShortIterable source);

    boolean removeAll(short... source);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(ShortIterable elements);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(short... source);

    void clear();

    MutableShortCollection select(ShortPredicate predicate);

    MutableShortCollection reject(ShortPredicate predicate);

    <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function);

    MutableShortCollection with(short element);

    MutableShortCollection without(short element);

    MutableShortCollection withAll(ShortIterable elements);

    MutableShortCollection withoutAll(ShortIterable elements);

    MutableShortCollection asUnmodifiable();

    MutableShortCollection asSynchronized();

    ImmutableShortCollection toImmutable();
}
