/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.bag.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.bag.MutableBag;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableBooleanBag extends MutableBooleanCollection, BooleanBag
{
    void addOccurrences(boolean item, int occurrences);

    boolean removeOccurrences(boolean item, int occurrences);

    MutableBooleanBag select(BooleanPredicate predicate);

    MutableBooleanBag reject(BooleanPredicate predicate);

    <V> MutableBag<V> collect(BooleanToObjectFunction<? extends V> function);

    MutableBooleanBag with(boolean element);

    MutableBooleanBag without(boolean element);

    MutableBooleanBag withAll(BooleanIterable elements);

    MutableBooleanBag withoutAll(BooleanIterable elements);

    MutableBooleanBag asUnmodifiable();

    MutableBooleanBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableBooleanBag toImmutable();
}
