/*
 * Decompiled with CFR 0.152.
 */
package com.zp.z_file.util;

import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import com.zp.z_file.content.ZFileInfoBean;
import com.zp.z_file.util.ZFileLog;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/zp/z_file/util/ZFileOtherUtil;", "", "()V", "getFormatFileDate", "", "seconds", "", "getImageWH", "", "", "imagePath", "(Ljava/lang/String;)[Ljava/lang/Integer;", "getMultimediaInfo", "Lcom/zp/z_file/content/ZFileInfoBean;", "path", "isVideo", "", "secToTime", "time", "unitFormat", "i", "z_file_release"})
public final class ZFileOtherUtil {
    public static final ZFileOtherUtil INSTANCE;

    @NotNull
    public final String getFormatFileDate(long seconds) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        boolean bl = false;
        boolean bl2 = false;
        SimpleDateFormat $this$run = simpleDateFormat;
        boolean bl3 = false;
        String string2 = $this$run.format(new Date(seconds));
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        return string2;
    }

    @NotNull
    public final String secToTime(int time) {
        String timeStr = null;
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (time <= 0) {
            return "00:00";
        }
        minute = time / 60;
        if (minute < 60) {
            second = time % 60;
            timeStr = this.unitFormat(minute) + ":" + this.unitFormat(second);
        } else {
            hour = minute / 60;
            if (hour > 99) {
                return "99:59:59";
            }
            second = time - hour * 3600 - (minute %= 60) * 60;
            timeStr = this.unitFormat(hour) + ":" + this.unitFormat(minute) + ":" + this.unitFormat(second);
        }
        return timeStr;
    }

    private final String unitFormat(int i) {
        int n = i;
        return 0 <= n && 9 >= n ? "" + '0' + i : String.valueOf(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ZFileInfoBean getMultimediaInfo(@NotNull String path, boolean isVideo) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        int duration = -1;
        String width = "0";
        String height = "0";
        MediaPlayer mediaPlayer = null;
        try {
            mediaPlayer = new MediaPlayer();
            mediaPlayer.setDataSource(path);
            mediaPlayer.prepare();
            if (isVideo) {
                width = String.valueOf(mediaPlayer.getVideoWidth());
                height = String.valueOf(mediaPlayer.getVideoHeight());
            }
            duration = mediaPlayer.getDuration();
            mediaPlayer.release();
            return new ZFileInfoBean(this.secToTime(duration / 1000), width, height);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {}
        }
        finally {
            block6: {
                MediaPlayer mediaPlayer2 = mediaPlayer;
                if (mediaPlayer2 == null) break block6;
                mediaPlayer2.release();
            }
            return new ZFileInfoBean(this.secToTime(duration / 1000), width, height);
        }
    }

    public static /* synthetic */ ZFileInfoBean getMultimediaInfo$default(ZFileOtherUtil zFileOtherUtil, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return zFileOtherUtil.getMultimediaInfo(string2, bl);
    }

    @NotNull
    public final Integer[] getImageWH(@NotNull String imagePath) {
        Intrinsics.checkParameterIsNotNull((Object)imagePath, (String)"imagePath");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        ZFileLog.INSTANCE.i("width---" + options.outWidth + " height---" + options.outHeight);
        return new Integer[]{options.outWidth, options.outHeight};
    }

    private ZFileOtherUtil() {
    }

    static {
        ZFileOtherUtil zFileOtherUtil;
        INSTANCE = zFileOtherUtil = new ZFileOtherUtil();
    }
}

