/*
 * Decompiled with CFR 0.152.
 */
package com.zp.z_file.ui;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.zp.z_file.ui.ZFileVideoPlayer;
import com.zp.z_file.util.ZFileLog;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u0001:B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010%\u001a\u00020&J\r\u0010'\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u0010(J\"\u0010)\u001a\u00020#2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\nH\u0016J\u0012\u0010.\u001a\u00020&2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\"\u0010/\u001a\u00020#2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\nH\u0016J\u0012\u00100\u001a\u00020#2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0006\u00101\u001a\u00020#J\u0006\u00102\u001a\u00020#J\u001e\u00103\u001a\u00020#2\u0016\u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020#\u0018\u00010\"J\u0016\u00104\u001a\u00020#2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nJ\u001a\u00105\u001a\u00020#2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u0010J\b\u00106\u001a\u00020#H\u0002J\u0012\u00107\u001a\u00020#2\b\b\u0002\u00108\u001a\u00020\u0010H\u0002J\b\u00109\u001a\u00020#H\u0002R\u000e\u0010\f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020#\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/zp/z_file/ui/ZFileVideoPlayer;", "Landroid/view/TextureView;", "Landroid/view/TextureView$SurfaceTextureListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributes", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "IS_INIT", "IS_PAUSE", "IS_PLAYING", "leftVolume", "", "playState", "player", "Landroid/media/MediaPlayer;", "rightVolume", "size_type", "getSize_type", "()I", "setSize_type", "(I)V", "videoHeight", "videoPath", "", "getVideoPath", "()Ljava/lang/String;", "setVideoPath", "(Ljava/lang/String;)V", "videoPlayListener", "Lkotlin/Function1;", "", "videoWidth", "isPause", "", "isPlaying", "()Ljava/lang/Boolean;", "onSurfaceTextureAvailable", "surface", "Landroid/graphics/SurfaceTexture;", "width", "height", "onSurfaceTextureDestroyed", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "pause", "play", "setVideoPlayListener", "setVideoSize", "setVolume", "updateTextureViewSize", "updateTextureViewSizeCenter", "rotation", "updateTextureViewSizeCenterCrop", "Companion", "z_file_release"})
public final class ZFileVideoPlayer
extends TextureView
implements TextureView.SurfaceTextureListener {
    private MediaPlayer player;
    @NotNull
    private String videoPath;
    private int videoWidth;
    private int videoHeight;
    private float leftVolume;
    private float rightVolume;
    private final int IS_INIT = 0;
    private final int IS_PLAYING = 1;
    private final int IS_PAUSE = 2;
    private int playState;
    private int size_type;
    private Function1<? super MediaPlayer, Unit> videoPlayListener;
    public static final int CENTER_CROP_MODE = 65537;
    public static final int CENTER_MODE = 65538;
    public static final int VIDEO_IMAGE_DISPLAY_TYPE_FILL_PARENT = 4097;
    public static final int VIDEO_IMAGE_DISPLAY_TYPE_ORIGINAL = 4098;
    public static final int VIDEO_IMAGE_DISPLAY_TYPE_FILL_SCROP = 4099;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @NotNull
    public final String getVideoPath() {
        return this.videoPath;
    }

    public final void setVideoPath(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.videoPath = string2;
    }

    public final int getSize_type() {
        return this.size_type;
    }

    public final void setSize_type(int n) {
        this.size_type = n;
    }

    public final void setVideoPlayListener(@Nullable Function1<? super MediaPlayer, Unit> videoPlayListener) {
        this.videoPlayListener = videoPlayListener;
    }

    public void onSurfaceTextureAvailable(@Nullable SurfaceTexture surface, int width, int height) {
        block6: {
            if (this.player == null) {
                MediaPlayer mediaPlayer = this.player = new MediaPlayer();
                if (mediaPlayer != null) {
                    mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(this){
                        final /* synthetic */ ZFileVideoPlayer this$0;

                        public final void onPrepared(MediaPlayer it) {
                            block0: {
                                ZFileLog.INSTANCE.i("\u5a92\u4f53\u88c5\u8f7d\u5b8c\u6210");
                                ZFileVideoPlayer.setVolume$default(this.this$0, 0.0f, 0.0f, 3, null);
                                Function1 function1 = ZFileVideoPlayer.access$getVideoPlayListener$p(this.this$0);
                                if (function1 == null) break block0;
                                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)ZFileVideoPlayer.access$getPlayer$p(this.this$0));
                            }
                        }
                        {
                            this.this$0 = zFileVideoPlayer;
                        }
                    });
                }
                MediaPlayer mediaPlayer2 = this.player;
                if (mediaPlayer2 != null) {
                    mediaPlayer2.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)onSurfaceTextureAvailable.2.INSTANCE);
                }
                MediaPlayer mediaPlayer3 = this.player;
                if (mediaPlayer3 != null) {
                    mediaPlayer3.setOnCompletionListener(new MediaPlayer.OnCompletionListener(this){
                        final /* synthetic */ ZFileVideoPlayer this$0;

                        public final void onCompletion(MediaPlayer it) {
                            ZFileLog.INSTANCE.i("\u64ad\u653e\u5b8c\u6210");
                            this.this$0.play();
                        }
                        {
                            this.this$0 = zFileVideoPlayer;
                        }
                    });
                }
                MediaPlayer mediaPlayer4 = this.player;
                if (mediaPlayer4 != null) {
                    mediaPlayer4.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(this){
                        final /* synthetic */ ZFileVideoPlayer this$0;

                        public final void onVideoSizeChanged(MediaPlayer $noName_0, int videoWidth, int videoHeight) {
                            ZFileVideoPlayer.access$setVideoWidth$p(this.this$0, videoWidth);
                            ZFileVideoPlayer.access$setVideoHeight$p(this.this$0, videoHeight);
                            ZFileVideoPlayer.access$updateTextureViewSize(this.this$0);
                        }
                        {
                            this.this$0 = zFileVideoPlayer;
                        }
                    });
                }
                MediaPlayer mediaPlayer5 = this.player;
                if (mediaPlayer5 != null) {
                    mediaPlayer5.setOnErrorListener((MediaPlayer.OnErrorListener)onSurfaceTextureAvailable.5.INSTANCE);
                }
            }
            Surface s = new Surface(surface);
            MediaPlayer mediaPlayer = this.player;
            if (mediaPlayer == null) break block6;
            mediaPlayer.setSurface(s);
        }
    }

    public void onSurfaceTextureSizeChanged(@Nullable SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(@Nullable SurfaceTexture surface) {
        MediaPlayer mediaPlayer = this.player;
        if (mediaPlayer != null) {
            mediaPlayer.pause();
        }
        MediaPlayer mediaPlayer2 = this.player;
        if (mediaPlayer2 != null) {
            mediaPlayer2.stop();
        }
        MediaPlayer mediaPlayer3 = this.player;
        if (mediaPlayer3 != null) {
            mediaPlayer3.release();
        }
        ZFileLog.INSTANCE.i("\u64ad\u653e\u5668\u88ab\u9500\u6bc1...");
        return true;
    }

    public void onSurfaceTextureUpdated(@Nullable SurfaceTexture surface) {
    }

    public final void setVolume(float leftVolume, float rightVolume) {
        block0: {
            this.leftVolume = leftVolume;
            this.rightVolume = rightVolume;
            MediaPlayer mediaPlayer = this.player;
            if (mediaPlayer == null) break block0;
            mediaPlayer.setVolume(leftVolume, rightVolume);
        }
    }

    public static /* synthetic */ void setVolume$default(ZFileVideoPlayer zFileVideoPlayer, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 1.0f;
        }
        zFileVideoPlayer.setVolume(f, f2);
    }

    public final void play() {
        if (this.player == null) {
            return;
        }
        CharSequence charSequence = this.videoPath;
        boolean bl = false;
        if (charSequence.length() == 0) {
            ZFileLog.INSTANCE.i("\u89c6\u9891\u64ad\u653e\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (Intrinsics.areEqual((Object)this.isPlaying(), (Object)true)) {
            ZFileLog.INSTANCE.i("\u89c6\u9891\u6b63\u5728\u64ad\u653e...");
            return;
        }
        try {
            if (this.isPause()) {
                MediaPlayer mediaPlayer = this.player;
                if (mediaPlayer != null) {
                    mediaPlayer.start();
                }
            } else {
                MediaPlayer mediaPlayer = this.player;
                if (mediaPlayer != null) {
                    mediaPlayer.reset();
                }
                MediaPlayer mediaPlayer2 = this.player;
                if (mediaPlayer2 != null) {
                    mediaPlayer2.setDataSource(this.videoPath);
                }
                MediaPlayer mediaPlayer3 = this.player;
                if (mediaPlayer3 != null) {
                    mediaPlayer3.prepare();
                }
                MediaPlayer mediaPlayer4 = this.player;
                if (mediaPlayer4 != null) {
                    mediaPlayer4.start();
                }
            }
            this.playState = this.IS_PLAYING;
        }
        catch (Exception e) {
            e.printStackTrace();
            ZFileLog.INSTANCE.e("\u64ad\u653e\u5931\u8d25\uff01\u89c6\u9891\u8def\u5f84\u4e3a\uff1a" + this.videoPath);
        }
    }

    public final void pause() {
        if (this.player == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.isPlaying(), (Object)true)) {
            MediaPlayer mediaPlayer = this.player;
            if (mediaPlayer != null) {
                mediaPlayer.pause();
            }
            this.playState = this.IS_PAUSE;
        }
    }

    @Nullable
    public final Boolean isPlaying() {
        MediaPlayer mediaPlayer = this.player;
        return mediaPlayer != null ? Boolean.valueOf(mediaPlayer.isPlaying()) : null;
    }

    public final boolean isPause() {
        return this.playState == this.IS_PAUSE;
    }

    public final void setVideoSize(int videoWidth, int videoHeight) {
        this.videoWidth = videoWidth;
        this.videoHeight = videoHeight;
        this.requestLayout();
    }

    private final void updateTextureViewSize() {
        switch (this.size_type) {
            case 65538: {
                ZFileVideoPlayer.updateTextureViewSizeCenter$default(this, 0.0f, 1, null);
                break;
            }
            case 65537: {
                this.updateTextureViewSizeCenterCrop();
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
            }
        }
    }

    private final void updateTextureViewSizeCenterCrop() {
        float sx = (float)this.getWidth() / (float)this.videoWidth;
        float sy = (float)this.getHeight() / (float)this.videoHeight;
        Matrix matrix = new Matrix();
        float maxScale = Math.max(sx, sy);
        matrix.preTranslate((float)((this.getWidth() - this.videoWidth) / 2), (float)((this.getHeight() - this.videoHeight) / 2));
        matrix.preScale((float)this.videoWidth / (float)this.getWidth(), (float)this.videoHeight / (float)this.getHeight());
        matrix.postScale(maxScale, maxScale, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        this.setTransform(matrix);
        this.postInvalidate();
    }

    private final void updateTextureViewSizeCenter(float rotation) {
        if (rotation == 90.0f || rotation == 270.0f) {
            // empty if block
        }
        float sx = (float)this.getWidth() / (float)this.videoWidth;
        float sy = (float)this.getHeight() / (float)this.videoHeight;
        Matrix matrix = new Matrix();
        matrix.preTranslate((float)((this.getWidth() - this.videoWidth) / 2), (float)((this.getHeight() - this.videoHeight) / 2));
        matrix.preScale((float)this.videoWidth / (float)this.getWidth(), (float)this.videoHeight / (float)this.getHeight());
        if (sx >= sy) {
            matrix.postScale(sy, sy, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        } else {
            matrix.postScale(sx, sx, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        }
        this.setTransform(matrix);
        this.postInvalidate();
    }

    static /* synthetic */ void updateTextureViewSizeCenter$default(ZFileVideoPlayer zFileVideoPlayer, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        zFileVideoPlayer.updateTextureViewSizeCenter(f);
    }

    public ZFileVideoPlayer(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public ZFileVideoPlayer(@NotNull Context context, @Nullable AttributeSet attributes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attributes, 0);
    }

    public ZFileVideoPlayer(@NotNull Context context, @Nullable AttributeSet attributes, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attributes, defStyleAttr);
        this.videoPath = "";
        this.leftVolume = 1.0f;
        this.rightVolume = 1.0f;
        this.IS_PLAYING = 1;
        this.IS_PAUSE = 2;
        this.playState = this.IS_INIT;
        this.size_type = 65538;
        this.setSurfaceTextureListener(this);
        ZFileLog.INSTANCE.i("\u521d\u59cb\u5316....");
    }

    public static final /* synthetic */ Function1 access$getVideoPlayListener$p(ZFileVideoPlayer $this) {
        return $this.videoPlayListener;
    }

    public static final /* synthetic */ void access$setVideoPlayListener$p(ZFileVideoPlayer $this, Function1 function1) {
        $this.videoPlayListener = function1;
    }

    public static final /* synthetic */ MediaPlayer access$getPlayer$p(ZFileVideoPlayer $this) {
        return $this.player;
    }

    public static final /* synthetic */ void access$setPlayer$p(ZFileVideoPlayer $this, MediaPlayer mediaPlayer) {
        $this.player = mediaPlayer;
    }

    public static final /* synthetic */ int access$getVideoWidth$p(ZFileVideoPlayer $this) {
        return $this.videoWidth;
    }

    public static final /* synthetic */ void access$setVideoWidth$p(ZFileVideoPlayer $this, int n) {
        $this.videoWidth = n;
    }

    public static final /* synthetic */ int access$getVideoHeight$p(ZFileVideoPlayer $this) {
        return $this.videoHeight;
    }

    public static final /* synthetic */ void access$setVideoHeight$p(ZFileVideoPlayer $this, int n) {
        $this.videoHeight = n;
    }

    public static final /* synthetic */ void access$updateTextureViewSize(ZFileVideoPlayer $this) {
        $this.updateTextureViewSize();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/zp/z_file/ui/ZFileVideoPlayer$Companion;", "", "()V", "CENTER_CROP_MODE", "", "CENTER_MODE", "VIDEO_IMAGE_DISPLAY_TYPE_FILL_PARENT", "VIDEO_IMAGE_DISPLAY_TYPE_FILL_SCROP", "VIDEO_IMAGE_DISPLAY_TYPE_ORIGINAL", "z_file_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

