/*
 * Decompiled with CFR 0.152.
 */
package com.zp.z_file.common;

import android.content.Context;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.zp.z_file.content.ZFileContentKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nJ\u001f\u0010\u0011\u001a\u00020\r2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u0013\u00a2\u0006\u0002\b\u0014J\u001f\u0010\u0015\u001a\u00020\r2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0013\u00a2\u0006\u0002\b\u0014J'\u0010\u0017\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u0013\u00a2\u0006\u0002\b\u0014J\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0016J\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/zp/z_file/common/ZFileViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "array", "Landroid/util/SparseArray;", "getView", "V", "id", "", "(I)Landroid/view/View;", "setBgColor", "", "color", "setImageRes", "res", "setOnItemClickListener", "listener", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "setOnItemLongClickListener", "", "setOnViewClickListener", "setText", "msg", "", "setVisibility", "isVisibility", "visibility", "z_file_release"})
public final class ZFileViewHolder
extends RecyclerView.ViewHolder {
    private SparseArray<View> array;

    @NotNull
    public final <V extends View> V getView(int id) {
        View view = (View)this.array.get(id);
        if (view == null) {
            view = this.itemView.findViewById(id);
            this.array.put(id, (Object)view);
        }
        View view2 = view;
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type V");
        }
        return (V)view2;
    }

    public final void setText(int id, @NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        TextView txtView = (TextView)this.getView(id);
        txtView.setText((CharSequence)msg);
    }

    public final void setImageRes(int id, int res) {
        ImageView pic = (ImageView)this.getView(id);
        pic.setImageResource(res);
    }

    public final void setBgColor(int id, int color) {
        Object v = this.getView(id);
        View view = this.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"itemView.context");
        v.setBackgroundColor(ZFileContentKt.getColorById(context, color));
    }

    public final void setVisibility(int id, int visibility) {
        this.getView(id).setVisibility(visibility);
    }

    public final void setVisibility(int id, boolean isVisibility) {
        if (isVisibility) {
            this.setVisibility(id, 0);
        } else {
            this.setVisibility(id, 8);
        }
    }

    public final void setOnViewClickListener(int id, @NotNull Function1<? super View, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.getView(id).setOnClickListener(new View.OnClickListener(listener){
            final /* synthetic */ Function1 $listener;

            public final void onClick(View it) {
                View view = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it");
                this.$listener.invoke((Object)view);
            }
            {
                this.$listener = function1;
            }
        });
    }

    public final void setOnItemClickListener(@NotNull Function1<? super View, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.itemView.setOnClickListener(new View.OnClickListener(listener){
            final /* synthetic */ Function1 $listener;

            public final void onClick(View it) {
                View view = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it");
                this.$listener.invoke((Object)view);
            }
            {
                this.$listener = function1;
            }
        });
    }

    public final void setOnItemLongClickListener(@NotNull Function1<? super View, Boolean> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.itemView.setOnLongClickListener(new View.OnLongClickListener(listener){
            final /* synthetic */ Function1 $listener;

            public final boolean onLongClick(View it) {
                View view = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it");
                return (Boolean)this.$listener.invoke((Object)view);
            }
            {
                this.$listener = function1;
            }
        });
    }

    public ZFileViewHolder(@NotNull View itemView) {
        Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
        super(itemView);
        this.array = new SparseArray();
    }
}

