/*
 * Decompiled with CFR 0.152.
 */
package com.zp.z_file.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import androidx.core.content.FileProvider;
import com.zp.z_file.content.ZFileContentKt;
import com.zp.z_file.util.ZFileLog;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/zp/z_file/util/ZFileOpenUtil;", "", "()V", "DOC", "", "PDF", "PPT", "TXT", "XLS", "ZIP", "open", "", "filePath", "type", "context", "Landroid/content/Context;", "openDOC", "view", "Landroid/view/View;", "openPDF", "openPPT", "openTXT", "openXLS", "openZIP", "z_file_release"})
public final class ZFileOpenUtil {
    private static final String TXT = "text/plain";
    private static final String ZIP = "application/x-zip-compressed";
    private static final String DOC = "application/msword";
    private static final String XLS = "application/vnd.ms-excel";
    private static final String PPT = "application/vnd.ms-powerpoint";
    private static final String PDF = "application/pdf";
    public static final ZFileOpenUtil INSTANCE;

    public final void openTXT(@NotNull String filePath, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
        this.open(filePath, TXT, context);
    }

    public final void openZIP(@NotNull String filePath, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
        this.open(filePath, ZIP, context);
    }

    public final void openDOC(@NotNull String filePath, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
        this.open(filePath, DOC, context);
    }

    public final void openXLS(@NotNull String filePath, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
        this.open(filePath, XLS, context);
    }

    public final void openPPT(@NotNull String filePath, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
        this.open(filePath, PPT, context);
    }

    public final void openPDF(@NotNull String filePath, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
        this.open(filePath, PDF, context);
    }

    private final void open(String filePath, String type, Context context) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            Context context2 = context;
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.addCategory("android.intent.category.DEFAULT");
            $this$apply.addFlags(0x10000000);
            $this$apply.addFlags(1);
            if (Build.VERSION.SDK_INT >= 24) {
                Uri contentUri = FileProvider.getUriForFile((Context)context, (String)ZFileContentKt.getZFileConfig().getAuthority(), (File)new File(filePath));
                $this$apply.setDataAndType(contentUri, type);
            } else {
                Uri uri = Uri.fromFile((File)new File(filePath));
                $this$apply.setDataAndType(uri, type);
            }
            Intent intent2 = intent;
            context2.startActivity(intent2);
        }
        catch (Exception e) {
            e.printStackTrace();
            ZFileLog.INSTANCE.e("ZFileConfiguration.authority \u672a\u8bbe\u7f6e\uff1f\uff1f\uff1f");
            ZFileContentKt.toast$default(context, "\u6587\u4ef6\u7c7b\u578b\u53ef\u80fd\u4e0d\u5339\u914d\u6216\u627e\u4e0d\u5230\u6253\u5f00\u8be5\u6587\u4ef6\u7c7b\u578b\u7684\u7a0b\u5e8f\uff0c\u6253\u5f00\u5931\u8d25", 0, 2, null);
        }
    }

    private ZFileOpenUtil() {
    }

    static {
        ZFileOpenUtil zFileOpenUtil;
        INSTANCE = zFileOpenUtil = new ZFileOpenUtil();
    }
}

