/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.adapter.jsqlparser;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.Collection;
import java.util.function.Consumer;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;

public class JSqlParserHelper {
    public static void parserColum(String alias, String from, String selectSql, Consumer<String> columConsumer) {
        try {
            PlainSelect plainSelect;
            boolean parser = false;
            Statement statement = CCJSqlParserUtil.parse((String)String.format("SELECT %s FROM table %s %s", selectSql, alias, from));
            if (statement instanceof PlainSelect && CollectionUtils.isNotEmpty((Collection)(plainSelect = (PlainSelect)statement).getSelectItems())) {
                for (SelectItem item : plainSelect.getSelectItems()) {
                    String col;
                    if (item.getAlias() == null) {
                        if (item.getExpression() instanceof Column) {
                            Column column = (Column)item.getExpression();
                            col = column.getColumnName();
                        } else {
                            col = item.getExpression().toString();
                        }
                    } else {
                        col = item.getAlias().getName();
                    }
                    if (!StringUtils.isNotBlank((CharSequence)col)) continue;
                    columConsumer.accept(StringUtils.getTargetColumn((String)col));
                }
                parser = true;
            }
            if (!parser) {
                throw ExceptionUtils.mpe((String)"JSqlParser parser error <%s>", (Object[])new Object[]{selectSql});
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

