/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuchi.semver;

import com.github.yuchi.semver.Comparator;
import com.github.yuchi.semver.Constants;
import com.github.yuchi.semver.Direction;
import com.github.yuchi.semver.Operator;
import com.github.yuchi.semver.REWrapper;
import com.github.yuchi.semver.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class Range {
    protected final boolean loose;
    protected final String raw;
    protected final List<List<Comparator>> set;

    public static Range from(Object obj, boolean loose) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Range) {
            Range range = (Range)obj;
            if (range.loose == loose) {
                return range;
            }
            return new Range(range.raw, loose);
        }
        try {
            return new Range(String.valueOf(obj), loose);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        catch (IllegalStateException ise) {
            return null;
        }
    }

    public Range(String raw) throws IllegalArgumentException {
        this(raw, false);
    }

    public Range(String raw, boolean loose) throws IllegalArgumentException {
        this.raw = raw;
        this.loose = loose;
        this.set = new ArrayList<List<Comparator>>();
        String[] ranges = this.raw.trim().split("\\s*\\|\\|\\s*");
        if (ranges.length == 0) {
            ranges = new String[]{""};
        }
        for (String range : ranges) {
            List<Comparator> comparators = this.parseRange(range = range.trim());
            if (comparators.isEmpty()) continue;
            this.set.add(comparators);
        }
        if (this.set.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    public boolean isOutside(Version version, Direction dir) {
        Operator ope;
        Operator op;
        Predicate<Integer> lte;
        Predicate<Integer> lt;
        Predicate<Integer> gt;
        if (this.test(version)) {
            return false;
        }
        if (dir == Direction.HIGH) {
            gt = n -> n > 0;
            lt = n -> n < 0;
            lte = n -> n <= 0;
            op = Operator.GT;
            ope = Operator.GTE;
        } else if (dir == Direction.LOW) {
            gt = n -> n < 0;
            lt = n -> n > 0;
            lte = n -> n >= 0;
            op = Operator.LT;
            ope = Operator.LTE;
        } else {
            throw new IllegalArgumentException();
        }
        for (List<Comparator> comparators : this.set) {
            Comparator high = null;
            Comparator low = null;
            for (Comparator comparator : comparators) {
                int compare;
                if (comparator.operator == Operator.ANY) {
                    comparator = new Comparator(">=0.0.0");
                }
                if (high == null) {
                    high = comparator;
                }
                if (low == null) {
                    low = comparator;
                }
                if (gt.test(compare = comparator.version.compareTo(high.version))) {
                    high = comparator;
                    continue;
                }
                if (!lt.test(compare)) continue;
                low = comparator;
            }
            if (high.operator == op || high.operator == ope) {
                return false;
            }
            int compare = version.compareTo(low.version);
            if ((low.operator == Operator.EQ || low.operator == op) && lte.test(compare)) {
                return false;
            }
            if (low.operator != ope || !lt.test(compare)) continue;
            return false;
        }
        return true;
    }

    public boolean test(Version version) {
        for (List<Comparator> comparators : this.set) {
            if (!this.testList(version, comparators)) continue;
            return true;
        }
        return false;
    }

    protected List<Comparator> parseRange(String range) {
        range = this.replaceHyphens(range);
        range = Constants.COMPARATORTRIM.replace(range, "$1$2$3");
        range = Constants.TILDETRIM.replace(range, "$1~");
        range = Constants.CARETTRIM.replace(range, "$1^");
        range = range.replaceAll("\\s+", " ");
        REWrapper compRe = this.loose ? Constants.COMPARATORLOOSE : Constants.COMPARATOR;
        Stream<String> comps = Stream.of(range).flatMap(this::splitBySpace).flatMap(this::replaceCarets).flatMap(this::splitBySpace).flatMap(this::replaceTildes).flatMap(this::splitBySpace).flatMap(this::replaceXRanges).flatMap(this::splitBySpace).map(this::replaceStars);
        if (this.loose) {
            comps = comps.filter(compRe::matches);
        }
        return comps.map(comp -> new Comparator((String)comp, this.loose)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    protected boolean testList(Version version, List<Comparator> comparators) {
        for (Comparator comparator : comparators) {
            if (comparator.test(version)) continue;
            return false;
        }
        if (version.prerelease.length > 0) {
            for (Comparator comparator : comparators) {
                if (comparator.operator == Operator.ANY || comparator.version.prerelease.length <= 0) continue;
                Version allowed = comparator.version;
                if (allowed.major != version.major || allowed.minor != version.minor || allowed.patch != version.patch) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected String replaceHyphens(String range) {
        REWrapper hr = this.loose ? Constants.HYPHENRANGELOOSE : Constants.HYPHENRANGE;
        return hr.replace(range, m -> {
            String from = m.group(1);
            String fromMajor = m.group(2);
            String fromMinor = m.group(3);
            String fromPatch = m.group(4);
            String to = m.group(7);
            String toMajor = m.group(8);
            String toMinor = m.group(9);
            String toPatch = m.group(10);
            String toPR = m.group(11);
            StringBuilder sb = new StringBuilder();
            if (!this.isX(fromMajor)) {
                if (this.isX(fromMinor)) {
                    sb.append(">=");
                    sb.append(fromMajor);
                    sb.append(".0.0");
                } else if (this.isX(fromPatch)) {
                    sb.append(">=");
                    sb.append(fromMajor);
                    sb.append(".");
                    sb.append(fromMinor);
                    sb.append(".0");
                } else {
                    sb.append(">=");
                    sb.append(from);
                }
            }
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (!this.isX(toMajor)) {
                if (this.isX(toMinor)) {
                    sb.append("<");
                    sb.append(Integer.parseInt(toMajor) + 1);
                    sb.append(".0.0");
                } else if (this.isX(toPatch)) {
                    sb.append("<");
                    sb.append(toMajor);
                    sb.append(".");
                    sb.append(Integer.parseInt(toMinor) + 1);
                    sb.append(".0");
                } else if (toPR != null && !toPR.isEmpty()) {
                    sb.append("<=");
                    sb.append(toMajor);
                    sb.append(".");
                    sb.append(toMinor);
                    sb.append(".");
                    sb.append(toPatch);
                    sb.append("-");
                    sb.append(toPR);
                } else {
                    sb.append("<=");
                    sb.append(to);
                }
            }
            return sb;
        });
    }

    protected boolean is0(String identifier) {
        return identifier.length() == 1 && identifier.charAt(0) == '0';
    }

    protected boolean isX(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return true;
        }
        if (identifier.length() == 1) {
            char c = identifier.charAt(0);
            return c == 'x' || c == 'X' || c == '*';
        }
        return false;
    }

    protected Stream<String> replaceCarets(String comp) {
        REWrapper re = this.loose ? Constants.CARETLOOSE : Constants.CARET;
        return re.replaceWithTokensStream(comp, m -> {
            StringBuilder sb = new StringBuilder();
            String major = m.group(1);
            String minor = m.group(2);
            String patch = m.group(3);
            String pr = m.group(4);
            if (!this.isX(major)) {
                if (this.isX(minor)) {
                    sb.append(">=");
                    sb.append(major);
                    sb.append(".0.0 <");
                    sb.append(Integer.parseInt(major) + 1);
                    sb.append(".0.0");
                } else if (this.isX(patch)) {
                    if (this.is0(major)) {
                        sb.append(">=");
                        sb.append(major);
                        sb.append(".");
                        sb.append(minor);
                        sb.append(".0 <");
                        sb.append(major);
                        sb.append(".");
                        sb.append(Integer.parseInt(minor) + 1);
                        sb.append(".0");
                    } else {
                        sb.append(">=");
                        sb.append(major);
                        sb.append(".");
                        sb.append(minor);
                        sb.append(".0 <");
                        sb.append(Integer.parseInt(minor) + 1);
                        sb.append(".0.0");
                    }
                } else {
                    sb.append(">=");
                    sb.append(major);
                    sb.append(".");
                    sb.append(minor);
                    sb.append(".");
                    sb.append(patch);
                    if (pr != null && !pr.isEmpty()) {
                        if (pr.charAt(0) != '-') {
                            sb.append("-");
                        }
                        sb.append(pr);
                    }
                    sb.append(" <");
                    if (this.is0(major)) {
                        if (this.is0(minor)) {
                            sb.append(major);
                            sb.append(".");
                            sb.append(minor);
                            sb.append(".");
                            sb.append(Integer.parseInt(patch) + 1);
                        } else {
                            sb.append(major);
                            sb.append(".");
                            sb.append(Integer.parseInt(minor) + 1);
                            sb.append(".0");
                        }
                    } else {
                        sb.append(Integer.parseInt(major) + 1);
                        sb.append(".0.0");
                    }
                }
            }
            return sb;
        });
    }

    protected Stream<String> replaceTildes(String comp) {
        REWrapper re = this.loose ? Constants.TILDELOOSE : Constants.TILDE;
        return re.replaceWithTokensStream(comp, m -> {
            StringBuilder sb = new StringBuilder();
            String major = m.group(1);
            String minor = m.group(2);
            String patch = m.group(3);
            String pr = m.group(4);
            if (!this.isX(major)) {
                if (this.isX(minor)) {
                    sb.append(">=");
                    sb.append(major);
                    sb.append(".0.0 <");
                    sb.append(Integer.parseInt(major) + 1);
                    sb.append(".0.0");
                } else if (this.isX(patch)) {
                    sb.append(">=");
                    sb.append(major);
                    sb.append(".");
                    sb.append(minor);
                    sb.append(".0 <");
                    sb.append(major);
                    sb.append(".");
                    sb.append(Integer.parseInt(minor) + 1);
                    sb.append(".0");
                } else {
                    sb.append(">=");
                    sb.append(major);
                    sb.append(".");
                    sb.append(minor);
                    sb.append(".");
                    sb.append(patch);
                    if (pr != null && !pr.isEmpty()) {
                        if (pr.charAt(0) != '-') {
                            sb.append("-");
                        }
                        sb.append(pr);
                    }
                    sb.append(" <");
                    sb.append(major);
                    sb.append(".");
                    sb.append(Integer.parseInt(minor) + 1);
                    sb.append(".0");
                }
            }
            return sb;
        });
    }

    protected Stream<String> replaceXRanges(String comp) {
        REWrapper re = this.loose ? Constants.XRANGELOOSE : Constants.XRANGE;
        return re.replaceWithTokensStream(comp, m -> {
            boolean xPatch;
            StringBuilder sb = new StringBuilder();
            String gtlt = m.group(1);
            String major = m.group(2);
            String minor = m.group(3);
            String patch = m.group(4);
            boolean xMajor = this.isX(major);
            boolean xMinor = xMajor || this.isX(minor);
            boolean xAny = xPatch = xMinor || this.isX(patch);
            if (gtlt != null && gtlt.equals("=") && xAny) {
                gtlt = "";
            }
            if (xMajor) {
                if (gtlt.equals("<") || gtlt.equals(">")) {
                    sb.append("<0.0.0");
                } else {
                    sb.append("*");
                }
            } else if (gtlt != null && !gtlt.isEmpty() && xAny) {
                if (xMinor) {
                    minor = "0";
                }
                if (xPatch) {
                    patch = "0";
                }
                if (gtlt.equals(">")) {
                    gtlt = ">=";
                    if (xMinor) {
                        major = String.valueOf(Integer.parseInt(major) + 1);
                        minor = "0";
                        patch = "0";
                    } else if (xPatch) {
                        minor = String.valueOf(Integer.parseInt(minor) + 1);
                        patch = "0";
                    }
                } else if (gtlt.equals("<=")) {
                    gtlt = "<";
                    if (xMinor) {
                        major = String.valueOf(Integer.parseInt(major) + 1);
                    } else {
                        minor = String.valueOf(Integer.parseInt(minor) + 1);
                    }
                }
                sb.append(gtlt);
                sb.append(major);
                sb.append(".");
                sb.append(minor);
                sb.append(".");
                sb.append(patch);
            } else if (xMinor) {
                sb.append(">=");
                sb.append(major);
                sb.append(".0.0 <");
                sb.append(Integer.parseInt(major) + 1);
                sb.append(".0.0");
            } else if (xPatch) {
                sb.append(">=");
                sb.append(major);
                sb.append(".");
                sb.append(minor);
                sb.append(".0 <");
                sb.append(major);
                sb.append(".");
                sb.append(Integer.parseInt(minor) + 1);
                sb.append(".0");
            } else {
                sb.append(m.group(0));
            }
            return sb;
        });
    }

    protected String replaceStars(String comp) {
        return Constants.STAR.replace(comp.trim(), "");
    }

    protected Stream<String> splitBySpace(String input) {
        return Arrays.stream(input.split(" "));
    }
}

