/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.MethodArgs;
import com.github.yoojia.events.MethodFilter;
import com.github.yoojia.events.MethodSubscriber;
import com.github.yoojia.events.Methods;
import com.github.yoojia.events.SubscriberArray;
import com.github.yoojia.events.emitter.EventFilter;
import com.github.yoojia.events.emitter.RealSubscriber;
import com.github.yoojia.events.supports.Filter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class Cached {
    private final Map<Object, SubscriberArray> mCache = new ConcurrentHashMap<Object, SubscriberArray>();

    Cached() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriberArray findTargets(Object object, Filter<Method> filter) {
        List<Method> methods = Methods.getAnnotated(object.getClass(), filter);
        if (methods.isEmpty()) {
            return SubscriberArray.empty();
        }
        Map<Object, SubscriberArray> map = this.mCache;
        synchronized (map) {
            SubscriberArray present = this.mCache.get(object);
            if (present != null) {
                return present;
            }
            int size = methods.size();
            ArrayList<RealSubscriber> array = new ArrayList<RealSubscriber>(size);
            for (int i = 0; i < size; ++i) {
                Method method = methods.get(i);
                array.add(Cached.create(object, method, Methods.parse(method)));
            }
            SubscriberArray acceptors = new SubscriberArray(array);
            this.mCache.put(object, acceptors);
            return acceptors;
        }
    }

    public SubscriberArray getPresent(Object object) {
        SubscriberArray present = this.mCache.get(object);
        if (present == null) {
            return SubscriberArray.empty();
        }
        return present;
    }

    public void remove(Object object) {
        this.mCache.remove(object);
    }

    private static RealSubscriber create(Object object, Method method, MethodArgs args) {
        ArrayList<EventFilter> filters = new ArrayList<EventFilter>(1);
        filters.add(new MethodFilter(args));
        return new RealSubscriber(MethodSubscriber.create(args.scheduleOn, object, method, args), filters);
    }
}

