/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.keyboard;

import android.app.Activity;
import android.content.Context;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.github.yoojia.keyboard.AbstractKeyboard;
import com.github.yoojia.keyboard.OnKeyActionListener;
import com.github.yoojia.keyboard.OnKeyboardActionHandler;
import com.github.yoojia.keyboard.R;

public class VehiclePlateKeyboard
extends AbstractKeyboard {
    private static final int NUMBER_LENGTH = 7;
    public static final String WJ_PREFIX = "WJ";
    private static final String PROVINCE_CHINESE = "@\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0\u6b66";
    public static final String EXTRA_CHINESE = "@\u6e2f\u6fb3\u8b66\u5b66\u6302";
    private final KeyboardView mKeyboardView;
    private final TextView[] mNumbersTextView = new TextView[7];
    private View mCommitButton;
    private int mShowingKeyboard = 0;
    private TextView mSelectedTextView;
    private Keyboard mProvinceKeyboard_1;
    private Keyboard mProvinceKeyboard_0;
    private Keyboard mCityCodeKeyboard;
    private Keyboard mNumberKeyboard;
    private Keyboard mNumberExtraKeyboard;
    private String mDefaultPlateNumber;

    public VehiclePlateKeyboard(Context context, OnKeyActionListener keyActionListener) {
        super(context, keyActionListener);
        View contentView = this.putContentView(R.layout.keyboard_vehicle_plate);
        this.mNumbersTextView[0] = (TextView)contentView.findViewById(R.id.keyboard_number_0);
        this.mNumbersTextView[1] = (TextView)contentView.findViewById(R.id.keyboard_number_1);
        this.mNumbersTextView[2] = (TextView)contentView.findViewById(R.id.keyboard_number_2);
        this.mNumbersTextView[3] = (TextView)contentView.findViewById(R.id.keyboard_number_3);
        this.mNumbersTextView[4] = (TextView)contentView.findViewById(R.id.keyboard_number_4);
        this.mNumbersTextView[5] = (TextView)contentView.findViewById(R.id.keyboard_number_5);
        this.mNumbersTextView[6] = (TextView)contentView.findViewById(R.id.keyboard_number_6);
        View.OnClickListener listener = this.createNumberListener();
        for (TextView view : this.mNumbersTextView) {
            view.setSoundEffectsEnabled(false);
            view.setOnClickListener(listener);
        }
        this.mProvinceKeyboard_1 = new Keyboard(context, R.xml.keyboard_vehicle_province_1);
        this.mProvinceKeyboard_0 = new Keyboard(context, R.xml.keyboard_vehicle_province_0);
        this.mCityCodeKeyboard = new Keyboard(context, R.xml.keyboard_vehicle_code);
        this.mNumberKeyboard = new Keyboard(context, R.xml.keyboard_vehicle_number);
        this.mNumberExtraKeyboard = new Keyboard(context, R.xml.keyboard_vehicle_number_extra);
        this.mKeyboardView = (KeyboardView)contentView.findViewById(R.id.keyboard_view);
        this.mKeyboardView.setOnKeyboardActionListener((KeyboardView.OnKeyboardActionListener)new OnKeyboardActionHandler(){

            @Override
            public void onKey(int charCode, int[] keyCodes) {
                if (400 < charCode && charCode < 500) {
                    charCode = VehiclePlateKeyboard.PROVINCE_CHINESE.charAt(charCode - 400);
                } else if (500 < charCode) {
                    charCode = VehiclePlateKeyboard.EXTRA_CHINESE.charAt(charCode - 500);
                }
                VehiclePlateKeyboard.this.mSelectedTextView.setText((CharSequence)Character.toString((char)charCode));
                VehiclePlateKeyboard.this.nextNumber();
            }
        });
        this.mKeyboardView.setPreviewEnabled(false);
        this.mCommitButton = contentView.findViewById(R.id.keyboard_commit);
        this.mCommitButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String number = VehiclePlateKeyboard.this.getInput(VehiclePlateKeyboard.this.mNumbersTextView);
                if (number.length() == VehiclePlateKeyboard.this.mNumbersTextView.length) {
                    VehiclePlateKeyboard.this.mOnKeyActionListener.onFinish(number);
                    VehiclePlateKeyboard.this.dismiss();
                }
            }
        });
    }

    public void setDefaultPlateNumber(String number) {
        if (!TextUtils.isEmpty((CharSequence)number)) {
            this.mDefaultPlateNumber = number.startsWith(WJ_PREFIX) ? "\u6b66" + number.substring(number.length() > 2 ? 2 : 0) : number;
        }
    }

    @Override
    public void show(View anchorView) {
        if (!TextUtils.isEmpty((CharSequence)this.mDefaultPlateNumber)) {
            char[] numbers = this.mDefaultPlateNumber.toUpperCase().toCharArray();
            int limited = Math.min(7, numbers.length);
            for (int i = 0; i < limited; ++i) {
                this.mNumbersTextView[i].setText((CharSequence)Character.toString(numbers[i]));
            }
        }
        super.show(anchorView);
    }

    @Override
    protected void onShow() {
        this.mNumbersTextView[0].performClick();
    }

    private void nextNumber() {
        String number = this.getInput(this.mNumbersTextView);
        this.mOnKeyActionListener.onProcess(number);
        int viewId = this.mSelectedTextView.getId();
        if (viewId == R.id.keyboard_number_0) {
            this.mNumbersTextView[1].performClick();
        } else if (viewId == R.id.keyboard_number_1) {
            this.mNumbersTextView[2].performClick();
        } else if (viewId == R.id.keyboard_number_2) {
            this.mNumbersTextView[3].performClick();
        } else if (viewId == R.id.keyboard_number_3) {
            this.mNumbersTextView[4].performClick();
        } else if (viewId == R.id.keyboard_number_4) {
            this.mNumbersTextView[5].performClick();
        } else if (viewId == R.id.keyboard_number_5) {
            this.mNumbersTextView[6].performClick();
        } else if (viewId == R.id.keyboard_number_6) {
            this.mCommitButton.performClick();
        }
    }

    private View.OnClickListener createNumberListener() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                if (VehiclePlateKeyboard.this.mSelectedTextView != null) {
                    VehiclePlateKeyboard.this.mSelectedTextView.setActivated(false);
                }
                VehiclePlateKeyboard.this.mSelectedTextView = (TextView)view;
                VehiclePlateKeyboard.this.mSelectedTextView.setActivated(true);
                int id2 = view.getId();
                if (id2 == R.id.keyboard_number_0) {
                    if (VehiclePlateKeyboard.this.mShowingKeyboard != R.xml.keyboard_vehicle_province_1) {
                        VehiclePlateKeyboard.this.mShowingKeyboard = R.xml.keyboard_vehicle_province_1;
                        VehiclePlateKeyboard.this.mKeyboardView.setKeyboard(VehiclePlateKeyboard.this.mProvinceKeyboard_1);
                    }
                } else if (id2 == R.id.keyboard_number_1) {
                    String number = VehiclePlateKeyboard.this.getInput(VehiclePlateKeyboard.this.mNumbersTextView);
                    if (number.startsWith(VehiclePlateKeyboard.WJ_PREFIX)) {
                        VehiclePlateKeyboard.this.mShowingKeyboard = R.xml.keyboard_vehicle_province_0;
                        VehiclePlateKeyboard.this.mKeyboardView.setKeyboard(VehiclePlateKeyboard.this.mProvinceKeyboard_0);
                    } else if (VehiclePlateKeyboard.this.mShowingKeyboard != R.xml.keyboard_vehicle_code) {
                        VehiclePlateKeyboard.this.mShowingKeyboard = R.xml.keyboard_vehicle_code;
                        VehiclePlateKeyboard.this.mKeyboardView.setKeyboard(VehiclePlateKeyboard.this.mCityCodeKeyboard);
                    }
                } else if (id2 == R.id.keyboard_number_6) {
                    if (VehiclePlateKeyboard.this.mShowingKeyboard != R.xml.keyboard_vehicle_number_extra) {
                        VehiclePlateKeyboard.this.mShowingKeyboard = R.xml.keyboard_vehicle_number_extra;
                        VehiclePlateKeyboard.this.mKeyboardView.setKeyboard(VehiclePlateKeyboard.this.mNumberExtraKeyboard);
                    }
                } else if (VehiclePlateKeyboard.this.mShowingKeyboard != R.xml.keyboard_vehicle_number) {
                    VehiclePlateKeyboard.this.mShowingKeyboard = R.xml.keyboard_vehicle_number;
                    VehiclePlateKeyboard.this.mKeyboardView.setKeyboard(VehiclePlateKeyboard.this.mNumberKeyboard);
                }
                VehiclePlateKeyboard.this.mKeyboardView.invalidateAllKeys();
                VehiclePlateKeyboard.this.mKeyboardView.invalidate();
            }
        };
    }

    @Override
    protected String getInput(TextView[] inputs) {
        String number = super.getInput(inputs);
        return number.replace("\u6b66", WJ_PREFIX);
    }

    public static void show(Activity activity, OnKeyActionListener listener) {
        new VehiclePlateKeyboard((Context)activity, listener).show(activity.getWindow().getDecorView().getRootView());
    }

    public static VehiclePlateKeyboard create(Context context, OnKeyActionListener listener) {
        return new VehiclePlateKeyboard(context, listener);
    }
}

