/*
 * Decompiled with CFR 0.152.
 */
package com.github.yangkangli.logger.core;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.github.yangkangli.logger.core.BaseLogStrategy;
import com.github.yangkangli.logger.core.ILogAdapter;
import com.github.yangkangli.logger.strategy.DefaultLogStrategy;
import com.github.yangkangli.logger.utils.Utils;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LoggerCore {
    private final List<ILogAdapter> adapterList = new ArrayList<ILogAdapter>();
    private BaseLogStrategy logStrategy = new DefaultLogStrategy.Builder().build();

    public void setStrategy(BaseLogStrategy strategy) {
        Utils.checkNotNull(strategy);
        this.logStrategy = strategy;
    }

    public void addAdapter(ILogAdapter adapter) {
        this.adapterList.add(Utils.checkNotNull(adapter));
    }

    public void clearAdapter() {
        this.adapterList.clear();
    }

    public void v(String tag, Object message, Throwable throwable) {
        this.log(2, tag, Utils.toString(message), throwable);
    }

    public void d(String tag, Object message, Throwable throwable) {
        this.log(3, tag, Utils.toString(message), throwable);
    }

    public void i(String tag, Object message, Throwable throwable) {
        this.log(4, tag, Utils.toString(message), throwable);
    }

    public void w(String tag, Object message, Throwable throwable) {
        this.log(5, tag, Utils.toString(message), throwable);
    }

    public void e(String tag, Object message, Throwable throwable) {
        this.log(6, tag, Utils.toString(message), throwable);
    }

    public void json(String subTag, String title, String json) {
        try {
            String jsonStr = json.trim();
            if (jsonStr.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(jsonStr);
                String message = jsonObject.toString(2);
                if (TextUtils.isEmpty((CharSequence)title)) {
                    this.d(subTag, message, null);
                } else {
                    this.d(subTag, title + ":\n" + message, null);
                }
                return;
            }
            if (jsonStr.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(jsonStr);
                String message = jsonArray.toString(2);
                if (TextUtils.isEmpty((CharSequence)title)) {
                    this.d(subTag, message, null);
                } else {
                    this.d(subTag, title + ":\n" + message, null);
                }
                return;
            }
            if (TextUtils.isEmpty((CharSequence)title)) {
                this.e(subTag, "Invalid Json", null);
            } else {
                this.e(subTag, title + ":\nInvalid Json", null);
            }
        }
        catch (JSONException e) {
            if (TextUtils.isEmpty((CharSequence)title)) {
                this.e(subTag, "Invalid Json", null);
            }
            this.e(subTag, title + ":\nInvalid Json", null);
        }
    }

    public void xml(String subTag, String title, String xml) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            if (TextUtils.isEmpty((CharSequence)title)) {
                this.d(subTag, xmlOutput.getWriter().toString().replaceFirst(">", ">\n"), null);
            } else {
                this.d(subTag, title + ":\n" + xmlOutput.getWriter().toString().replaceFirst(">", ">\n"), null);
            }
        }
        catch (TransformerException e) {
            if (TextUtils.isEmpty((CharSequence)title)) {
                this.e(subTag, "Invalid Xml", null);
            }
            this.e(subTag, title + ":\nInvalid Xml", null);
        }
    }

    private void log(int priority, String subTag, String message, @Nullable Throwable throwable) {
        if (throwable != null) {
            message = TextUtils.isEmpty((CharSequence)message) ? Utils.getStackTraceString(throwable) : message + " : " + Utils.getStackTraceString(throwable);
        }
        if (TextUtils.isEmpty((CharSequence)message)) {
            message = "Empty/NULL log message";
        }
        for (ILogAdapter adapter : this.adapterList) {
            if (!adapter.isLoggable()) continue;
            adapter.log(priority, subTag, message, this.logStrategy);
        }
    }
}

