/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.library;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.xujiaji.library.R;
import com.xujiaji.library.RippleCheckBoxUtil;

public class RippleCheckBox
extends View {
    private static final String KEY_INSTANCE_STATE = "InstanceState";
    private Status mLastStatus = Status.CIRCLE;
    private Status mCurrentStatus = Status.CIRCLE;
    private Status mCircleClickedStatus = Status.HOOK;
    private Status mCircleLongClickedStatus = Status.CROSS;
    private Status mHookClickedStatus = Status.CIRCLE;
    private Status mHookLongClickedStatus = Status.CROSS;
    private Status mCrossClickedStatus = Status.CIRCLE;
    private Status mCrossLongClickedStatus = Status.HOOK;
    private boolean mEnableClick = true;
    private boolean mEnableLongClick = true;
    private Paint mCenterCirclePaint;
    private Paint mRipplePaint;
    private Paint mRightPaint;
    private Paint mDeletePaint;
    private Path mRightPath;
    private Path mRightPathDst;
    private Path mCenterCirclePath;
    private Path mDeleteTotalPath;
    private Path mDeleteOnePath;
    private Path mDeleteTwoPath;
    private Path mDeletePathDst;
    private PathMeasure mRightPathMeasure = new PathMeasure();
    private float mRightPathMeasureLen;
    private PathMeasure mCenterCirclePathMeasure = new PathMeasure();
    private PathMeasure mDeleteOnePathMeasure = new PathMeasure();
    private PathMeasure mDeleteTwoPathMeasure = new PathMeasure();
    private float mDeletePathMeasureLen;
    private int mCenterCircleRadius;
    private PointF mCenterPointF = new PointF();
    private PointF mWH = new PointF();
    private float mRightAnimatorValue;
    private float mRippleAnimatorValue;
    private float mDeleteAnimatorValue;
    private ValueAnimator mRightCheckedAnimator;
    private ValueAnimator mRippleCheckedAnimator;
    private ValueAnimator mDeleteCheckedAnimator;
    private ValueAnimator mRightUnCheckedAnimator;
    private ValueAnimator mRippleUnCheckedAnimator;
    private ValueAnimator mDeleteUnCheckedAnimator;
    private int mDurationRight;
    private int mDurationRipple;
    private int mDurationDelete;
    private OnCheckedChangeListener mListener;
    private int _360_right_degree_start = 150;
    private int _360_right_degree_center = 100;
    private int _360_right_degree_end = 330;
    private int mRightCorner;
    private int mDeleteCorner;
    private int mRippleMargin;
    private float mDeleteScale;
    private boolean enableDeleteMode;

    public RippleCheckBox(Context context) {
        this(context, null);
    }

    public RippleCheckBox(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RippleCheckBox(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray t = context.obtainStyledAttributes(attrs, R.styleable.RippleCheckBox, defStyleAttr, 0);
        int centerCircleRadius = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbCenterCircleRadius, RippleCheckBoxUtil.dp2px(context, 10.0f));
        int centerCircleStrokeWidth = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbCenterCircleStrokeWidth, RippleCheckBoxUtil.dp2px(context, 1.0f));
        int centerCircleColor = t.getColor(R.styleable.RippleCheckBox_rcbCenterCircleColor, -7829368);
        int rightStrokeWidth = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbRightStrokeWidth, RippleCheckBoxUtil.dp2px(context, 3.0f));
        int rightColor = t.getColor(R.styleable.RippleCheckBox_rcbRightColor, -16776961);
        int rightDuration = t.getInteger(R.styleable.RippleCheckBox_rcbRightDuration, 400);
        int deleteStrokeWidth = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbDeleteStrokeWidth, RippleCheckBoxUtil.dp2px(context, 2.0f));
        int deleteColor = t.getColor(R.styleable.RippleCheckBox_rcbDeleteColor, -16776961);
        int deleteDuration = t.getInteger(R.styleable.RippleCheckBox_rcbDeleteDuration, 600);
        int deleteRightCorner = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbDeleteCorner, RippleCheckBoxUtil.dp2px(context, 2.0f));
        float deleteScale = t.getFloat(R.styleable.RippleCheckBox_rcbDeleteScale, 1.0f);
        boolean deleteEnable = t.getBoolean(R.styleable.RippleCheckBox_rcbDeleteEnable, false);
        int rippleStrokeWidth = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbRippleStrokeWidth, RippleCheckBoxUtil.dp2px(context, 4.0f));
        int rippleColor = t.getColor(R.styleable.RippleCheckBox_rcbRippleColor, -16776961);
        int rippleDuration = t.getInteger(R.styleable.RippleCheckBox_rcbRippleDuration, 200);
        int rippleMargin = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbRippleMargin, 0);
        int rightStartDegree = t.getInteger(R.styleable.RippleCheckBox_rcbRightStartDegree, this._360_right_degree_start);
        int rightCenterDegree = t.getInteger(R.styleable.RippleCheckBox_rcbRightCenterDegree, this._360_right_degree_center);
        int rightEndDegree = t.getInteger(R.styleable.RippleCheckBox_rcbRightEndDegree, this._360_right_degree_end);
        int rightRightCorner = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbRightCorner, RippleCheckBoxUtil.dp2px(context, 2.0f));
        int status = t.getInteger(R.styleable.RippleCheckBox_rcbStatus, Status.CIRCLE.value);
        int circleClickedStatus = t.getInteger(R.styleable.RippleCheckBox_rcbCircleClickedStatus, Status.HOOK.value);
        int circleLongClickedStatus = t.getInteger(R.styleable.RippleCheckBox_rcbCircleLongClickedStatus, Status.CROSS.value);
        int hookClickedStatus = t.getInteger(R.styleable.RippleCheckBox_rcbHookClickedStatus, Status.CIRCLE.value);
        int hookLongClickedStatus = t.getInteger(R.styleable.RippleCheckBox_rcbHookLongClickedStatus, Status.CROSS.value);
        int crossClickedStatus = t.getInteger(R.styleable.RippleCheckBox_rcbCrossClickedStatus, Status.CIRCLE.value);
        int crossLongClickedStatus = t.getInteger(R.styleable.RippleCheckBox_rcbCrossLongClickedStatus, Status.HOOK.value);
        boolean enableClick = t.getBoolean(R.styleable.RippleCheckBox_rcbEnableClick, true);
        boolean enableLongClick = t.getBoolean(R.styleable.RippleCheckBox_rcbEnableLongClick, true);
        t.recycle();
        this.enableDeleteMode = deleteEnable;
        this.mDeleteScale = deleteScale;
        this.mLastStatus = this.mCurrentStatus = Status.of(status);
        this.mCircleClickedStatus = Status.of(circleClickedStatus);
        this.mCircleLongClickedStatus = Status.of(circleLongClickedStatus);
        this.mHookClickedStatus = Status.of(hookClickedStatus);
        this.mHookLongClickedStatus = Status.of(hookLongClickedStatus);
        this.mCrossClickedStatus = Status.of(crossClickedStatus);
        this.mCrossLongClickedStatus = Status.of(crossLongClickedStatus);
        this.mCenterCircleRadius = centerCircleRadius;
        this.mDurationRight = rightDuration;
        this.mDurationRipple = rippleDuration;
        this.mDurationDelete = deleteDuration;
        this.mRippleMargin = rippleMargin;
        this._360_right_degree_start = rightStartDegree;
        this._360_right_degree_center = rightCenterDegree;
        this._360_right_degree_end = rightEndDegree;
        this.mEnableClick = enableClick;
        this.mEnableLongClick = enableLongClick;
        this.mRightPath = new Path();
        this.mRightPathDst = new Path();
        this.mCenterCirclePath = new Path();
        this.mDeleteTotalPath = new Path();
        this.mDeleteOnePath = new Path();
        this.mDeleteTwoPath = new Path();
        this.mDeletePathDst = new Path();
        this.mCenterCirclePaint = new Paint(5);
        this.mRipplePaint = new Paint(5);
        this.mRightPaint = new Paint(5);
        this.mDeletePaint = new Paint(5);
        this.mCenterCirclePaint.setStrokeWidth((float)centerCircleStrokeWidth);
        this.mCenterCirclePaint.setColor(centerCircleColor);
        this.mCenterCirclePaint.setStyle(Paint.Style.STROKE);
        this.mRipplePaint.setStrokeWidth((float)rippleStrokeWidth);
        this.mRipplePaint.setColor(rippleColor);
        this.mRipplePaint.setStyle(Paint.Style.STROKE);
        this.mRightCorner = rightRightCorner;
        this.mRightPaint.setPathEffect((PathEffect)new CornerPathEffect((float)this.mRightCorner));
        this.mRightPaint.setStrokeWidth((float)rightStrokeWidth);
        this.mRightPaint.setColor(rightColor);
        this.mRightPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mRightPaint.setStyle(Paint.Style.STROKE);
        this.mDeleteCorner = deleteRightCorner;
        this.mDeletePaint.setPathEffect((PathEffect)new CornerPathEffect((float)this.mDeleteCorner));
        this.mDeletePaint.setStrokeWidth((float)deleteStrokeWidth);
        this.mDeletePaint.setColor(deleteColor);
        this.mDeletePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mDeletePaint.setStyle(Paint.Style.STROKE);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RippleCheckBox.this.isEnableClick()) {
                    RippleCheckBox.this.handleNextStatus(false);
                }
            }
        });
        this.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (RippleCheckBox.this.isEnableLongClick()) {
                    RippleCheckBox.this.handleNextStatus(true);
                }
                return true;
            }
        });
    }

    private void handleNextStatus(boolean isLongClicked) {
        this.mLastStatus = this.mCurrentStatus;
        switch (this.mCurrentStatus) {
            case CIRCLE: {
                this.mCurrentStatus = isLongClicked ? this.mCircleLongClickedStatus : this.mCircleClickedStatus;
                break;
            }
            case HOOK: {
                this.mCurrentStatus = isLongClicked ? this.mHookLongClickedStatus : this.mHookClickedStatus;
                break;
            }
            case CROSS: {
                Status status = this.mCurrentStatus = isLongClicked ? this.mCrossLongClickedStatus : this.mCrossClickedStatus;
            }
        }
        if (this.mListener != null) {
            this.mListener.onCheckedChanged(this, this.mCurrentStatus);
        }
        this.startAnim();
    }

    public void updateCenterCircle() {
        this.mCenterCirclePath.reset();
        RectF circleRectF = new RectF(this.mCenterPointF.x - (float)this.mCenterCircleRadius, this.mCenterPointF.y - (float)this.mCenterCircleRadius, this.mCenterPointF.x + (float)this.mCenterCircleRadius, this.mCenterPointF.y + (float)this.mCenterCircleRadius);
        this.mCenterCirclePath.addOval(circleRectF, Path.Direction.CW);
        this.mCenterCirclePathMeasure.setPath(this.mCenterCirclePath, true);
        float[] start = new float[2];
        float[] center = new float[2];
        float[] end = new float[2];
        float len = this.mCenterCirclePathMeasure.getLength();
        this.mCenterCirclePathMeasure.getPosTan(len * (float)this._360_right_degree_start / 360.0f, start, new float[2]);
        this.mCenterCirclePathMeasure.getPosTan(len * (float)this._360_right_degree_center / 360.0f, center, new float[2]);
        this.mCenterCirclePathMeasure.getPosTan(len * (float)this._360_right_degree_end / 360.0f, end, new float[2]);
        this.mRightPath.reset();
        this.mRightPath.moveTo(start[0], start[1]);
        this.mRightPath.lineTo(center[0], center[1]);
        this.mRightPath.lineTo(end[0], end[1]);
        this.mRightPathMeasure.setPath(this.mRightPath, false);
        this.mRightPathMeasureLen = this.mRightPathMeasure.getLength();
        float size = circleRectF.width() * this.mDeleteScale;
        float l = circleRectF.left + (circleRectF.width() - size) / 2.0f;
        float t = circleRectF.top + (circleRectF.height() - size) / 2.0f;
        float r = l + size;
        float b = t + size;
        RectF deleteRectF = new RectF(l, t, r, b);
        this.mDeleteOnePath.reset();
        this.mDeleteOnePath.moveTo(deleteRectF.right, deleteRectF.top);
        this.mDeleteOnePath.lineTo(deleteRectF.left, deleteRectF.bottom);
        this.mDeleteTwoPath.reset();
        this.mDeleteTwoPath.moveTo(deleteRectF.left, deleteRectF.top);
        this.mDeleteTwoPath.lineTo(deleteRectF.right, deleteRectF.bottom);
        this.mDeleteOnePathMeasure.setPath(this.mDeleteOnePath, false);
        this.mDeleteTwoPathMeasure.setPath(this.mDeleteTwoPath, false);
        this.mDeletePathMeasureLen = this.mDeleteOnePathMeasure.getLength();
        this.mDeleteTotalPath.reset();
        this.mDeleteTotalPath.addPath(this.mDeleteOnePath);
        this.mDeleteTotalPath.addPath(this.mDeleteTwoPath);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCenterPointF.set((float)w * 1.0f / 2.0f, (float)h * 1.0f / 2.0f);
        this.mWH.set((float)w, (float)h);
        this.updateCenterCircle();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mRightCheckedAnimator != null && this.mRightCheckedAnimator.isRunning() || this.mRightUnCheckedAnimator != null && this.mRightUnCheckedAnimator.isRunning()) {
            this.mRightPathDst.reset();
            this.mRightPathDst.moveTo(-2000.0f, -2000.0f);
            this.mRightPathDst.rLineTo(0.0f, 0.0f);
            this.mRightPathMeasure.getSegment(0.0f, this.mRightPathMeasureLen * this.mRightAnimatorValue, this.mRightPathDst, true);
            canvas.drawPath(this.mRightPathDst, this.mRightPaint);
        } else if (this.mRippleCheckedAnimator != null && this.mRippleCheckedAnimator.isRunning() || this.mRippleUnCheckedAnimator != null && this.mRippleUnCheckedAnimator.isRunning()) {
            float value = 1.0f - this.mRippleAnimatorValue / (this.mWH.x / 2.0f);
            this.mRipplePaint.setAlpha((int)(255.0f * value));
            canvas.drawCircle(this.mCenterPointF.x, this.mCenterPointF.y, this.mRippleAnimatorValue, this.mRipplePaint);
            if (this.mLastStatus == Status.CIRCLE) {
                canvas.drawPath(this.mCenterCirclePath, this.mCenterCirclePaint);
            }
        } else if (this.mDeleteCheckedAnimator != null && this.mDeleteCheckedAnimator.isRunning() || this.mDeleteUnCheckedAnimator != null && this.mDeleteUnCheckedAnimator.isRunning()) {
            this.mDeletePathDst.reset();
            if (this.mDeleteAnimatorValue <= 0.5f) {
                this.mDeleteOnePathMeasure.getSegment(0.0f, this.mDeletePathMeasureLen * this.mDeleteAnimatorValue * 2.0f, this.mDeletePathDst, true);
            } else {
                this.mDeleteTwoPathMeasure.getSegment(0.0f, this.mDeletePathMeasureLen * (this.mDeleteAnimatorValue - 0.5f) * 2.0f, this.mDeletePathDst, true);
                this.mDeletePathDst.addPath(this.mDeleteOnePath);
            }
            canvas.drawPath(this.mDeletePathDst, this.mDeletePaint);
        } else if (this.mCurrentStatus == Status.CROSS) {
            canvas.drawPath(this.mDeleteTotalPath, this.mDeletePaint);
        } else if (this.mCurrentStatus == Status.HOOK) {
            canvas.drawPath(this.mRightPath, this.mRightPaint);
        } else {
            canvas.drawPath(this.mCenterCirclePath, this.mCenterCirclePaint);
        }
    }

    private void handleDeleteCheckedAnimator() {
        if (this.mDeleteCheckedAnimator == null) {
            this.mDeleteCheckedAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mDeleteCheckedAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.mDeleteCheckedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RippleCheckBox.this.mDeleteAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                    RippleCheckBox.this.postInvalidate();
                }
            });
        }
        this.mDeleteCheckedAnimator.setDuration((long)this.mDurationDelete);
    }

    private void handleRightCheckedAnimator() {
        if (this.mRightCheckedAnimator == null) {
            this.mRightCheckedAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mRightCheckedAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mRightCheckedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RippleCheckBox.this.mRightAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                    RippleCheckBox.this.postInvalidate();
                }
            });
        }
        this.mRightCheckedAnimator.setDuration((long)this.mDurationRight);
    }

    private void handleRippleCheckedAnimator() {
        if (this.mRippleCheckedAnimator == null) {
            this.mRippleCheckedAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mCenterCircleRadius, this.mWH.x / 2.0f - (float)this.mRippleMargin});
            this.mRippleCheckedAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mRippleCheckedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RippleCheckBox.this.mRippleAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                    RippleCheckBox.this.postInvalidate();
                }
            });
        }
        this.mRippleCheckedAnimator.setDuration((long)this.mDurationRipple);
    }

    private void startAnim() {
        if (this.mRippleCheckedAnimator != null && this.mRippleCheckedAnimator.isRunning()) {
            this.mRippleCheckedAnimator.cancel();
        }
        if (this.mRightCheckedAnimator != null && this.mRightCheckedAnimator.isRunning()) {
            this.mRightCheckedAnimator.cancel();
        }
        if (this.mDeleteCheckedAnimator != null && this.mDeleteCheckedAnimator.isRunning()) {
            this.mDeleteCheckedAnimator.cancel();
        }
        if (this.mRippleUnCheckedAnimator != null && this.mRippleUnCheckedAnimator.isRunning()) {
            this.mRippleUnCheckedAnimator.cancel();
        }
        if (this.mRightUnCheckedAnimator != null && this.mRightUnCheckedAnimator.isRunning()) {
            this.mRightUnCheckedAnimator.cancel();
        }
        if (this.mDeleteUnCheckedAnimator != null && this.mDeleteUnCheckedAnimator.isRunning()) {
            this.mDeleteUnCheckedAnimator.cancel();
        }
        this.handleDeleteCheckedAnimator();
        this.handleRightCheckedAnimator();
        this.handleRippleCheckedAnimator();
        this.handleRippleUnCheckedAnimator();
        this.handleDeleteUnCheckedAnimator();
        this.handleRightUnCheckedAnimator();
        this.mRippleCheckedAnimator.removeAllListeners();
        this.mDeleteUnCheckedAnimator.removeAllListeners();
        this.mRightUnCheckedAnimator.removeAllListeners();
        if (this.mLastStatus == Status.CIRCLE) {
            this.mRippleCheckedAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (RippleCheckBox.this.mCurrentStatus == Status.CROSS) {
                        RippleCheckBox.this.mDeleteCheckedAnimator.start();
                    } else {
                        RippleCheckBox.this.mRightCheckedAnimator.start();
                    }
                }
            });
            this.mRippleCheckedAnimator.start();
        } else if (this.mLastStatus == Status.HOOK) {
            this.mRightUnCheckedAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (RippleCheckBox.this.mCurrentStatus == Status.CIRCLE) {
                        RippleCheckBox.this.mRippleUnCheckedAnimator.start();
                    } else {
                        RippleCheckBox.this.mDeleteCheckedAnimator.start();
                    }
                }
            });
            this.mRightUnCheckedAnimator.start();
        } else if (this.mLastStatus == Status.CROSS) {
            this.mDeleteUnCheckedAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (RippleCheckBox.this.mCurrentStatus == Status.CIRCLE) {
                        RippleCheckBox.this.mRippleUnCheckedAnimator.start();
                    } else {
                        RippleCheckBox.this.mRightCheckedAnimator.start();
                    }
                }
            });
            this.mDeleteUnCheckedAnimator.start();
        }
    }

    private void handleRippleUnCheckedAnimator() {
        if (this.mRippleUnCheckedAnimator == null) {
            this.mRippleUnCheckedAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mWH.x / 2.0f - (float)this.mRippleMargin, this.mCenterCircleRadius});
            this.mRippleUnCheckedAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mRippleUnCheckedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RippleCheckBox.this.mRippleAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                    RippleCheckBox.this.postInvalidate();
                }
            });
        }
        this.mRippleUnCheckedAnimator.setDuration((long)this.mDurationRipple);
    }

    private void handleRightUnCheckedAnimator() {
        if (this.mRightUnCheckedAnimator == null) {
            this.mRightUnCheckedAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            this.mRightUnCheckedAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mRightUnCheckedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RippleCheckBox.this.mRightAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                    RippleCheckBox.this.postInvalidate();
                }
            });
        }
        this.mRightUnCheckedAnimator.setDuration((long)this.mDurationRight);
    }

    private void handleDeleteUnCheckedAnimator() {
        if (this.mDeleteUnCheckedAnimator == null) {
            this.mDeleteUnCheckedAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            this.mDeleteUnCheckedAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mDeleteUnCheckedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RippleCheckBox.this.mDeleteAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                    RippleCheckBox.this.postInvalidate();
                }
            });
        }
        this.mDeleteUnCheckedAnimator.setDuration((long)this.mDurationDelete);
    }

    public void setCurrentStatus(Status status) {
        this.setCurrentStatus(status, false);
    }

    public void setCurrentStatus(Status status, boolean animal) {
        this.mLastStatus = this.mCurrentStatus;
        this.mCurrentStatus = status;
        if (this.mListener != null) {
            this.mListener.onCheckedChanged(this, this.mCurrentStatus);
        }
        if (animal) {
            this.startAnim();
        } else {
            this.invalidate();
        }
    }

    public Status getCurrentStatus() {
        return this.mCurrentStatus;
    }

    public int getCenterCircleRadius() {
        return this.mCenterCircleRadius;
    }

    public void setCenterCircleRadius(int radius) {
        if (radius < 0 || (float)radius > this.mWH.x) {
            return;
        }
        this.mCenterCircleRadius = radius;
    }

    public float getCenterCircleStrokeWidth() {
        return this.mCenterCirclePaint.getStrokeWidth();
    }

    public void setCenterCircleStrokeWidth(float value) {
        if (value < 0.0f || value > (float)this.mCenterCircleRadius) {
            return;
        }
        this.mCenterCirclePaint.setStrokeWidth(value);
    }

    public void setCenterCircleColor(int color) {
        this.mCenterCirclePaint.setColor(color);
    }

    public float getRightStrokeWidth() {
        return this.mRightPaint.getStrokeWidth();
    }

    public void setRightStrokeWidth(float value) {
        if (value < 0.0f || value > (float)this.mCenterCircleRadius) {
            return;
        }
        this.mRightPaint.setStrokeWidth(value);
    }

    public void setRightColor(int color) {
        this.mRightPaint.setColor(color);
    }

    public float getDeleteScale() {
        return this.mDeleteScale;
    }

    public void setDeleteScale(float deleteScale) {
        this.mDeleteScale = deleteScale;
    }

    public int getDeleteCorner() {
        return this.mDeleteCorner;
    }

    public void setDeleteCorner(int deleteCorner) {
        this.mDeleteCorner = deleteCorner;
    }

    public float getDeleteStrokeWidth() {
        return this.mDeletePaint.getStrokeWidth();
    }

    public void setDeleteStrokeWidth(float value) {
        if (value < 0.0f || value > (float)this.mCenterCircleRadius) {
            return;
        }
        this.mDeletePaint.setStrokeWidth(value);
    }

    public void setDeleteColor(int color) {
        this.mDeletePaint.setColor(color);
    }

    public float getRippleStrokeWidth() {
        return this.mRipplePaint.getStrokeWidth();
    }

    public void setRippleStrokeWidth(float value) {
        if (value < 0.0f || value > this.mWH.x / 2.0f) {
            return;
        }
        this.mRipplePaint.setStrokeWidth(value);
    }

    public void setRippleColor(int color) {
        this.mRipplePaint.setColor(color);
    }

    public int getRippleDuration() {
        return this.mDurationRipple;
    }

    public void setRippleDuration(int ms) {
        if (ms < 0) {
            return;
        }
        this.mDurationRipple = ms;
    }

    public int getDeleteDuration() {
        return this.mDurationDelete;
    }

    public void setDeleteDuration(int ms) {
        if (ms < 0) {
            return;
        }
        this.mDurationDelete = ms;
    }

    public int getRightDuration() {
        return this.mDurationRight;
    }

    public void setRightDuration(int ms) {
        if (ms < 0) {
            return;
        }
        this.mDurationRight = ms;
    }

    public int getRightStartDegree() {
        return this._360_right_degree_start;
    }

    public void setRightStartDegree(int degree) {
        if (degree < 0 || degree > 360) {
            return;
        }
        this._360_right_degree_start = degree;
    }

    public int getRightCenterDegree() {
        return this._360_right_degree_center;
    }

    public void setRightCenterDegree(int degree) {
        if (degree < 0 || degree > 360) {
            return;
        }
        this._360_right_degree_center = degree;
    }

    public int getRightEndDegree() {
        return this._360_right_degree_end;
    }

    public void setRightEndDegree(int degree) {
        if (degree < 0 || degree > 360) {
            return;
        }
        this._360_right_degree_end = degree;
    }

    public boolean isEnableDeleteMode() {
        return this.enableDeleteMode;
    }

    public void setEnableDeleteMode(boolean enableDeleteMode) {
        this.enableDeleteMode = enableDeleteMode;
    }

    public int getRightCorner() {
        return this.mRightCorner;
    }

    public void setRightCorner(int corner) {
        this.mRightPaint.setPathEffect((PathEffect)new CornerPathEffect((float)corner));
    }

    public int getRippleMargin() {
        return this.mRippleMargin;
    }

    public void setRippleMargin(int margin) {
        if (margin < 0 || (float)margin > this.mWH.x / 2.0f - (float)this.mCenterCircleRadius) {
            return;
        }
        this.mRippleMargin = margin;
        this.mRippleUnCheckedAnimator = null;
        this.mRippleCheckedAnimator = null;
    }

    public boolean isEnableClick() {
        return this.mEnableClick;
    }

    public void setEnableClick(boolean enableClick) {
        this.mEnableClick = enableClick;
    }

    public boolean isEnableLongClick() {
        return this.mEnableLongClick;
    }

    public void setEnableLongClick(boolean enableLongClick) {
        this.mEnableLongClick = enableLongClick;
    }

    public Status getLastStatus() {
        return this.mLastStatus;
    }

    public Status getCircleClickedStatus() {
        return this.mCircleClickedStatus;
    }

    public void setCircleClickedStatus(Status circleClickedStatus) {
        this.mCircleClickedStatus = circleClickedStatus;
    }

    public Status getCircleLongClickedStatus() {
        return this.mCircleLongClickedStatus;
    }

    public void setCircleLongClickedStatus(Status circleLongClickedStatus) {
        this.mCircleLongClickedStatus = circleLongClickedStatus;
    }

    public Status getHookClickedStatus() {
        return this.mHookClickedStatus;
    }

    public void setHookClickedStatus(Status hookClickedStatus) {
        this.mHookClickedStatus = hookClickedStatus;
    }

    public Status getHookLongClickedStatus() {
        return this.mHookLongClickedStatus;
    }

    public void setHookLongClickedStatus(Status hookLongClickedStatus) {
        this.mHookLongClickedStatus = hookLongClickedStatus;
    }

    public Status getCrossClickedStatus() {
        return this.mCrossClickedStatus;
    }

    public void setCrossClickedStatus(Status crossClickedStatus) {
        this.mCrossClickedStatus = crossClickedStatus;
    }

    public Status getCrossLongClickedStatus() {
        return this.mCrossLongClickedStatus;
    }

    public void setCrossLongClickedStatus(Status crossLongClickedStatus) {
        this.mCrossLongClickedStatus = crossLongClickedStatus;
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putInt(KEY_INSTANCE_STATE, this.mCurrentStatus.value);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            int status = bundle.getInt(KEY_INSTANCE_STATE, Status.CIRCLE.value);
            this.setCurrentStatus(Status.of(status), false);
            super.onRestoreInstanceState(bundle.getParcelable(KEY_INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener l) {
        this.mListener = l;
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RippleCheckBox var1, Status var2);
    }

    public static enum Status {
        CIRCLE(0),
        HOOK(1),
        CROSS(2);

        public final int value;

        private Status(int value) {
            this.value = value;
        }

        public static Status of(int value) {
            if (value == 1) {
                return HOOK;
            }
            if (value == 2) {
                return CROSS;
            }
            return CIRCLE;
        }
    }
}

