/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.library;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.widget.Checkable;
import com.xujiaji.library.R;
import com.xujiaji.library.RippleCheckBoxUtil;

public class RippleCheckBox
extends View
implements Checkable {
    private static final String KEY_INSTANCE_STATE = "InstanceState";
    private Paint mCenterCirclePaint;
    private Paint mRipplePaint;
    private Paint mRightPaint;
    private Path mRightPath;
    private Path mRightPathDst;
    private Path mCenterCirclePath;
    private PathMeasure mRightPathMeasure = new PathMeasure();
    private float mRightPathMeasureLen;
    private PathMeasure mCenterCirclePathMeasure = new PathMeasure();
    private int mCenterCircleRadius;
    private PointF mCenterPointF = new PointF();
    private PointF mWH = new PointF();
    private boolean isChecked;
    private float mRightAnimatorValue;
    private float mRippleAnimatorValue;
    private ValueAnimator mRightCheckedAnimator;
    private ValueAnimator mRippleCheckedAnimator;
    private ValueAnimator mRightUnCheckedAnimator;
    private ValueAnimator mRippleUnCheckedAnimator;
    private int mDurationRight;
    private int mDurationRipple;
    private OnCheckedChangeListener mListener;
    private int _360_right_degree_start = 150;
    private int _360_right_degree_center = 100;
    private int _360_right_degree_end = 330;
    private int mRightCorner;
    private int mRippleMargin;

    public RippleCheckBox(Context context) {
        this(context, null);
    }

    public RippleCheckBox(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RippleCheckBox(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray t = context.obtainStyledAttributes(attrs, R.styleable.RippleCheckBox, defStyleAttr, 0);
        boolean isChecked = t.getBoolean(R.styleable.RippleCheckBox_rcbChecked, false);
        int centerCircleRadius = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbCenterCircleRadius, RippleCheckBoxUtil.dp2px(context, 10.0f));
        int centerCircleStrokeWidth = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbCenterCircleStrokeWidth, RippleCheckBoxUtil.dp2px(context, 1.0f));
        int centerCircleColor = t.getColor(R.styleable.RippleCheckBox_rcbCenterCircleColor, -7829368);
        int rightStrokeWidth = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbRightStrokeWidth, RippleCheckBoxUtil.dp2px(context, 3.0f));
        int rightColor = t.getColor(R.styleable.RippleCheckBox_rcbRightColor, -16776961);
        int rightDuration = t.getInteger(R.styleable.RippleCheckBox_rcbRightDuration, 400);
        int rippleStrokeWidth = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbRippleStrokeWidth, RippleCheckBoxUtil.dp2px(context, 4.0f));
        int rippleColor = t.getColor(R.styleable.RippleCheckBox_rcbRippleColor, -16776961);
        int rippleDuration = t.getInteger(R.styleable.RippleCheckBox_rcbRippleDuration, 200);
        int rippleMargin = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbRippleMargin, 0);
        int rightStartDegree = t.getInteger(R.styleable.RippleCheckBox_rcbRightStartDegree, this._360_right_degree_start);
        int rightCenterDegree = t.getInteger(R.styleable.RippleCheckBox_rcbRightCenterDegree, this._360_right_degree_center);
        int rightEndDegree = t.getInteger(R.styleable.RippleCheckBox_rcbRightEndDegree, this._360_right_degree_end);
        int rightRightCorner = t.getDimensionPixelOffset(R.styleable.RippleCheckBox_rcbRightCorner, RippleCheckBoxUtil.dp2px(context, 2.0f));
        t.recycle();
        this.isChecked = isChecked;
        this.mCenterCircleRadius = centerCircleRadius;
        this.mDurationRight = rightDuration;
        this.mDurationRipple = rippleDuration;
        this.mRippleMargin = rippleMargin;
        this._360_right_degree_start = rightStartDegree;
        this._360_right_degree_center = rightCenterDegree;
        this._360_right_degree_end = rightEndDegree;
        this.mRightPath = new Path();
        this.mRightPathDst = new Path();
        this.mCenterCirclePath = new Path();
        this.mCenterCirclePaint = new Paint(5);
        this.mRipplePaint = new Paint(5);
        this.mRightPaint = new Paint(5);
        this.mCenterCirclePaint.setStrokeWidth((float)centerCircleStrokeWidth);
        this.mCenterCirclePaint.setColor(centerCircleColor);
        this.mCenterCirclePaint.setStyle(Paint.Style.STROKE);
        this.mRipplePaint.setStrokeWidth((float)rippleStrokeWidth);
        this.mRipplePaint.setColor(rippleColor);
        this.mRipplePaint.setStyle(Paint.Style.STROKE);
        this.mRightCorner = rightRightCorner;
        this.mRightPaint.setPathEffect((PathEffect)new CornerPathEffect((float)this.mRightCorner));
        this.mRightPaint.setStrokeWidth((float)rightStrokeWidth);
        this.mRightPaint.setColor(rightColor);
        this.mRightPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mRightPaint.setStyle(Paint.Style.STROKE);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RippleCheckBox.this.setChecked(!RippleCheckBox.this.isChecked, true);
            }
        });
    }

    public void updateCenterCircle() {
        this.mCenterCirclePath.reset();
        this.mCenterCirclePath.addOval(new RectF(this.mCenterPointF.x - (float)this.mCenterCircleRadius, this.mCenterPointF.y - (float)this.mCenterCircleRadius, this.mCenterPointF.x + (float)this.mCenterCircleRadius, this.mCenterPointF.y + (float)this.mCenterCircleRadius), Path.Direction.CW);
        this.mCenterCirclePathMeasure.setPath(this.mCenterCirclePath, true);
        float[] start = new float[2];
        float[] center = new float[2];
        float[] end = new float[2];
        float len = this.mCenterCirclePathMeasure.getLength();
        this.mCenterCirclePathMeasure.getPosTan(len * (float)this._360_right_degree_start / 360.0f, start, new float[2]);
        this.mCenterCirclePathMeasure.getPosTan(len * (float)this._360_right_degree_center / 360.0f, center, new float[2]);
        this.mCenterCirclePathMeasure.getPosTan(len * (float)this._360_right_degree_end / 360.0f, end, new float[2]);
        this.mRightPath.reset();
        this.mRightPath.moveTo(start[0], start[1]);
        this.mRightPath.lineTo(center[0], center[1]);
        this.mRightPath.lineTo(end[0], end[1]);
        this.mRightPathMeasure.setPath(this.mRightPath, false);
        this.mRightPathMeasureLen = this.mRightPathMeasure.getLength();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCenterPointF.set((float)w * 1.0f / 2.0f, (float)h * 1.0f / 2.0f);
        this.mWH.set((float)w, (float)h);
        this.updateCenterCircle();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mRightCheckedAnimator != null && this.mRightCheckedAnimator.isRunning() || this.mRightUnCheckedAnimator != null && this.mRightUnCheckedAnimator.isRunning()) {
            this.mRightPathDst.reset();
            this.mRightPathDst.moveTo(-2000.0f, -2000.0f);
            this.mRightPathDst.rLineTo(0.0f, 0.0f);
            this.mRightPathMeasure.getSegment(0.0f, this.mRightPathMeasureLen * this.mRightAnimatorValue, this.mRightPathDst, true);
            canvas.drawPath(this.mRightPathDst, this.mRightPaint);
        } else if (this.mRippleCheckedAnimator != null && this.mRippleCheckedAnimator.isRunning() || this.mRippleUnCheckedAnimator != null && this.mRippleUnCheckedAnimator.isRunning()) {
            float value = 1.0f - this.mRippleAnimatorValue / (this.mWH.x / 2.0f);
            this.mRipplePaint.setAlpha((int)(255.0f * value));
            canvas.drawCircle(this.mCenterPointF.x, this.mCenterPointF.y, this.mRippleAnimatorValue, this.mRipplePaint);
            if (this.isChecked) {
                canvas.drawPath(this.mCenterCirclePath, this.mCenterCirclePaint);
            }
        } else if (this.isChecked) {
            canvas.drawPath(this.mRightPath, this.mRightPaint);
        } else {
            canvas.drawPath(this.mCenterCirclePath, this.mCenterCirclePaint);
        }
    }

    private void startCheckedAnim() {
        if (this.mRippleCheckedAnimator != null && this.mRippleCheckedAnimator.isRunning()) {
            this.mRippleCheckedAnimator.cancel();
        }
        if (this.mRightCheckedAnimator != null && this.mRightCheckedAnimator.isRunning()) {
            this.mRightCheckedAnimator.cancel();
        }
        if (this.mRightCheckedAnimator == null) {
            this.mRightCheckedAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mRightCheckedAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mRightCheckedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RippleCheckBox.this.mRightAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                    RippleCheckBox.this.postInvalidate();
                }
            });
        }
        this.mRightCheckedAnimator.setDuration((long)this.mDurationRight);
        if (this.mRippleCheckedAnimator == null) {
            this.mRippleCheckedAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mCenterCircleRadius, this.mWH.x / 2.0f - (float)this.mRippleMargin});
            this.mRippleCheckedAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mRippleCheckedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RippleCheckBox.this.mRippleAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                    RippleCheckBox.this.postInvalidate();
                }
            });
            this.mRippleCheckedAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    RippleCheckBox.this.mRightCheckedAnimator.start();
                }
            });
        }
        this.mRippleCheckedAnimator.setDuration((long)this.mDurationRipple);
        this.mRippleCheckedAnimator.start();
    }

    private void startUnCheckedAnim() {
        if (this.mRippleUnCheckedAnimator != null && this.mRippleUnCheckedAnimator.isRunning()) {
            this.mRippleUnCheckedAnimator.cancel();
        }
        if (this.mRightUnCheckedAnimator != null && this.mRightUnCheckedAnimator.isRunning()) {
            this.mRightUnCheckedAnimator.cancel();
        }
        if (this.mRippleUnCheckedAnimator == null) {
            this.mRippleUnCheckedAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mWH.x / 2.0f - (float)this.mRippleMargin, this.mCenterCircleRadius});
            this.mRippleUnCheckedAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mRippleUnCheckedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RippleCheckBox.this.mRippleAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                    RippleCheckBox.this.postInvalidate();
                }
            });
        }
        this.mRippleUnCheckedAnimator.setDuration((long)this.mDurationRipple);
        if (this.mRightUnCheckedAnimator == null) {
            this.mRightUnCheckedAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            this.mRightUnCheckedAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mRightUnCheckedAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RippleCheckBox.this.mRightAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                    RippleCheckBox.this.postInvalidate();
                }
            });
            this.mRightUnCheckedAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    RippleCheckBox.this.mRippleUnCheckedAnimator.start();
                }
            });
        }
        this.mRightUnCheckedAnimator.setDuration((long)this.mDurationRight);
        this.mRightUnCheckedAnimator.start();
    }

    public void setChecked(boolean checked, boolean animal) {
        if (animal) {
            this.isChecked = checked;
            if (this.isChecked) {
                this.startCheckedAnim();
            } else {
                this.startUnCheckedAnim();
            }
            if (this.mListener != null) {
                this.mListener.onCheckedChanged(this, this.isChecked);
            }
        } else {
            this.setChecked(checked);
        }
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
        this.invalidate();
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void toggle() {
        this.setChecked(!this.isChecked);
    }

    public int getCenterCircleRadius() {
        return this.mCenterCircleRadius;
    }

    public void setCenterCircleRadius(int radius) {
        if (radius < 0 || (float)radius > this.mWH.x) {
            return;
        }
        this.mCenterCircleRadius = radius;
    }

    public float getCenterCircleStrokeWidth() {
        return this.mCenterCirclePaint.getStrokeWidth();
    }

    public void setCenterCircleStrokeWidth(float value) {
        if (value < 0.0f || value > (float)this.mCenterCircleRadius) {
            return;
        }
        this.mCenterCirclePaint.setStrokeWidth(value);
    }

    public void setCenterCircleColor(int color) {
        this.mCenterCirclePaint.setColor(color);
    }

    public float getRightStrokeWidth() {
        return this.mRightPaint.getStrokeWidth();
    }

    public void setRightStrokeWidth(float value) {
        if (value < 0.0f || value > (float)this.mCenterCircleRadius) {
            return;
        }
        this.mRightPaint.setStrokeWidth(value);
    }

    public void setRightColor(int color) {
        this.mRightPaint.setColor(color);
    }

    public float getRippleStrokeWidth() {
        return this.mRipplePaint.getStrokeWidth();
    }

    public void setRippleStrokeWidth(float value) {
        if (value < 0.0f || value > this.mWH.x / 2.0f) {
            return;
        }
        this.mRipplePaint.setStrokeWidth(value);
    }

    public void setRippleColor(int color) {
        this.mRipplePaint.setColor(color);
    }

    public int getRippleDuration() {
        return this.mDurationRipple;
    }

    public void setRippleDuration(int ms) {
        if (ms < 0) {
            return;
        }
        this.mDurationRipple = ms;
    }

    public int getRightDuration() {
        return this.mDurationRight;
    }

    public void setRightDuration(int ms) {
        if (ms < 0) {
            return;
        }
        this.mDurationRight = ms;
    }

    public int getRightStartDegree() {
        return this._360_right_degree_start;
    }

    public void setRightStartDegree(int degree) {
        if (degree < 0 || degree > 360) {
            return;
        }
        this._360_right_degree_start = degree;
    }

    public int getRightCenterDegree() {
        return this._360_right_degree_center;
    }

    public void setRightCenterDegree(int degree) {
        if (degree < 0 || degree > 360) {
            return;
        }
        this._360_right_degree_center = degree;
    }

    public int getRightEndDegree() {
        return this._360_right_degree_end;
    }

    public void setRightEndDegree(int degree) {
        if (degree < 0 || degree > 360) {
            return;
        }
        this._360_right_degree_end = degree;
    }

    public int getRightCorner() {
        return this.mRightCorner;
    }

    public void setRightCorner(int corner) {
        this.mRightPaint.setPathEffect((PathEffect)new CornerPathEffect((float)corner));
    }

    public int getRippleMargin() {
        return this.mRippleMargin;
    }

    public void setRippleMargin(int margin) {
        if (margin < 0 || (float)margin > this.mWH.x / 2.0f - (float)this.mCenterCircleRadius) {
            return;
        }
        this.mRippleMargin = margin;
        this.mRippleUnCheckedAnimator = null;
        this.mRippleCheckedAnimator = null;
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putBoolean(KEY_INSTANCE_STATE, this.isChecked());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            boolean isChecked = bundle.getBoolean(KEY_INSTANCE_STATE);
            this.setChecked(isChecked);
            super.onRestoreInstanceState(bundle.getParcelable(KEY_INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener l) {
        this.mListener = l;
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RippleCheckBox var1, boolean var2);
    }
}

