/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.mvvmquick.base;

import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelProviders;
import android.databinding.ViewDataBinding;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.xujiaji.mvvmquick.base.MQViewModel;
import com.xujiaji.mvvmquick.interfaces.MQFragView;
import com.xujiaji.mvvmquick.util.ClassUtils;
import dagger.android.support.DaggerFragment;
import javax.inject.Inject;

public abstract class MQFragment<B extends ViewDataBinding, VM extends MQViewModel>
extends DaggerFragment
implements MQFragView<B, VM> {
    @Inject
    protected ViewModelProvider.Factory mViewModelFactory;
    protected B binding;
    protected VM viewModel;
    private boolean isFragmentVisible;
    private boolean isPrepared;
    private boolean isFirstLoad = true;
    private boolean forceLoad = false;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        Bundle bundle;
        this.onBeforeCreate();
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.onBundleHandle(savedInstanceState);
        }
        if ((bundle = this.getArguments()) != null && bundle.size() > 0) {
            this.onArgumentsHandle(bundle);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.isFirstLoad = true;
        this.isPrepared = true;
        if (!this.isInViewPager()) {
            this.isFragmentVisible = true;
        }
        this.binding = (ViewDataBinding)ClassUtils.getBinding(this, inflater, container);
        if (this.binding == null) {
            return super.onCreateView(inflater, container, savedInstanceState);
        }
        this.onBinding((ViewDataBinding)this.binding);
        return this.binding.getRoot();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Class viewModelClass = ClassUtils.getViewModel(this);
        if (viewModelClass == null) {
            return;
        }
        MQViewModel viewModel = this.providerVmByActivity() && this.getActivity() != null ? (MQViewModel)ViewModelProviders.of((FragmentActivity)this.getActivity(), (ViewModelProvider.Factory)this.mViewModelFactory).get(viewModelClass) : (MQViewModel)ViewModelProviders.of((Fragment)this, (ViewModelProvider.Factory)this.mViewModelFactory).get(viewModelClass);
        this.viewModel = viewModel;
        this.onObserveViewModel((VM)((Object)viewModel));
        this.onInit();
        this.onListener();
        this.lazyLoad();
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (isVisibleToUser) {
            this.onVisible();
        } else {
            this.onInvisible();
        }
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (hidden) {
            this.onInvisible();
        } else {
            this.onVisible();
        }
    }

    @Override
    public void onVisible() {
        this.isFragmentVisible = true;
        this.lazyLoad();
    }

    private void lazyLoad() {
        if (this.isPrepared() && this.isFragmentVisible() && (this.isForceLoad() || this.isFirstLoad())) {
            this.forceLoad = false;
            this.isFirstLoad = false;
            this.onLazyLoad();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.viewModel != null) {
            ((MQViewModel)((Object)this.viewModel)).onDestroy();
            this.viewModel = null;
        }
        if (this.binding != null) {
            this.binding.unbind();
        }
    }

    protected boolean providerVmByActivity() {
        return false;
    }

    @Override
    public void onObserveViewModel(@NonNull VM viewModel) {
    }

    @Override
    public void onBeforeCreate() {
    }

    @Override
    public void onBundleHandle(@NonNull Bundle savedInstanceState) {
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onListener() {
    }

    @Override
    public void onArgumentsHandle(@NonNull Bundle bundle) {
    }

    @Override
    public void onInvisible() {
        this.isFragmentVisible = false;
    }

    @Override
    public void onLazyLoad() {
    }

    @Override
    public void setForceLoad(boolean forceLoad) {
        this.forceLoad = forceLoad;
    }

    @Override
    public boolean isForceLoad() {
        return this.forceLoad;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public boolean isFirstLoad() {
        return this.isFirstLoad;
    }

    @Override
    public boolean isFragmentVisible() {
        return this.isFragmentVisible;
    }

    @Override
    public boolean isInViewPager() {
        return true;
    }
}

