/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.mvvmquick.base;

import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Intent;
import android.databinding.ViewDataBinding;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.view.ViewGroup;
import com.xujiaji.mvvmquick.interfaces.MQView;
import com.xujiaji.mvvmquick.util.ClassUtils;
import dagger.android.support.DaggerAppCompatActivity;
import javax.inject.Inject;

public abstract class MQActivity<B extends ViewDataBinding, VM extends AndroidViewModel>
extends DaggerAppCompatActivity
implements MQView<B, VM> {
    @Inject
    protected ViewModelProvider.Factory mViewModelFactory;
    protected B binding;
    protected VM viewModel;

    protected void onCreate(Bundle savedInstanceState) {
        this.onBeforeCreate();
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.onBundleHandle(savedInstanceState);
        } else {
            Intent intent = this.getIntent();
            if (intent != null) {
                this.onIntentHandle(intent);
            }
        }
        this.initBinding();
        this.initViewModel();
        this.onInit();
        this.onListener();
    }

    private void initViewModel() {
        Class viewModelClass = ClassUtils.getViewModel(this);
        if (viewModelClass == null) {
            return;
        }
        AndroidViewModel viewModel = (AndroidViewModel)ViewModelProviders.of((FragmentActivity)this, (ViewModelProvider.Factory)this.mViewModelFactory).get(viewModelClass);
        this.viewModel = viewModel;
        this.onObserveViewModel(viewModel);
    }

    private void initBinding() {
        this.binding = (ViewDataBinding)ClassUtils.getBinding(this, this.getLayoutInflater(), (ViewGroup)this.findViewById(0x1020002));
        if (this.binding != null) {
            this.setContentView(this.binding.getRoot());
            this.onBinding((ViewDataBinding)this.binding);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        if (intent != null) {
            this.onIntentHandle(intent);
        }
        this.onListener();
    }

    @Override
    public void onObserveViewModel(@NonNull VM viewModel) {
    }

    @Override
    public void onBeforeCreate() {
    }

    @Override
    public void onBundleHandle(@NonNull Bundle savedInstanceState) {
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onListener() {
    }

    @Override
    public void onIntentHandle(@NonNull Intent intent) {
    }
}

