/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.mvvmquick.util;

import android.databinding.ViewDataBinding;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.xujiaji.mvvmquick.base.MQViewModel;
import com.xujiaji.mvvmquick.base.NoneViewModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ClassUtils {
    private static <T> Class<T> getGenericClass(Class<?> klass, Class<?> filterClass) {
        Type[] types;
        Type type = klass.getGenericSuperclass();
        if (type == null || !(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        for (Type t : types = parameterizedType.getActualTypeArguments()) {
            Class tClass = (Class)t;
            if (!filterClass.isAssignableFrom(tClass)) continue;
            return tClass;
        }
        return null;
    }

    public static <T> Class<T> getViewModel(Object obj) {
        Class<?> currentClass = obj.getClass();
        Class<T> tClass = ClassUtils.getGenericClass(currentClass, MQViewModel.class);
        if (tClass == null || tClass == MQViewModel.class || tClass == NoneViewModel.class) {
            return null;
        }
        return tClass;
    }

    public static <T> T getBinding(@NonNull Object obj, @NonNull LayoutInflater inflater, @Nullable ViewGroup container) {
        Class<?> currentClass = obj.getClass();
        Class<T> tClass = ClassUtils.getGenericClass(currentClass, ViewDataBinding.class);
        if (tClass == null || tClass == ViewDataBinding.class) {
            return null;
        }
        try {
            Method method = tClass.getMethod("inflate", LayoutInflater.class, ViewGroup.class, Boolean.TYPE);
            Object returnValue = method.invoke(null, inflater, container, false);
            return (T)returnValue;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

