/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.happybubble;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.FrameLayout;
import com.xujiaji.happybubble.R;
import com.xujiaji.happybubble.Util;

public class BubbleLayout
extends FrameLayout {
    private Paint mPaint;
    private Path mPath;
    private Look mLook;
    private int mBubblePadding;
    private int mWidth;
    private int mHeight;
    private int mLeft;
    private int mTop;
    private int mRight;
    private int mBottom;
    private int mLookPosition;
    private int mLookWidth;
    private int mLookLength;
    private int mShadowColor;
    private int mShadowRadius;
    private int mShadowX;
    private int mShadowY;
    private int mBubbleRadius;
    private int mBubbleColor;
    private int mLTR;
    private int mRTR;
    private int mRDR;
    private int mLDR;
    private int mArrowTopLeftRadius;
    private int mArrowTopRightRadius;
    private int mArrowDownLeftRadius;
    private int mArrowDownRightRadius;
    private OnClickEdgeListener mListener;
    private Region mRegion = new Region();
    private int mBubbleBgRes = -1;
    private Bitmap mBubbleImageBg = null;
    private RectF mBubbleImageBgDstRectF = new RectF();
    private Rect mBubbleImageBgSrcRect = new Rect();
    private Paint mBubbleImageBgPaint = new Paint(5);
    private Paint mBubbleImageBgBeforePaint = new Paint(5);
    private int mBubbleBorderColor = -16777216;
    private int mBubbleBorderSize = 0;
    private Paint mBubbleBorderPaint = new Paint(5);

    public BubbleLayout(Context context) {
        this(context, null);
    }

    public BubbleLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BubbleLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayerType(1, null);
        this.setWillNotDraw(false);
        this.initAttr(context.obtainStyledAttributes(attrs, R.styleable.BubbleLayout, defStyleAttr, 0));
        this.mPaint = new Paint(5);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPath = new Path();
        this.mBubbleImageBgPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        this.initPadding();
    }

    public void initPadding() {
        int p = this.mBubblePadding + this.mShadowRadius;
        switch (this.mLook) {
            case BOTTOM: {
                this.setPadding(p, p, p + this.mShadowX, this.mLookLength + p + this.mShadowY);
                break;
            }
            case TOP: {
                this.setPadding(p, p + this.mLookLength, p + this.mShadowX, p + this.mShadowY);
                break;
            }
            case LEFT: {
                this.setPadding(p + this.mLookLength, p, p + this.mShadowX, p + this.mShadowY);
                break;
            }
            case RIGHT: {
                this.setPadding(p, p, p + this.mLookLength + this.mShadowX, p + this.mShadowY);
            }
        }
    }

    private void initAttr(TypedArray a) {
        this.mLook = Look.getType(a.getInt(R.styleable.BubbleLayout_lookAt, Look.BOTTOM.value));
        this.mLookPosition = a.getDimensionPixelOffset(R.styleable.BubbleLayout_lookPosition, 0);
        this.mLookWidth = a.getDimensionPixelOffset(R.styleable.BubbleLayout_lookWidth, Util.dpToPx(this.getContext(), 13.0f));
        this.mLookLength = a.getDimensionPixelOffset(R.styleable.BubbleLayout_lookLength, Util.dpToPx(this.getContext(), 12.0f));
        this.mShadowRadius = a.getDimensionPixelOffset(R.styleable.BubbleLayout_shadowRadius, Util.dpToPx(this.getContext(), 3.3f));
        this.mShadowX = a.getDimensionPixelOffset(R.styleable.BubbleLayout_shadowX, Util.dpToPx(this.getContext(), 1.0f));
        this.mShadowY = a.getDimensionPixelOffset(R.styleable.BubbleLayout_shadowY, Util.dpToPx(this.getContext(), 1.0f));
        this.mBubbleRadius = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubbleRadius, Util.dpToPx(this.getContext(), 8.0f));
        this.mLTR = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubbleLeftTopRadius, -1);
        this.mRTR = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubbleRightTopRadius, -1);
        this.mRDR = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubbleRightDownRadius, -1);
        this.mLDR = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubbleLeftDownRadius, -1);
        this.mArrowTopLeftRadius = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubbleArrowTopLeftRadius, Util.dpToPx(this.getContext(), 3.0f));
        this.mArrowTopRightRadius = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubbleArrowTopRightRadius, Util.dpToPx(this.getContext(), 3.0f));
        this.mArrowDownLeftRadius = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubbleArrowDownLeftRadius, Util.dpToPx(this.getContext(), 6.0f));
        this.mArrowDownRightRadius = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubbleArrowDownRightRadius, Util.dpToPx(this.getContext(), 6.0f));
        this.mBubblePadding = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubblePadding, Util.dpToPx(this.getContext(), 8.0f));
        this.mShadowColor = a.getColor(R.styleable.BubbleLayout_shadowColor, -7829368);
        this.mBubbleColor = a.getColor(R.styleable.BubbleLayout_bubbleColor, -1);
        this.mBubbleBgRes = a.getResourceId(R.styleable.BubbleLayout_bubbleBgRes, -1);
        if (this.mBubbleBgRes != -1) {
            this.mBubbleImageBg = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mBubbleBgRes);
        }
        this.mBubbleBorderColor = a.getColor(R.styleable.BubbleLayout_bubbleBorderColor, -16777216);
        this.mBubbleBorderSize = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubbleBorderSize, 0);
        a.recycle();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.initData();
    }

    public void invalidate() {
        this.initData();
        super.invalidate();
    }

    public void postInvalidate() {
        this.initData();
        super.postInvalidate();
    }

    private void initData() {
        this.mPaint.setShadowLayer((float)this.mShadowRadius, (float)this.mShadowX, (float)this.mShadowY, this.mShadowColor);
        this.mBubbleBorderPaint.setColor(this.mBubbleBorderColor);
        this.mBubbleBorderPaint.setStrokeWidth((float)this.mBubbleBorderSize);
        this.mBubbleBorderPaint.setStyle(Paint.Style.STROKE);
        this.mLeft = this.mShadowRadius + (this.mShadowX < 0 ? -this.mShadowX : 0) + (this.mLook == Look.LEFT ? this.mLookLength : 0);
        this.mTop = this.mShadowRadius + (this.mShadowY < 0 ? -this.mShadowY : 0) + (this.mLook == Look.TOP ? this.mLookLength : 0);
        this.mRight = this.mWidth - this.mShadowRadius + (this.mShadowX > 0 ? -this.mShadowX : 0) - (this.mLook == Look.RIGHT ? this.mLookLength : 0);
        this.mBottom = this.mHeight - this.mShadowRadius + (this.mShadowY > 0 ? -this.mShadowY : 0) - (this.mLook == Look.BOTTOM ? this.mLookLength : 0);
        this.mPaint.setColor(this.mBubbleColor);
        this.mPath.reset();
        int topOffset = this.mLookPosition;
        topOffset = topOffset + this.mLookLength > this.mBottom ? this.mBottom - this.mLookWidth : topOffset;
        topOffset = Math.max(topOffset, this.mShadowRadius);
        int leftOffset = this.mLookPosition;
        leftOffset = leftOffset + this.mLookLength > this.mRight ? this.mRight - this.mLookWidth : leftOffset;
        leftOffset = Math.max(leftOffset, this.mShadowRadius);
        switch (this.mLook) {
            case LEFT: {
                if (topOffset >= this.getLTR() + this.mArrowDownRightRadius) {
                    this.mPath.moveTo((float)this.mLeft, (float)(topOffset - this.mArrowDownRightRadius));
                    this.mPath.rCubicTo(0.0f, (float)this.mArrowDownRightRadius, (float)(-this.mLookLength), (float)this.mLookWidth / 2.0f - (float)this.mArrowTopRightRadius + (float)this.mArrowDownRightRadius, (float)(-this.mLookLength), (float)this.mLookWidth / 2.0f + (float)this.mArrowDownRightRadius);
                } else {
                    this.mPath.moveTo((float)(this.mLeft - this.mLookLength), (float)topOffset + (float)this.mLookWidth / 2.0f);
                }
                if (topOffset + this.mLookWidth < this.mBottom - this.getLDR() - this.mArrowDownLeftRadius) {
                    this.mPath.rCubicTo(0.0f, (float)this.mArrowTopLeftRadius, (float)this.mLookLength, (float)this.mLookWidth / 2.0f, (float)this.mLookLength, (float)this.mLookWidth / 2.0f + (float)this.mArrowDownLeftRadius);
                    this.mPath.lineTo((float)this.mLeft, (float)(this.mBottom - this.getLDR()));
                }
                this.mPath.quadTo((float)this.mLeft, (float)this.mBottom, (float)(this.mLeft + this.getLDR()), (float)this.mBottom);
                this.mPath.lineTo((float)(this.mRight - this.getRDR()), (float)this.mBottom);
                this.mPath.quadTo((float)this.mRight, (float)this.mBottom, (float)this.mRight, (float)(this.mBottom - this.getRDR()));
                this.mPath.lineTo((float)this.mRight, (float)(this.mTop + this.getRTR()));
                this.mPath.quadTo((float)this.mRight, (float)this.mTop, (float)(this.mRight - this.getRTR()), (float)this.mTop);
                this.mPath.lineTo((float)(this.mLeft + this.getLTR()), (float)this.mTop);
                if (topOffset >= this.getLTR() + this.mArrowDownRightRadius) {
                    this.mPath.quadTo((float)this.mLeft, (float)this.mTop, (float)this.mLeft, (float)(this.mTop + this.getLTR()));
                    break;
                }
                this.mPath.quadTo((float)this.mLeft, (float)this.mTop, (float)(this.mLeft - this.mLookLength), (float)topOffset + (float)this.mLookWidth / 2.0f);
                break;
            }
            case TOP: {
                if (leftOffset >= this.getLTR() + this.mArrowDownLeftRadius) {
                    this.mPath.moveTo((float)(leftOffset - this.mArrowDownLeftRadius), (float)this.mTop);
                    this.mPath.rCubicTo((float)this.mArrowDownLeftRadius, 0.0f, (float)this.mLookWidth / 2.0f - (float)this.mArrowTopLeftRadius + (float)this.mArrowDownLeftRadius, (float)(-this.mLookLength), (float)this.mLookWidth / 2.0f + (float)this.mArrowDownLeftRadius, (float)(-this.mLookLength));
                } else {
                    this.mPath.moveTo((float)leftOffset + (float)this.mLookWidth / 2.0f, (float)(this.mTop - this.mLookLength));
                }
                if (leftOffset + this.mLookWidth < this.mRight - this.getRTR() - this.mArrowDownRightRadius) {
                    this.mPath.rCubicTo((float)this.mArrowTopRightRadius, 0.0f, (float)this.mLookWidth / 2.0f, (float)this.mLookLength, (float)this.mLookWidth / 2.0f + (float)this.mArrowDownRightRadius, (float)this.mLookLength);
                    this.mPath.lineTo((float)(this.mRight - this.getRTR()), (float)this.mTop);
                }
                this.mPath.quadTo((float)this.mRight, (float)this.mTop, (float)this.mRight, (float)(this.mTop + this.getRTR()));
                this.mPath.lineTo((float)this.mRight, (float)(this.mBottom - this.getRDR()));
                this.mPath.quadTo((float)this.mRight, (float)this.mBottom, (float)(this.mRight - this.getRDR()), (float)this.mBottom);
                this.mPath.lineTo((float)(this.mLeft + this.getLDR()), (float)this.mBottom);
                this.mPath.quadTo((float)this.mLeft, (float)this.mBottom, (float)this.mLeft, (float)(this.mBottom - this.getLDR()));
                this.mPath.lineTo((float)this.mLeft, (float)(this.mTop + this.getLTR()));
                if (leftOffset >= this.getLTR() + this.mArrowDownLeftRadius) {
                    this.mPath.quadTo((float)this.mLeft, (float)this.mTop, (float)(this.mLeft + this.getLTR()), (float)this.mTop);
                    break;
                }
                this.mPath.quadTo((float)this.mLeft, (float)this.mTop, (float)leftOffset + (float)this.mLookWidth / 2.0f, (float)(this.mTop - this.mLookLength));
                break;
            }
            case RIGHT: {
                if (topOffset >= this.getRTR() + this.mArrowDownLeftRadius) {
                    this.mPath.moveTo((float)this.mRight, (float)(topOffset - this.mArrowDownLeftRadius));
                    this.mPath.rCubicTo(0.0f, (float)this.mArrowDownLeftRadius, (float)this.mLookLength, (float)this.mLookWidth / 2.0f - (float)this.mArrowTopLeftRadius + (float)this.mArrowDownLeftRadius, (float)this.mLookLength, (float)this.mLookWidth / 2.0f + (float)this.mArrowDownLeftRadius);
                } else {
                    this.mPath.moveTo((float)(this.mRight + this.mLookLength), (float)topOffset + (float)this.mLookWidth / 2.0f);
                }
                if (topOffset + this.mLookWidth < this.mBottom - this.getRDR() - this.mArrowDownRightRadius) {
                    this.mPath.rCubicTo(0.0f, (float)this.mArrowTopRightRadius, (float)(-this.mLookLength), (float)this.mLookWidth / 2.0f, (float)(-this.mLookLength), (float)this.mLookWidth / 2.0f + (float)this.mArrowDownRightRadius);
                    this.mPath.lineTo((float)this.mRight, (float)(this.mBottom - this.getRDR()));
                }
                this.mPath.quadTo((float)this.mRight, (float)this.mBottom, (float)(this.mRight - this.getRDR()), (float)this.mBottom);
                this.mPath.lineTo((float)(this.mLeft + this.getLDR()), (float)this.mBottom);
                this.mPath.quadTo((float)this.mLeft, (float)this.mBottom, (float)this.mLeft, (float)(this.mBottom - this.getLDR()));
                this.mPath.lineTo((float)this.mLeft, (float)(this.mTop + this.getLTR()));
                this.mPath.quadTo((float)this.mLeft, (float)this.mTop, (float)(this.mLeft + this.getLTR()), (float)this.mTop);
                this.mPath.lineTo((float)(this.mRight - this.getRTR()), (float)this.mTop);
                if (topOffset >= this.getRTR() + this.mArrowDownLeftRadius) {
                    this.mPath.quadTo((float)this.mRight, (float)this.mTop, (float)this.mRight, (float)(this.mTop + this.getRTR()));
                    break;
                }
                this.mPath.quadTo((float)this.mRight, (float)this.mTop, (float)(this.mRight + this.mLookLength), (float)topOffset + (float)this.mLookWidth / 2.0f);
                break;
            }
            case BOTTOM: {
                if (leftOffset >= this.getLDR() + this.mArrowDownRightRadius) {
                    this.mPath.moveTo((float)(leftOffset - this.mArrowDownRightRadius), (float)this.mBottom);
                    this.mPath.rCubicTo((float)this.mArrowDownRightRadius, 0.0f, (float)this.mLookWidth / 2.0f - (float)this.mArrowTopRightRadius + (float)this.mArrowDownRightRadius, (float)this.mLookLength, (float)this.mLookWidth / 2.0f + (float)this.mArrowDownRightRadius, (float)this.mLookLength);
                } else {
                    this.mPath.moveTo((float)leftOffset + (float)this.mLookWidth / 2.0f, (float)(this.mBottom + this.mLookLength));
                }
                if (leftOffset + this.mLookWidth < this.mRight - this.getRDR() - this.mArrowDownLeftRadius) {
                    this.mPath.rCubicTo((float)this.mArrowTopLeftRadius, 0.0f, (float)this.mLookWidth / 2.0f, (float)(-this.mLookLength), (float)this.mLookWidth / 2.0f + (float)this.mArrowDownLeftRadius, (float)(-this.mLookLength));
                    this.mPath.lineTo((float)(this.mRight - this.getRDR()), (float)this.mBottom);
                }
                this.mPath.quadTo((float)this.mRight, (float)this.mBottom, (float)this.mRight, (float)(this.mBottom - this.getRDR()));
                this.mPath.lineTo((float)this.mRight, (float)(this.mTop + this.getRTR()));
                this.mPath.quadTo((float)this.mRight, (float)this.mTop, (float)(this.mRight - this.getRTR()), (float)this.mTop);
                this.mPath.lineTo((float)(this.mLeft + this.getLTR()), (float)this.mTop);
                this.mPath.quadTo((float)this.mLeft, (float)this.mTop, (float)this.mLeft, (float)(this.mTop + this.getLTR()));
                this.mPath.lineTo((float)this.mLeft, (float)(this.mBottom - this.getLDR()));
                if (leftOffset >= this.getLDR() + this.mArrowDownRightRadius) {
                    this.mPath.quadTo((float)this.mLeft, (float)this.mBottom, (float)(this.mLeft + this.getLDR()), (float)this.mBottom);
                    break;
                }
                this.mPath.quadTo((float)this.mLeft, (float)this.mBottom, (float)leftOffset + (float)this.mLookWidth / 2.0f, (float)(this.mBottom + this.mLookLength));
            }
        }
        this.mPath.close();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawPath(this.mPath, this.mPaint);
        if (this.mBubbleImageBg != null) {
            this.mPath.computeBounds(this.mBubbleImageBgDstRectF, true);
            int layer = canvas.saveLayer(this.mBubbleImageBgDstRectF, null, 31);
            canvas.drawPath(this.mPath, this.mBubbleImageBgBeforePaint);
            float dstRatio = this.mBubbleImageBgDstRectF.width() / this.mBubbleImageBgDstRectF.height();
            float imgRatio = (float)this.mBubbleImageBg.getWidth() * 1.0f / (float)this.mBubbleImageBg.getHeight();
            if (dstRatio > imgRatio) {
                int top = (int)(((float)this.mBubbleImageBg.getHeight() - (float)this.mBubbleImageBg.getWidth() / dstRatio) / 2.0f);
                int bottom = top + (int)((float)this.mBubbleImageBg.getWidth() / dstRatio);
                this.mBubbleImageBgSrcRect.set(0, top, this.mBubbleImageBg.getWidth(), bottom);
            } else {
                int left = (int)(((float)this.mBubbleImageBg.getWidth() - (float)this.mBubbleImageBg.getHeight() * dstRatio) / 2.0f);
                int width = left + (int)((float)this.mBubbleImageBg.getHeight() * dstRatio);
                this.mBubbleImageBgSrcRect.set(left, 0, width, this.mBubbleImageBg.getHeight());
            }
            canvas.drawBitmap(this.mBubbleImageBg, this.mBubbleImageBgSrcRect, this.mBubbleImageBgDstRectF, this.mBubbleImageBgPaint);
            canvas.restoreToCount(layer);
        }
        if (this.mBubbleBorderSize != 0) {
            canvas.drawPath(this.mPath, this.mBubbleBorderPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            RectF r = new RectF();
            this.mPath.computeBounds(r, true);
            this.mRegion.setPath(this.mPath, new Region((int)r.left, (int)r.top, (int)r.right, (int)r.bottom));
            if (!this.mRegion.contains((int)event.getX(), (int)event.getY()) && this.mListener != null) {
                this.mListener.edge();
            }
        }
        return super.onTouchEvent(event);
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public Path getPath() {
        return this.mPath;
    }

    public Look getLook() {
        return this.mLook;
    }

    public int getLookPosition() {
        return this.mLookPosition;
    }

    public int getLookWidth() {
        return this.mLookWidth;
    }

    public int getLookLength() {
        return this.mLookLength;
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public int getShadowRadius() {
        return this.mShadowRadius;
    }

    public int getShadowX() {
        return this.mShadowX;
    }

    public int getShadowY() {
        return this.mShadowY;
    }

    public int getBubbleRadius() {
        return this.mBubbleRadius;
    }

    public int getBubbleColor() {
        return this.mBubbleColor;
    }

    public void setBubbleColor(int mBubbleColor) {
        this.mBubbleColor = mBubbleColor;
    }

    public void setLook(Look mLook) {
        this.mLook = mLook;
        this.initPadding();
    }

    public void setLookPosition(int mLookPosition) {
        this.mLookPosition = mLookPosition;
    }

    public void setLookWidth(int mLookWidth) {
        this.mLookWidth = mLookWidth;
    }

    public void setLookLength(int mLookLength) {
        this.mLookLength = mLookLength;
        this.initPadding();
    }

    public void setShadowColor(int mShadowColor) {
        this.mShadowColor = mShadowColor;
    }

    public void setShadowRadius(int mShadowRadius) {
        this.mShadowRadius = mShadowRadius;
    }

    public void setShadowX(int mShadowX) {
        this.mShadowX = mShadowX;
    }

    public void setShadowY(int mShadowY) {
        this.mShadowY = mShadowY;
    }

    public void setBubbleRadius(int mBubbleRadius) {
        this.mBubbleRadius = mBubbleRadius;
    }

    public int getLTR() {
        return this.mLTR == -1 ? this.mBubbleRadius : this.mLTR;
    }

    public void setLTR(int mLTR) {
        this.mLTR = mLTR;
    }

    public int getRTR() {
        return this.mRTR == -1 ? this.mBubbleRadius : this.mRTR;
    }

    public void setRTR(int mRTR) {
        this.mRTR = mRTR;
    }

    public int getRDR() {
        return this.mRDR == -1 ? this.mBubbleRadius : this.mRDR;
    }

    public void setRDR(int mRDR) {
        this.mRDR = mRDR;
    }

    public int getLDR() {
        return this.mLDR == -1 ? this.mBubbleRadius : this.mLDR;
    }

    public void setLDR(int mLDR) {
        this.mLDR = mLDR;
    }

    public int getArrowTopLeftRadius() {
        return this.mArrowTopLeftRadius;
    }

    public void setArrowTopLeftRadius(int mArrowTopLeftRadius) {
        this.mArrowTopLeftRadius = mArrowTopLeftRadius;
    }

    public int getArrowTopRightRadius() {
        return this.mArrowTopRightRadius;
    }

    public void setArrowTopRightRadius(int mArrowTopRightRadius) {
        this.mArrowTopRightRadius = mArrowTopRightRadius;
    }

    public int getArrowDownLeftRadius() {
        return this.mArrowDownLeftRadius;
    }

    public void setArrowDownLeftRadius(int mArrowDownLeftRadius) {
        this.mArrowDownLeftRadius = mArrowDownLeftRadius;
    }

    public int getArrowDownRightRadius() {
        return this.mArrowDownRightRadius;
    }

    public void setArrowDownRightRadius(int mArrowDownRightRadius) {
        this.mArrowDownRightRadius = mArrowDownRightRadius;
    }

    public void setBubblePadding(int bubblePadding) {
        this.mBubblePadding = bubblePadding;
    }

    public void setBubbleImageBg(Bitmap bitmap) {
        this.mBubbleImageBg = bitmap;
    }

    public void setBubbleImageBgRes(int res) {
        this.mBubbleImageBg = BitmapFactory.decodeResource((Resources)this.getResources(), (int)res);
    }

    public void setBubbleBorderSize(int bubbleBorderSize) {
        this.mBubbleBorderSize = bubbleBorderSize;
    }

    public void setBubbleBorderColor(int bubbleBorderColor) {
        this.mBubbleBorderColor = bubbleBorderColor;
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putInt("mLookPosition", this.mLookPosition);
        bundle.putInt("mLookWidth", this.mLookWidth);
        bundle.putInt("mLookLength", this.mLookLength);
        bundle.putInt("mShadowColor", this.mShadowColor);
        bundle.putInt("mShadowRadius", this.mShadowRadius);
        bundle.putInt("mShadowX", this.mShadowX);
        bundle.putInt("mShadowY", this.mShadowY);
        bundle.putInt("mBubbleRadius", this.mBubbleRadius);
        bundle.putInt("mLTR", this.mLTR);
        bundle.putInt("mRTR", this.mRTR);
        bundle.putInt("mRDR", this.mRDR);
        bundle.putInt("mLDR", this.mLDR);
        bundle.putInt("mBubblePadding", this.mBubblePadding);
        bundle.putInt("mArrowTopLeftRadius", this.mArrowTopLeftRadius);
        bundle.putInt("mArrowTopRightRadius", this.mArrowTopRightRadius);
        bundle.putInt("mArrowDownLeftRadius", this.mArrowDownLeftRadius);
        bundle.putInt("mArrowDownRightRadius", this.mArrowDownRightRadius);
        bundle.putInt("mWidth", this.mWidth);
        bundle.putInt("mHeight", this.mHeight);
        bundle.putInt("mLeft", this.mLeft);
        bundle.putInt("mTop", this.mTop);
        bundle.putInt("mRight", this.mRight);
        bundle.putInt("mBottom", this.mBottom);
        bundle.putInt("mBubbleBgRes", this.mBubbleBgRes);
        bundle.putInt("mBubbleBorderColor", this.mBubbleBorderColor);
        bundle.putInt("mBubbleBorderSize", this.mBubbleBorderSize);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mLookPosition = bundle.getInt("mLookPosition");
            this.mLookWidth = bundle.getInt("mLookWidth");
            this.mLookLength = bundle.getInt("mLookLength");
            this.mShadowColor = bundle.getInt("mShadowColor");
            this.mShadowRadius = bundle.getInt("mShadowRadius");
            this.mShadowX = bundle.getInt("mShadowX");
            this.mShadowY = bundle.getInt("mShadowY");
            this.mBubbleRadius = bundle.getInt("mBubbleRadius");
            this.mLTR = bundle.getInt("mLTR");
            this.mRTR = bundle.getInt("mRTR");
            this.mRDR = bundle.getInt("mRDR");
            this.mLDR = bundle.getInt("mLDR");
            this.mBubblePadding = bundle.getInt("mBubblePadding");
            this.mArrowTopLeftRadius = bundle.getInt("mArrowTopLeftRadius");
            this.mArrowTopRightRadius = bundle.getInt("mArrowTopRightRadius");
            this.mArrowDownLeftRadius = bundle.getInt("mArrowDownLeftRadius");
            this.mArrowDownRightRadius = bundle.getInt("mArrowDownRightRadius");
            this.mWidth = bundle.getInt("mWidth");
            this.mHeight = bundle.getInt("mHeight");
            this.mLeft = bundle.getInt("mLeft");
            this.mTop = bundle.getInt("mTop");
            this.mRight = bundle.getInt("mRight");
            this.mBottom = bundle.getInt("mBottom");
            this.mBubbleBgRes = bundle.getInt("mBubbleBgRes");
            if (this.mBubbleBgRes != -1) {
                this.mBubbleImageBg = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mBubbleBgRes);
            }
            this.mBubbleBorderSize = bundle.getInt("mBubbleBorderSize");
            this.mBubbleBorderColor = bundle.getInt("mBubbleBorderColor");
            super.onRestoreInstanceState(bundle.getParcelable("instanceState"));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void setOnClickEdgeListener(OnClickEdgeListener l) {
        this.mListener = l;
    }

    public static interface OnClickEdgeListener {
        public void edge();
    }

    public static enum Look {
        LEFT(1),
        TOP(2),
        RIGHT(3),
        BOTTOM(4);

        int value;

        private Look(int v) {
            this.value = v;
        }

        public static Look getType(int value) {
            Look type = BOTTOM;
            switch (value) {
                case 1: {
                    type = LEFT;
                    break;
                }
                case 2: {
                    type = TOP;
                    break;
                }
                case 3: {
                    type = RIGHT;
                    break;
                }
                case 4: {
                    type = BOTTOM;
                }
            }
            return type;
        }
    }
}

