/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.happybubble;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.xujiaji.happybubble.Auto;
import com.xujiaji.happybubble.BubbleLayout;
import com.xujiaji.happybubble.R;
import com.xujiaji.happybubble.Util;

public class BubbleDialog
extends Dialog {
    private BubbleLayout mBubbleLayout;
    private int mWidth;
    private int mHeight;
    private int mMargin;
    private View mAddView;
    private Rect mClickedRect;
    private int mOffsetX;
    private int mOffsetY;
    private int mStatusBarHeight;
    private int mRelativeOffset;
    private boolean mSoftShowUp;
    private Position mPosition = Position.TOP;
    private Position[] mPositions = new Position[4];
    private Auto mAuto;
    private boolean isThroughEvent = false;
    private boolean mCancelable;
    private int[] clickedViewLocation = new int[2];
    private Activity mActivity;
    private ViewTreeObserver.OnGlobalLayoutListener mOnGlobalLayoutListener;

    public BubbleDialog(Context context) {
        super(context, R.style.bubble_dialog);
        this.setCancelable(true);
        this.mActivity = (Activity)context;
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        final WindowManager.LayoutParams params = window.getAttributes();
        final int screenW = Util.getScreenWH(this.getContext())[0];
        this.mStatusBarHeight = Util.getStatusHeight(this.getContext());
        this.getWindow().getDecorView().setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (BubbleDialog.this.isThroughEvent) {
                    float x = params.x < 0 ? 0.0f : (float)params.x;
                    x = x + (float)v.getWidth() > (float)screenW ? (float)(screenW - v.getWidth()) : x;
                    float y = (float)params.y + event.getY();
                    event.setLocation(x += event.getX(), y);
                    BubbleDialog.this.mActivity.getWindow().getDecorView().dispatchTouchEvent(event);
                    return true;
                }
                return false;
            }
        });
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.isThroughEvent && keyCode == 4 && event.getRepeatCount() == 0) {
            this.dismiss();
            this.mActivity.onBackPressed();
            this.mActivity = null;
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mBubbleLayout == null) {
            this.mBubbleLayout = new BubbleLayout(this.getContext());
        }
        if (this.mAddView != null) {
            this.mBubbleLayout.addView(this.mAddView);
        }
        this.setContentView((View)this.mBubbleLayout);
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        if (this.mSoftShowUp) {
            window.setSoftInputMode(18);
        }
        window.setLayout(-2, -2);
        this.onAutoPosition();
        this.setLook();
        this.mBubbleLayout.measure(0, 0);
        this.dialogPosition();
        this.mOnGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){
            int lastWidth;
            int lastHeight;

            public void onGlobalLayout() {
                if (this.lastWidth == BubbleDialog.this.mBubbleLayout.getMeasuredWidth() && this.lastHeight == BubbleDialog.this.mBubbleLayout.getMeasuredHeight()) {
                    return;
                }
                BubbleDialog.this.dialogPosition();
                this.lastWidth = BubbleDialog.this.mBubbleLayout.getMeasuredWidth();
                this.lastHeight = BubbleDialog.this.mBubbleLayout.getMeasuredHeight();
            }
        };
        this.mBubbleLayout.getViewTreeObserver().addOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
        this.mBubbleLayout.setOnClickEdgeListener(new BubbleLayout.OnClickEdgeListener(){

            @Override
            public void edge() {
                if (BubbleDialog.this.mCancelable) {
                    BubbleDialog.this.dismiss();
                }
            }
        });
    }

    private boolean havePositions() {
        int num = 0;
        for (Position p : this.mPositions) {
            if (p == null) continue;
            ++num;
        }
        return num > 0;
    }

    private void onAutoPosition() {
        if (this.mClickedRect == null || this.mAuto == null && !this.havePositions()) {
            return;
        }
        int[] spaces = new int[]{this.clickedViewLocation[0], this.clickedViewLocation[1], Util.getScreenWH(this.getContext())[0] - this.clickedViewLocation[0] - this.mClickedRect.width(), Util.getScreenWH(this.getContext())[1] - this.clickedViewLocation[1] - this.mClickedRect.height()};
        if (this.havePositions()) {
            this.mAddView.measure(0, 0);
            block11: for (Position p : this.mPositions) {
                if (p == null) {
                    return;
                }
                switch (p) {
                    case LEFT: {
                        if (spaces[0] <= this.mAddView.getMeasuredWidth()) continue block11;
                        this.mPosition = Position.LEFT;
                        return;
                    }
                    case TOP: {
                        if (spaces[1] <= this.mAddView.getMeasuredHeight()) continue block11;
                        this.mPosition = Position.TOP;
                        return;
                    }
                    case RIGHT: {
                        if (spaces[2] <= this.mAddView.getMeasuredWidth()) continue block11;
                        this.mPosition = Position.RIGHT;
                        return;
                    }
                    case BOTTOM: {
                        if (spaces[3] <= this.mAddView.getMeasuredHeight()) continue block11;
                        this.mPosition = Position.BOTTOM;
                        return;
                    }
                }
            }
            this.mPosition = this.mPositions[0];
            return;
        }
        if (this.mAuto != null) {
            switch (this.mAuto) {
                case AROUND: {
                    break;
                }
                case UP_AND_DOWN: {
                    this.mPosition = spaces[1] > spaces[3] ? Position.TOP : Position.BOTTOM;
                    return;
                }
                case LEFT_AND_RIGHT: {
                    this.mPosition = spaces[0] > spaces[2] ? Position.LEFT : Position.RIGHT;
                    return;
                }
            }
        }
        int max = 0;
        for (int value : spaces) {
            if (value <= max) continue;
            max = value;
        }
        if (max == spaces[0]) {
            this.mPosition = Position.LEFT;
        } else if (max == spaces[1]) {
            this.mPosition = Position.TOP;
        } else if (max == spaces[2]) {
            this.mPosition = Position.RIGHT;
        } else if (max == spaces[3]) {
            this.mPosition = Position.BOTTOM;
        }
    }

    private void setLook() {
        switch (this.mPosition) {
            case LEFT: {
                this.mBubbleLayout.setLook(BubbleLayout.Look.RIGHT);
                break;
            }
            case TOP: {
                this.mBubbleLayout.setLook(BubbleLayout.Look.BOTTOM);
                break;
            }
            case RIGHT: {
                this.mBubbleLayout.setLook(BubbleLayout.Look.LEFT);
                break;
            }
            case BOTTOM: {
                this.mBubbleLayout.setLook(BubbleLayout.Look.TOP);
            }
        }
        this.mBubbleLayout.initPadding();
    }

    public void dismiss() {
        if (this.mSoftShowUp) {
            Util.hide(this);
        }
        if (this.mBubbleLayout != null && Build.VERSION.SDK_INT >= 16) {
            this.mBubbleLayout.getViewTreeObserver().removeOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
        }
        super.dismiss();
    }

    private void dialogPosition() {
        if (this.mClickedRect == null) {
            return;
        }
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        window.setGravity(51);
        WindowManager.LayoutParams params = window.getAttributes();
        FrameLayout.LayoutParams bubbleParams = null;
        if (this.mWidth != 0) {
            params.width = this.mWidth;
        }
        if (this.mHeight != 0) {
            params.height = this.mHeight;
        }
        if (this.mMargin != 0) {
            bubbleParams = (FrameLayout.LayoutParams)this.mBubbleLayout.getLayoutParams();
            if (this.mPosition == Position.TOP || this.mPosition == Position.BOTTOM) {
                bubbleParams.leftMargin = this.mMargin;
                bubbleParams.rightMargin = this.mMargin;
            } else {
                bubbleParams.topMargin = this.mMargin;
                bubbleParams.bottomMargin = this.mMargin;
            }
            this.mBubbleLayout.setLayoutParams((ViewGroup.LayoutParams)bubbleParams);
        }
        switch (this.mPosition) {
            case TOP: 
            case BOTTOM: {
                params.x = this.clickedViewLocation[0] + this.mClickedRect.width() / 2 - this.mBubbleLayout.getMeasuredWidth() / 2 + this.mOffsetX;
                if (this.mMargin != 0 && this.mWidth == -1) {
                    this.mBubbleLayout.setLookPosition(this.clickedViewLocation[0] - this.mMargin + this.mClickedRect.width() / 2 - this.mBubbleLayout.getLookWidth() / 2);
                } else if (params.x <= 0) {
                    this.mBubbleLayout.setLookPosition(this.clickedViewLocation[0] + this.mClickedRect.width() / 2 - this.mBubbleLayout.getLookWidth() / 2);
                } else if (params.x + this.mBubbleLayout.getMeasuredWidth() > Util.getScreenWH(this.getContext())[0]) {
                    this.mBubbleLayout.setLookPosition(this.clickedViewLocation[0] - (Util.getScreenWH(this.getContext())[0] - this.mBubbleLayout.getMeasuredWidth()) + this.mClickedRect.width() / 2 - this.mBubbleLayout.getLookWidth() / 2);
                } else {
                    this.mBubbleLayout.setLookPosition(this.clickedViewLocation[0] - params.x + this.mClickedRect.width() / 2 - this.mBubbleLayout.getLookWidth() / 2);
                }
                if (this.mPosition == Position.BOTTOM) {
                    if (this.mRelativeOffset != 0) {
                        this.mOffsetY = this.mRelativeOffset;
                    }
                    params.y = this.clickedViewLocation[1] + this.mClickedRect.height() + this.mOffsetY - this.mStatusBarHeight;
                    break;
                }
                if (this.mRelativeOffset != 0) {
                    this.mOffsetY = -this.mRelativeOffset;
                }
                params.y = this.clickedViewLocation[1] - this.mBubbleLayout.getMeasuredHeight() + this.mOffsetY - this.mStatusBarHeight;
                break;
            }
            case LEFT: 
            case RIGHT: {
                params.y = this.clickedViewLocation[1] + this.mOffsetY + this.mClickedRect.height() / 2 - this.mBubbleLayout.getMeasuredHeight() / 2 - this.mStatusBarHeight;
                if (this.mMargin != 0 && this.mHeight == -1) {
                    this.mBubbleLayout.setLookPosition(this.clickedViewLocation[1] - this.mMargin + this.mClickedRect.height() / 2 - this.mBubbleLayout.getLookWidth() / 2 - this.mStatusBarHeight);
                } else if (params.y <= 0) {
                    this.mBubbleLayout.setLookPosition(this.clickedViewLocation[1] + this.mClickedRect.height() / 2 - this.mBubbleLayout.getLookWidth() / 2 - this.mStatusBarHeight);
                } else if (params.y + this.mBubbleLayout.getMeasuredHeight() > Util.getScreenWH(this.getContext())[1]) {
                    this.mBubbleLayout.setLookPosition(this.clickedViewLocation[1] - (Util.getScreenWH(this.getContext())[1] - this.mBubbleLayout.getMeasuredHeight()) + this.mClickedRect.height() / 2 - this.mBubbleLayout.getLookWidth() / 2);
                } else {
                    this.mBubbleLayout.setLookPosition(this.clickedViewLocation[1] - params.y + this.mClickedRect.height() / 2 - this.mBubbleLayout.getLookWidth() / 2 - this.mStatusBarHeight);
                }
                if (this.mPosition == Position.RIGHT) {
                    if (this.mRelativeOffset != 0) {
                        this.mOffsetX = this.mRelativeOffset;
                    }
                    params.x = this.clickedViewLocation[0] + this.mClickedRect.width() + this.mOffsetX;
                    break;
                }
                if (this.mRelativeOffset != 0) {
                    this.mOffsetX = -this.mRelativeOffset;
                }
                params.x = this.clickedViewLocation[0] - this.mBubbleLayout.getMeasuredWidth() + this.mOffsetX;
            }
        }
        this.mBubbleLayout.invalidate();
        window.setAttributes(params);
    }

    public boolean onTouchEvent(MotionEvent event) {
        Window window = this.getWindow();
        if (window == null) {
            return false;
        }
        View decorView = window.getDecorView();
        if (this.mCancelable && this.isShowing() && this.shouldCloseOnTouch(event, decorView)) {
            this.cancel();
            return true;
        }
        return false;
    }

    public boolean shouldCloseOnTouch(MotionEvent event, View decorView) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        return x <= 0 || y <= 0 || x > decorView.getWidth() || y > decorView.getHeight();
    }

    public void setCancelable(boolean flag) {
        super.setCancelable(flag);
        this.mCancelable = flag;
    }

    public <T extends BubbleDialog> T setLayout(int width, int height, int margin) {
        this.mWidth = width;
        this.mHeight = height;
        this.mMargin = margin;
        return (T)((Object)this);
    }

    @Deprecated
    public <T extends BubbleDialog> T calBar(boolean cal) {
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setClickedView(View view) {
        this.mClickedRect = new Rect(0, 0, view.getWidth(), view.getHeight());
        view.getLocationOnScreen(this.clickedViewLocation);
        this.handleGlobalLayoutListener();
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setClickedPosition(int x, int y) {
        this.mClickedRect = new Rect(0, 0, 1, 1);
        this.clickedViewLocation[0] = x;
        this.clickedViewLocation[1] = y;
        this.handleGlobalLayoutListener();
        return (T)((Object)this);
    }

    private void handleGlobalLayoutListener() {
        this.onAutoPosition();
        if (this.mOnGlobalLayoutListener != null) {
            this.setLook();
            this.dialogPosition();
        }
    }

    public <T extends BubbleDialog> T softShowUp() {
        this.mSoftShowUp = true;
        return (T)((Object)this);
    }

    @Deprecated
    public <T extends BubbleDialog> T addContentView(View view) {
        this.mAddView = view;
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setBubbleContentView(View view) {
        this.mAddView = view;
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setPosition(Position ... positions) {
        if (positions.length == 1 && positions[0] != null) {
            this.mPosition = positions[0];
            return (T)((Object)this);
        }
        this.mPositions = positions;
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T autoPosition(Auto auto) {
        this.mAuto = auto;
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setThroughEvent(boolean isThroughEvent, boolean cancelable) {
        this.isThroughEvent = isThroughEvent;
        if (isThroughEvent) {
            this.setCancelable(false);
        } else {
            this.setCancelable(cancelable);
        }
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setOffsetX(int offsetX) {
        this.mOffsetX = Util.dpToPx(this.getContext(), offsetX);
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setOffsetY(int offsetY) {
        this.mOffsetY = Util.dpToPx(this.getContext(), offsetY);
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setRelativeOffset(int relativeOffset) {
        this.mRelativeOffset = Util.dpToPx(this.getContext(), relativeOffset);
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setBubbleLayout(BubbleLayout bl) {
        this.mBubbleLayout = bl;
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setTransParentBackground() {
        Window window = this.getWindow();
        if (window == null) {
            return (T)((Object)this);
        }
        this.getWindow().clearFlags(2);
        return (T)((Object)this);
    }

    public static enum Position {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM;

    }
}

