package com.xujiaji.dmlib2;

import android.graphics.Canvas;
import android.view.Surface;
import android.view.SurfaceHolder;

public class SurfaceProxy
{
    private Surface mSurface;
    private SurfaceHolder mSurfaceHolder;

    public SurfaceProxy(Surface surface)
    {
        this.mSurface = surface;
    }

    public SurfaceProxy(SurfaceHolder surfaceHolder)
    {
        this.mSurfaceHolder = surfaceHolder;
    }

    public Canvas lockCanvas()
    {
        if (mSurfaceHolder != null)
        {
            return mSurfaceHolder.lockCanvas();
        } else
        {
            return mSurface.lockCanvas(null);
        }
    }

    public void unlockCanvasAndPost(Canvas canvas)
    {
        if (mSurfaceHolder != null)
        {
            mSurfaceHolder.unlockCanvasAndPost(canvas);
        } else
        {
            mSurface.unlockCanvasAndPost(canvas);
        }
    }
}
