/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.dmlib2.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.xujiaji.dmlib2.DM;
import com.xujiaji.dmlib2.Direction;
import com.xujiaji.dmlib2.R;
import com.xujiaji.dmlib2.widget.Controller;

public class DMSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback,
DM {
    private SurfaceHolder mSurfaceHolder;
    private Controller mController = new Controller();
    private Direction mDirection;
    private int mDuration = 3000;

    public DMSurfaceView(Context context) {
        this(context, null);
    }

    public DMSurfaceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DMSurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mSurfaceHolder = this.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.setZOrderOnTop(true);
        this.mSurfaceHolder.setFormat(-2);
        this.initAttr(context.obtainStyledAttributes(attrs, R.styleable.DMSurfaceView, defStyleAttr, 0));
    }

    private void initAttr(TypedArray a) {
        this.mDirection = Direction.getType(a.getInt(R.styleable.DMSurfaceView_direction, Direction.RIGHT_LEFT.value));
        this.mDuration = a.getInt(R.styleable.DMSurfaceView_duration, 3000);
        a.recycle();
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mController.init(width, height, this.mDuration, this.mDirection, this.mSurfaceHolder);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mController.destroy();
    }

    @Override
    public Controller getController() {
        return this.mController;
    }
}

