/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.dmlib2.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.xujiaji.dmlib2.Direction;
import com.xujiaji.dmlib2.LogUtil;
import com.xujiaji.dmlib2.Util;
import com.xujiaji.dmlib2.callback.OnDMAddListener;
import com.xujiaji.dmlib2.entity.BaseDmEntity;
import java.util.PriorityQueue;
import java.util.Random;

public class Controller {
    private Direction mDirection = Direction.RIGHT_LEFT;
    private int mDuration = 3000;
    private PriorityQueue<BaseDmEntity> mQueue = new PriorityQueue();
    private SurfaceHolder mSurfaceHolder;
    private boolean isActive;
    private Bitmap mOneBitmap;
    private Bitmap mTwoBitmap;
    private Bitmap mDrawDMBitmap;
    private Canvas mOneCanvas;
    private Canvas mTwoCanvas;
    private Canvas mDrawDMCanvas;
    private int mUseWidth;
    private int mUseHeight;
    private int mWidth;
    private int mHeight;
    private ValueAnimator mValueAnim;
    private int mOneLeft;
    private int mTwoLeft;
    private int mOneTop;
    private int mTwoTop;
    private final Random random = new Random();
    private OnDMAddListener mOnDMAddListener;

    void init(int width, int height, int duration, Direction direction, SurfaceHolder surfaceHolder) {
        this.mSurfaceHolder = surfaceHolder;
        this.mDirection = direction;
        this.isActive = true;
        this.mUseWidth = 0;
        this.mUseHeight = 0;
        this.mDuration = duration;
        this.mOneBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mTwoBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mDrawDMBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mOneCanvas = new Canvas(this.mOneBitmap);
        this.mTwoCanvas = new Canvas(this.mTwoBitmap);
        this.mDrawDMCanvas = new Canvas(this.mDrawDMBitmap);
        this.mWidth = width;
        this.mHeight = height;
        switch (this.mDirection) {
            case DOWN_UP: {
                this.mTwoTop = 0;
                this.mOneTop = this.mHeight;
                this.mValueAnim = ValueAnimator.ofInt((int[])new int[]{0, this.mHeight}).setDuration((long)this.mDuration);
                break;
            }
            case UP_DOWN: {
                this.mTwoTop = 0;
                this.mOneTop = -this.mHeight;
                this.mValueAnim = ValueAnimator.ofInt((int[])new int[]{0, this.mHeight}).setDuration((long)this.mDuration);
                break;
            }
            case LEFT_RIGHT: {
                this.mTwoLeft = 0;
                this.mOneLeft = -this.mWidth;
                this.mValueAnim = ValueAnimator.ofInt((int[])new int[]{0, this.mWidth}).setDuration((long)this.mDuration);
                break;
            }
            case RIGHT_LEFT: {
                this.mTwoLeft = 0;
                this.mOneLeft = this.mWidth;
                this.mValueAnim = ValueAnimator.ofInt((int[])new int[]{0, this.mWidth}).setDuration((long)this.mDuration);
                break;
            }
        }
        this.mValueAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mValueAnim.setRepeatCount(-1);
        this.mValueAnim.setRepeatMode(1);
        this.mValueAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                Controller.this.startRun(value);
            }
        });
        this.mValueAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationRepeat(Animator animation) {
                LogUtil.i("onAnimationRepeat");
                Controller.this.animRepeat();
            }
        });
        this.mValueAnim.start();
        this.addFromQueue(this.mQueue);
    }

    private void animRepeat() {
        this.mUseWidth = 0;
        this.mUseHeight = 0;
        switch (this.mDirection) {
            case DOWN_UP: {
                if (this.mTwoTop == 0) {
                    this.mTwoTop = this.mHeight;
                    this.mOneTop = 0;
                    this.exchangeTwoHandle();
                    break;
                }
                this.mTwoTop = 0;
                this.mOneTop = this.mHeight;
                this.exchangeOneHandle();
                break;
            }
            case UP_DOWN: {
                if (this.mTwoTop == 0) {
                    this.mTwoTop = -this.mHeight;
                    this.mOneTop = 0;
                    this.exchangeTwoHandle();
                    break;
                }
                this.mTwoTop = 0;
                this.mOneTop = -this.mHeight;
                this.exchangeOneHandle();
                break;
            }
            case LEFT_RIGHT: {
                if (this.mTwoLeft == 0) {
                    this.mTwoLeft = -this.mWidth;
                    this.mOneLeft = 0;
                    this.exchangeTwoHandle();
                    break;
                }
                this.mTwoLeft = 0;
                this.mOneLeft = -this.mWidth;
                this.exchangeOneHandle();
                break;
            }
            case RIGHT_LEFT: {
                if (this.mTwoLeft == 0) {
                    this.mTwoLeft = this.mWidth;
                    this.mOneLeft = 0;
                    this.exchangeTwoHandle();
                    break;
                }
                this.mTwoLeft = 0;
                this.mOneLeft = this.mWidth;
                this.exchangeOneHandle();
            }
        }
        this.mDrawDMCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.addFromQueue(this.mQueue);
    }

    private void exchangeOneHandle() {
        Bitmap b = this.mOneBitmap;
        Canvas c = this.mOneCanvas;
        this.mOneBitmap = this.mDrawDMBitmap;
        this.mOneCanvas = this.mDrawDMCanvas;
        this.mDrawDMBitmap = b;
        this.mDrawDMCanvas = c;
    }

    private void exchangeTwoHandle() {
        Bitmap b = this.mTwoBitmap;
        Canvas c = this.mTwoCanvas;
        this.mTwoBitmap = this.mDrawDMBitmap;
        this.mTwoCanvas = this.mDrawDMCanvas;
        this.mDrawDMBitmap = b;
        this.mDrawDMCanvas = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startRun(int value) {
        Canvas canvas = null;
        try {
            canvas = this.mSurfaceHolder.lockCanvas();
            if (canvas == null) {
                this.mValueAnim.cancel();
                return;
            }
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            switch (this.mDirection) {
                case RIGHT_LEFT: {
                    canvas.drawBitmap(this.mOneBitmap, (float)(this.mOneLeft - value), 0.0f, null);
                    canvas.drawBitmap(this.mTwoBitmap, (float)(this.mTwoLeft - value), 0.0f, null);
                    return;
                }
                case LEFT_RIGHT: {
                    canvas.drawBitmap(this.mOneBitmap, (float)(this.mOneLeft + value), 0.0f, null);
                    canvas.drawBitmap(this.mTwoBitmap, (float)(this.mTwoLeft + value), 0.0f, null);
                    return;
                }
                case UP_DOWN: {
                    canvas.drawBitmap(this.mOneBitmap, 0.0f, (float)(this.mOneTop + value), null);
                    canvas.drawBitmap(this.mTwoBitmap, 0.0f, (float)(this.mTwoTop + value), null);
                    return;
                }
                case DOWN_UP: {
                    canvas.drawBitmap(this.mOneBitmap, 0.0f, (float)(this.mOneTop - value), null);
                    canvas.drawBitmap(this.mTwoBitmap, 0.0f, (float)(this.mTwoTop - value), null);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            LogUtil.i(e.getMessage());
            return;
        }
        finally {
            if (canvas != null) {
                this.mSurfaceHolder.unlockCanvasAndPost(canvas);
            }
        }
    }

    private void drawUpDown(BaseDmEntity entity) {
        int left;
        int top;
        Bitmap bitmap = entity.getBitmap();
        if (this.mUseWidth == 0 && this.mUseHeight == 0) {
            top = this.mHeight - bitmap.getHeight() - this.random.nextInt(100);
            left = 0;
        } else if (this.mHeight - this.mUseHeight > bitmap.getHeight()) {
            top = this.mHeight - this.mUseHeight - bitmap.getHeight();
            left = this.mUseWidth - bitmap.getWidth();
        } else if (this.mHeight - this.mUseHeight < bitmap.getHeight() && this.mWidth - this.mUseWidth > bitmap.getWidth()) {
            top = this.mHeight - bitmap.getHeight() - this.random.nextInt(100);
            left = this.mUseWidth;
        } else {
            this.mQueue.offer(entity);
            return;
        }
        this.mUseWidth = left + bitmap.getWidth();
        this.mUseHeight = this.mHeight - top + this.random.nextInt(100);
        this.mDrawDMCanvas.drawBitmap(bitmap, (float)left, (float)top, null);
        this.dmAdded(entity);
    }

    private void drawDownUp(BaseDmEntity entity) {
        int left;
        int top;
        Bitmap bitmap = entity.getBitmap();
        if (this.mUseWidth == 0 && this.mUseHeight == 0) {
            top = this.random.nextInt(100);
            left = 0;
        } else if (this.mHeight - this.mUseHeight > bitmap.getHeight()) {
            left = this.mUseWidth - bitmap.getWidth();
            top = this.mUseHeight;
        } else if (this.mHeight - this.mUseHeight < bitmap.getHeight() && this.mWidth - this.mUseWidth > bitmap.getWidth()) {
            left = this.mUseWidth;
            top = this.random.nextInt(100);
        } else {
            this.mQueue.offer(entity);
            return;
        }
        this.mUseWidth = left + bitmap.getWidth();
        this.mUseHeight = top + bitmap.getHeight() + this.random.nextInt(100);
        this.mDrawDMCanvas.drawBitmap(bitmap, (float)left, (float)top, null);
        this.dmAdded(entity);
    }

    private void drawRightLeft(BaseDmEntity entity) {
        int top;
        int left;
        Bitmap bitmap = entity.getBitmap();
        if (this.mUseWidth == 0 && this.mUseHeight == 0) {
            left = this.random.nextInt(100);
            top = 0;
        } else if (this.mWidth - this.mUseWidth > bitmap.getWidth()) {
            left = this.mUseWidth;
            top = this.mUseHeight - bitmap.getHeight();
        } else if (this.mWidth - this.mUseWidth < bitmap.getWidth() && this.mHeight - this.mUseHeight > bitmap.getHeight()) {
            left = this.random.nextInt(100);
            top = this.mUseHeight;
        } else {
            this.mQueue.offer(entity);
            return;
        }
        this.mUseWidth = left + bitmap.getWidth() + this.random.nextInt(100);
        this.mUseHeight = top + bitmap.getHeight();
        this.mDrawDMCanvas.drawBitmap(bitmap, (float)left, (float)top, null);
        this.dmAdded(entity);
    }

    private void drawLeftRight(BaseDmEntity entity) {
        int top;
        int left;
        Bitmap bitmap = entity.getBitmap();
        if (this.mUseWidth == 0 && this.mUseHeight == 0) {
            left = this.mWidth - bitmap.getWidth() - this.random.nextInt(100);
            top = 0;
        } else if (this.mWidth - this.mUseWidth > bitmap.getWidth()) {
            left = this.mWidth - this.mUseWidth - bitmap.getWidth();
            top = this.mUseHeight - bitmap.getHeight();
        } else if (this.mWidth - this.mUseWidth < bitmap.getWidth() && this.mHeight - this.mUseHeight > bitmap.getHeight()) {
            left = this.mWidth - bitmap.getWidth() - this.random.nextInt(100);
            top = this.mUseHeight;
        } else {
            this.mQueue.offer(entity);
            return;
        }
        this.mUseWidth = this.mWidth - left + this.random.nextInt(100);
        this.mUseHeight = top + bitmap.getHeight();
        this.mDrawDMCanvas.drawBitmap(bitmap, (float)left, (float)top, null);
        this.dmAdded(entity);
    }

    private void addFromQueue(PriorityQueue<BaseDmEntity> queue) {
        if (!this.isActive) {
            return;
        }
        LogUtil.i("addFromQueue method");
        if (queue.peek() != null) {
            BaseDmEntity entity = (BaseDmEntity)queue.remove();
            if (this.mWidth - this.mUseWidth > entity.getBitmap().getWidth() || this.mHeight - this.mUseHeight > entity.getBitmap().getHeight()) {
                this.add(entity);
            } else {
                return;
            }
        }
        if (queue.peek() != null) {
            this.addFromQueue(queue);
        }
    }

    public synchronized void add(View templateView) {
        if (!this.isActive) {
            return;
        }
        BaseDmEntity entity = new BaseDmEntity(templateView);
        this.add(entity);
    }

    public synchronized void add(BaseDmEntity entity) {
        if (!this.isActive) {
            return;
        }
        switch (this.mDirection) {
            case RIGHT_LEFT: {
                this.drawRightLeft(entity);
                break;
            }
            case LEFT_RIGHT: {
                this.drawLeftRight(entity);
                break;
            }
            case UP_DOWN: {
                this.drawUpDown(entity);
                break;
            }
            case DOWN_UP: {
                this.drawDownUp(entity);
                break;
            }
        }
    }

    private void dmAdded(BaseDmEntity dmEntity) {
        if (this.mOnDMAddListener == null) {
            return;
        }
        this.mOnDMAddListener.added(dmEntity);
    }

    public void setOnDMAddListener(OnDMAddListener l) {
        this.mOnDMAddListener = l;
    }

    void destroy() {
        this.isActive = false;
        this.mValueAnim.cancel();
        Util.restoreBitmap(this.mOneBitmap);
        Util.restoreBitmap(this.mTwoBitmap);
        Util.restoreBitmap(this.mDrawDMBitmap);
    }
}

