package com.ark.net.urlconn;

import android.content.Context;
import com.yanzhenjie.kalle.exception.*;
import com.yanzhenjie.kalle.simple.Callback;
import com.yanzhenjie.kalle.simple.SimpleResponse;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class StringCallback<S> extends Callback<S, String> {

    private Context mContext;

    public StringCallback(Context context) {
        this.mContext = context;
    }

    @Override
    public Type getSucceed() {
        Type superClass = getClass().getGenericSuperclass();
        return ((ParameterizedType) superClass).getActualTypeArguments()[0];
    }

    @Override
    public Type getFailed() {
        return String.class;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onException(Exception e) {
        String message;
        if (e instanceof NetworkError) {
            message = mContext.getString(R.string.http_exception_network);
        } else if (e instanceof URLError) {
            message = mContext.getString(R.string.http_exception_url);
        } else if (e instanceof HostError) {
            message = mContext.getString(R.string.http_exception_host);
        } else if (e instanceof ConnectTimeoutError) {
            message = mContext.getString(R.string.http_exception_connect_timeout);
        } else if (e instanceof WriteException) {
            message = mContext.getString(R.string.http_exception_write);
        } else if (e instanceof ReadTimeoutError) {
            message = mContext.getString(R.string.http_exception_read_timeout);
        } else {
            message = mContext.getString(R.string.http_exception_unknow_error);
        }

        onResponse(SimpleResponse.<S, String>newBuilder()
                .failed(message)
                .build());
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onEnd() {
    }
}
