/*
 * Decompiled with CFR 0.152.
 */
package com.ark.uikit.loading;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.animation.LinearInterpolator;

public abstract class LoadingRenderer {
    private static final long ANIMATION_DURATION = 1333L;
    protected final Rect mBounds = new Rect();
    protected long mDuration;
    protected float mWidth;
    protected float mHeight;
    private Drawable.Callback mCallback;
    private final ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            LoadingRenderer.this.computeRender(((Float)animation.getAnimatedValue()).floatValue());
            LoadingRenderer.this.invalidateSelf();
        }
    };
    private ValueAnimator mRenderAnimator;

    public LoadingRenderer(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mWidth = this.mHeight = (float)(((double)displayMetrics.density + 0.5) * 56.0);
        this.mDuration = 1333L;
        this.setupAnimators();
    }

    @Deprecated
    protected void draw(Canvas canvas, Rect bounds) {
    }

    protected void draw(Canvas canvas) {
        this.draw(canvas, this.mBounds);
    }

    protected abstract void computeRender(float var1);

    protected abstract void setAlpha(int var1);

    protected abstract void setColorFilter(ColorFilter var1);

    protected abstract void reset();

    protected void addRenderListener(Animator.AnimatorListener animatorListener) {
        this.mRenderAnimator.addListener(animatorListener);
    }

    void start() {
        this.reset();
        this.mRenderAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mRenderAnimator.setRepeatCount(-1);
        this.mRenderAnimator.setDuration(this.mDuration);
        this.mRenderAnimator.start();
    }

    void stop() {
        this.mRenderAnimator.removeUpdateListener(this.mAnimatorUpdateListener);
        this.mRenderAnimator.setRepeatCount(0);
        this.mRenderAnimator.setDuration(0L);
        this.mRenderAnimator.end();
    }

    boolean isRunning() {
        return this.mRenderAnimator.isRunning();
    }

    void setCallback(Drawable.Callback callback) {
        this.mCallback = callback;
    }

    void setBounds(Rect bounds) {
        this.mBounds.set(bounds);
    }

    private void setupAnimators() {
        this.mRenderAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mRenderAnimator.setRepeatCount(-1);
        this.mRenderAnimator.setRepeatMode(1);
        this.mRenderAnimator.setDuration(this.mDuration);
        this.mRenderAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mRenderAnimator.addUpdateListener(this.mAnimatorUpdateListener);
    }

    private void invalidateSelf() {
        this.mCallback.invalidateDrawable(null);
    }
}

