/*
 * Decompiled with CFR 0.152.
 */
package com.ark.uikit.loading;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.util.DisplayMetrics;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.ark.uikit.loading.LoadingRenderer;

public class LevelLoadingRenderer
extends LoadingRenderer {
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final Interpolator MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private static final int NUM_POINTS = 5;
    private static final int DEGREE_360 = 360;
    private static final float MAX_SWIPE_DEGREES = 288.0f;
    private static final float FULL_GROUP_ROTATION = 1080.0f;
    private static final float[] LEVEL_SWEEP_ANGLE_OFFSETS = new float[]{1.0f, 0.875f, 0.625f};
    private static final float START_TRIM_DURATION_OFFSET = 0.5f;
    private static final float END_TRIM_DURATION_OFFSET = 1.0f;
    private static final float DEFAULT_CENTER_RADIUS = 12.5f;
    private static final float DEFAULT_STROKE_WIDTH = 2.5f;
    private static final int[] DEFAULT_LEVEL_COLORS = new int[]{Color.parseColor((String)"#55ffffff"), Color.parseColor((String)"#b1ffffff"), Color.parseColor((String)"#ffffffff")};
    private final Paint mPaint = new Paint();
    private final RectF mTempBounds = new RectF();
    private int[] mLevelColors;
    private float[] mLevelSwipeDegrees;
    private float mStrokeInset;
    private float mRotationCount;
    private float mGroupRotation;
    private float mEndDegrees;
    private float mStartDegrees;
    private float mOriginEndDegrees;
    private float mOriginStartDegrees;
    private final Animator.AnimatorListener mAnimatorListener = new AnimatorListenerAdapter(){

        public void onAnimationRepeat(Animator animator) {
            super.onAnimationRepeat(animator);
            LevelLoadingRenderer.this.storeOriginals();
            LevelLoadingRenderer.this.mStartDegrees = LevelLoadingRenderer.this.mEndDegrees;
            LevelLoadingRenderer.this.mRotationCount = (LevelLoadingRenderer.this.mRotationCount + 1.0f) % 5.0f;
        }

        public void onAnimationStart(Animator animation) {
            super.onAnimationStart(animation);
            LevelLoadingRenderer.this.mRotationCount = 0.0f;
        }
    };
    private float mStrokeWidth;
    private float mCenterRadius;

    public LevelLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
        this.addRenderListener(this.mAnimatorListener);
    }

    private float dip2px(Context context, float dp) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (float)(((double)displayMetrics.density + 0.5) * (double)dp);
    }

    private void init(Context context) {
        this.mStrokeWidth = this.dip2px(context, 2.5f);
        this.mCenterRadius = this.dip2px(context, 12.5f);
        this.mLevelSwipeDegrees = new float[3];
        this.mLevelColors = DEFAULT_LEVEL_COLORS;
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.initStrokeInset((int)this.mWidth, (int)this.mHeight);
    }

    public void setCircleColors(int r1, int r2, int r3) {
        this.mLevelColors = new int[]{r1, r2, r3};
    }

    @Override
    protected void draw(Canvas canvas) {
        int saveCount = canvas.save();
        this.mTempBounds.set(this.mBounds);
        this.mTempBounds.inset(this.mStrokeInset, this.mStrokeInset);
        canvas.rotate(this.mGroupRotation, this.mTempBounds.centerX(), this.mTempBounds.centerY());
        for (int i = 0; i < 3; ++i) {
            if (this.mLevelSwipeDegrees[i] == 0.0f) continue;
            this.mPaint.setColor(this.mLevelColors[i]);
            canvas.drawArc(this.mTempBounds, this.mEndDegrees, this.mLevelSwipeDegrees[i], false, this.mPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected void computeRender(float renderProgress) {
        float levelSwipeDegreesProgress;
        float mSwipeDegrees;
        if (renderProgress <= 0.5f) {
            float startTrimProgress = renderProgress / 0.5f;
            this.mStartDegrees = this.mOriginStartDegrees + 288.0f * MATERIAL_INTERPOLATOR.getInterpolation(startTrimProgress);
            mSwipeDegrees = this.mEndDegrees - this.mStartDegrees;
            levelSwipeDegreesProgress = Math.abs(mSwipeDegrees) / 288.0f;
            float level1Increment = DECELERATE_INTERPOLATOR.getInterpolation(levelSwipeDegreesProgress) - LINEAR_INTERPOLATOR.getInterpolation(levelSwipeDegreesProgress);
            float level3Increment = ACCELERATE_INTERPOLATOR.getInterpolation(levelSwipeDegreesProgress) - LINEAR_INTERPOLATOR.getInterpolation(levelSwipeDegreesProgress);
            this.mLevelSwipeDegrees[0] = -mSwipeDegrees * LEVEL_SWEEP_ANGLE_OFFSETS[0] * (1.0f + level1Increment);
            this.mLevelSwipeDegrees[1] = -mSwipeDegrees * LEVEL_SWEEP_ANGLE_OFFSETS[1] * 1.0f;
            this.mLevelSwipeDegrees[2] = -mSwipeDegrees * LEVEL_SWEEP_ANGLE_OFFSETS[2] * (1.0f + level3Increment);
        }
        if (renderProgress > 0.5f) {
            float endTrimProgress = (renderProgress - 0.5f) / 0.5f;
            this.mEndDegrees = this.mOriginEndDegrees + 288.0f * MATERIAL_INTERPOLATOR.getInterpolation(endTrimProgress);
            mSwipeDegrees = this.mEndDegrees - this.mStartDegrees;
            levelSwipeDegreesProgress = Math.abs(mSwipeDegrees) / 288.0f;
            if (levelSwipeDegreesProgress > LEVEL_SWEEP_ANGLE_OFFSETS[1]) {
                this.mLevelSwipeDegrees[0] = -mSwipeDegrees;
                this.mLevelSwipeDegrees[1] = 288.0f * LEVEL_SWEEP_ANGLE_OFFSETS[1];
                this.mLevelSwipeDegrees[2] = 288.0f * LEVEL_SWEEP_ANGLE_OFFSETS[2];
            } else if (levelSwipeDegreesProgress > LEVEL_SWEEP_ANGLE_OFFSETS[2]) {
                this.mLevelSwipeDegrees[0] = 0.0f;
                this.mLevelSwipeDegrees[1] = -mSwipeDegrees;
                this.mLevelSwipeDegrees[2] = 288.0f * LEVEL_SWEEP_ANGLE_OFFSETS[2];
            } else {
                this.mLevelSwipeDegrees[0] = 0.0f;
                this.mLevelSwipeDegrees[1] = 0.0f;
                this.mLevelSwipeDegrees[2] = -mSwipeDegrees;
            }
        }
        this.mGroupRotation = 216.0f * renderProgress + 1080.0f * (this.mRotationCount / 5.0f);
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
        this.resetOriginals();
    }

    private void initStrokeInset(float width, float height) {
        float minStrokeInset;
        float minSize = Math.min(width, height);
        float strokeInset = minSize / 2.0f - this.mCenterRadius;
        this.mStrokeInset = strokeInset < (minStrokeInset = (float)Math.ceil(this.mStrokeWidth / 2.0f)) ? minStrokeInset : strokeInset;
    }

    private void storeOriginals() {
        this.mOriginEndDegrees = this.mEndDegrees;
        this.mOriginStartDegrees = this.mEndDegrees;
    }

    private void resetOriginals() {
        this.mOriginEndDegrees = 0.0f;
        this.mOriginStartDegrees = 0.0f;
        this.mEndDegrees = 0.0f;
        this.mStartDegrees = 0.0f;
        this.mLevelSwipeDegrees[0] = 0.0f;
        this.mLevelSwipeDegrees[1] = 0.0f;
        this.mLevelSwipeDegrees[2] = 0.0f;
    }

    private void apply(Builder builder) {
        this.mWidth = builder.mWidth > 0 ? (float)builder.mWidth : this.mWidth;
        this.mHeight = builder.mHeight > 0 ? (float)builder.mHeight : this.mHeight;
        this.mStrokeWidth = builder.mStrokeWidth > 0 ? (float)builder.mStrokeWidth : this.mStrokeWidth;
        this.mCenterRadius = builder.mCenterRadius > 0 ? (float)builder.mCenterRadius : this.mCenterRadius;
        this.mDuration = builder.mDuration > 0 ? (long)builder.mDuration : this.mDuration;
        this.mLevelColors = builder.mLevelColors != null ? builder.mLevelColors : this.mLevelColors;
        this.setupPaint();
        this.initStrokeInset(this.mWidth, this.mHeight);
    }

    public static class Builder {
        private Context mContext;
        private int mWidth;
        private int mHeight;
        private int mStrokeWidth;
        private int mCenterRadius;
        private int mDuration;
        private int[] mLevelColors;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.mHeight = height;
            return this;
        }

        public Builder setStrokeWidth(int strokeWidth) {
            this.mStrokeWidth = strokeWidth;
            return this;
        }

        public Builder setCenterRadius(int centerRadius) {
            this.mCenterRadius = centerRadius;
            return this;
        }

        public Builder setDuration(int duration) {
            this.mDuration = duration;
            return this;
        }

        public Builder setLevelColors(int[] colors) {
            this.mLevelColors = colors;
            return this;
        }

        public Builder setLevelColor(int color) {
            return this.setLevelColors(new int[]{this.oneThirdAlphaColor(color), this.twoThirdAlphaColor(color), color});
        }

        public LevelLoadingRenderer build() {
            LevelLoadingRenderer loadingRenderer = new LevelLoadingRenderer(this.mContext);
            loadingRenderer.apply(this);
            return loadingRenderer;
        }

        private int oneThirdAlphaColor(int colorValue) {
            int startA = colorValue >> 24 & 0xFF;
            int startR = colorValue >> 16 & 0xFF;
            int startG = colorValue >> 8 & 0xFF;
            int startB = colorValue & 0xFF;
            return startA / 3 << 24 | startR << 16 | startG << 8 | startB;
        }

        private int twoThirdAlphaColor(int colorValue) {
            int startA = colorValue >> 24 & 0xFF;
            int startR = colorValue >> 16 & 0xFF;
            int startG = colorValue >> 8 & 0xFF;
            int startB = colorValue & 0xFF;
            return startA * 2 / 3 << 24 | startR << 16 | startG << 8 | startB;
        }
    }
}

