package com.ark.dict;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

final class InnerUtils {

    @NonNull
    static String getLanguage(@NonNull Context context) {
        try {
            Locale locale;
            if (Build.VERSION.SDK_INT >= 24) {
                locale = context.getResources().getConfiguration().getLocales().get(0);
            } else {
                locale = context.getResources().getConfiguration().locale;
            }
            String language = locale.getLanguage() + "-" + locale.getCountry();
            if (language.startsWith("zh-")) {
                if (language.startsWith("zh-CN")) {
                    return "CN";//中文简体
                }
                return "CT";//中文
            }
            if (language.startsWith("fr-")) {
                return "FR";//法语
            }
            if (language.startsWith("de-")) {
                return "GE";//德语
            }
            if (language.startsWith("it-")) {
                return "IT";//意大利语
            }
            if (language.startsWith("ja-")) {
                return "JP";//日语
            }
            if (language.startsWith("ko-")) {
                return "KR";//韩语
            }
            if (language.startsWith("ru-")) {
                return "RU";//俄语
            }
            if (language.startsWith("es-")) {
                return "SP";//西班牙语
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "EN";
    }

    /**
     * @param context 上下文信息
     * @return 获取包信息
     */
    @Nullable
    private static PackageInfo getPackageInfo(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            return packageManager.getPackageInfo(context.getPackageName(), 0);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        return null;
    }

    /**
     * 获取应用版本名
     *
     * @param context 上下文信息
     * @return 成功返回版本名， 失败返回null
     */
    @NonNull
    static String getVersionName(@NonNull Context context) {
        PackageInfo packageInfo = getPackageInfo(context);
        if (packageInfo != null) {
            return packageInfo.versionName;
        }
        return "1.0";
    }

    /**
     * 获取当前应用程序的友盟渠道
     *
     * @param context 上下文信息
     * @return umeng channel
     */
    @NonNull
    static String getChannel(@Nullable Context context) {
        String str = getUMChannel(context);
        if (str == null || TextUtils.isEmpty(str) || TextUtils.equals("null", str)) {
            str = "default";
        }
        return str;
    }

    /**
     * 获取友盟渠道名
     *
     * @param ctx 上下文信息
     * @return 如果没有获取成功，那么返回值为空
     */
    @Nullable
    private static String getUMChannel(@Nullable Context ctx) {
        if (ctx == null) {
            return null;
        }
        String channelName = null;
        try {
            PackageManager packageManager = ctx.getPackageManager();
            if (packageManager != null) {
                ApplicationInfo applicationInfo = packageManager
                        .getApplicationInfo(ctx.getPackageName(), PackageManager.GET_META_DATA);
                if (applicationInfo != null) {
                    if (applicationInfo.metaData != null) {
                        channelName = applicationInfo.metaData.get("UMENG_CHANNEL") + "";
                    }
                }

            }
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return channelName;
    }

    static void sendConfigResp(Context context,
                               boolean byUser) {
        Intent intent = new Intent(
                context.getPackageName() + ".dict.config.ACTION");
        intent.setPackage(context.getPackageName());
        intent.putExtra("byUser", byUser);
        context.sendBroadcast(intent);
    }


    static String encode32MD5(String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes());
            byte messageDigest[] = digest.digest();
            return toHexString32(messageDigest);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

    private static String toHexString32(byte[] keyData) {
        if (keyData == null) {
            return null;
        }
        int expectedStringLen = keyData.length * 2;
        StringBuilder sb = new StringBuilder(expectedStringLen);
        for (byte aKeyData : keyData) {
            String hexStr = Integer.toString(aKeyData & 0x00FF, 16);
            if (hexStr.length() == 1) {
                hexStr = "0" + hexStr;
            }
            sb.append(hexStr);
        }
        return sb.toString();
    }
}
