/*
 * Decompiled with CFR 0.152.
 */
package com.ark.dict;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import com.ark.dict.ConfigMapLoader;
import com.ark.dict.OnConfigRespListener;
import java.util.ArrayList;
import java.util.List;

public class ConfigBroadcastReceiver
extends BroadcastReceiver {
    private static final List<OnConfigRespListener> mListeners = new ArrayList<OnConfigRespListener>();

    public void onReceive(Context context, Intent intent) {
        boolean byUser = false;
        if (intent != null) {
            byUser = intent.getBooleanExtra("byUser", false);
        }
        for (OnConfigRespListener mListener : mListeners) {
            if (mListener == null) continue;
            mListener.onLoaded(byUser, ConfigMapLoader.getInstance());
        }
    }

    public void addOnConfigRespListener(@Nullable OnConfigRespListener listener) {
        if (listener != null) {
            mListeners.add(listener);
        }
    }

    public void removeOnConfigRespListener(@Nullable OnConfigRespListener listener) {
        if (listener != null) {
            mListeners.remove(listener);
        }
    }

    public void removeAllOnConfigRespListener() {
        mListeners.clear();
    }
}

