package com.ark.dict;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.tencent.mmkv.MMKV;
import com.yanzhenjie.kalle.Kalle;
import com.yanzhenjie.kalle.KalleConfig;
import com.yanzhenjie.kalle.connect.BroadcastNetwork;
import com.yanzhenjie.kalle.cookie.DBCookieStore;
import com.yanzhenjie.kalle.urlconnect.URLConnectionFactory;

public class InitContentProvider extends ContentProvider {

    @Override
    public boolean onCreate() {
        final Context context = getContext();
        if (context != null) {
            Utils.init(context);
            Kalle.setConfig(KalleConfig.newBuilder()
                    .network(new BroadcastNetwork(context))
                    .connectFactory(URLConnectionFactory.newBuilder().build())
                    .cookieStore(DBCookieStore.newBuilder(context).build())
                    .build());
            String rootDir = MMKV.initialize(context);
            Log.i("logger", "Utils 准备就绪... MMKV 准备就绪..." + rootDir);
            ConfigMapLoader.getInstance()
                    .enableRefresh(true)
                    .request(false);
            Log.i("logger", "start load server key value");
        }
        return true;
    }

    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, @Nullable String[] strings, @Nullable String s,
            @Nullable String[] strings1, @Nullable String s1) {
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues contentValues) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String s, @Nullable String[] strings) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues contentValues, @Nullable String s,
            @Nullable String[] strings) {
        return 0;
    }
}
