package com.ark.dict;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;

public class ConfigBroadcastReceiver extends BroadcastReceiver {

    private static final List<OnConfigRespListener> mListeners = new ArrayList<>();

    @Override
    public void onReceive(Context context, Intent intent) {
        boolean byUser = false;
        if (intent != null) {
            byUser = intent.getBooleanExtra("byUser", false);
        }
        for (OnConfigRespListener mListener : mListeners) {
            if (mListener != null) {
                mListener.onLoaded(byUser, ConfigMapLoader.getInstance());
            }
        }
    }

    /**
     * 添加设置响应监听
     *
     * @param listener OnConfigRespListener
     */
    public void addOnConfigRespListener(@Nullable OnConfigRespListener listener) {
        if (listener != null) {
            mListeners.add(listener);
        }
    }

    /**
     * 移除设置响应监听
     *
     * @param listener OnConfigRespListener
     */
    public void removeOnConfigRespListener(
            @Nullable OnConfigRespListener listener) {
        if (listener != null) {
            mListeners.remove(listener);
        }
    }

    /**
     * 移除所有设置响应监听
     */
    public void removeAllOnConfigRespListener() {
        mListeners.clear();
    }
}
