/*
 * Decompiled with CFR 0.152.
 */
package com.cheese.geeksone.core;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.support.v7.app.AlertDialog;
import com.cheese.geeksone.R;
import com.cheese.geeksone.Utils;
import com.cheese.geeksone.core.Container;
import com.cheese.geeksone.core.Mode;
import com.cheese.geeksone.core.OnCancelledListener;
import com.cheese.geeksone.core.OnResultListener;
import com.cheese.geeksone.lib.HttpRequest;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;
import org.json.JSONObject;

public class Geeksone {
    Activity mActivity;
    Object mRequest;
    Container mContainer;
    HttpRequest mHttpRequest;
    boolean mAutoPilot = false;
    Mode mRequestMode;
    OnResultListener mResultListener;
    OnCancelledListener mCancelledListener;
    String mURL;
    String mResponse;
    int mTimeout = 8000;
    AlertDialog mDialog;
    ProgressDialog mProgressDialog;

    public Geeksone GET(String url) {
        this.mURL = url;
        this.mRequestMode = Mode.GET;
        this.mContainer = new Container(url).setMode(Mode.GET);
        this.setOnResultListener(this.mContainer.getOnResult());
        this.setOnCancelledListener(this.mContainer.getOnCancelled());
        this.start();
        return this;
    }

    public Geeksone POST(String url, Object obj) {
        this.mURL = url;
        this.mRequestMode = Mode.POST;
        this.mRequest = obj;
        this.mContainer = new Container(url).setRequestBody(obj).setMode(Mode.POST);
        this.setOnResultListener(this.mContainer.getOnResult());
        this.setOnCancelledListener(this.mContainer.getOnCancelled());
        this.start();
        return this;
    }

    public Geeksone GET(Container container) {
        this.mContainer = container;
        this.mURL = container.getURL();
        this.mRequestMode = Mode.GET;
        this.mContainer.setMode(this.mRequestMode);
        this.setOnResultListener(this.mContainer.getOnResult());
        this.setOnCancelledListener(this.mContainer.getOnCancelled());
        this.start();
        return this;
    }

    public Geeksone POST(Container container) {
        this.mContainer = container;
        this.mURL = container.getURL();
        this.mRequest = container.getRequestBody();
        this.mRequestMode = Mode.POST;
        this.mContainer.setMode(this.mRequestMode);
        this.setOnResultListener(this.mContainer.getOnResult());
        this.setOnCancelledListener(this.mContainer.getOnCancelled());
        this.start();
        return this;
    }

    public Geeksone setTimeout(int timeoutInMs) {
        this.mTimeout = timeoutInMs;
        return this;
    }

    public Geeksone setAlertDialog(AlertDialog dialog) {
        this.mDialog = dialog;
        return this;
    }

    public Geeksone setProgressDialog(ProgressDialog progressDialog) {
        this.mProgressDialog = progressDialog;
        return this;
    }

    public Geeksone RETRY(Container c) {
        if (c.getMode() == Mode.GET) {
            this.GET(c);
        }
        if (c.getMode() == Mode.POST) {
            this.POST(c);
        }
        return this;
    }

    private void setOnResultListener(OnResultListener listener) {
        this.mResultListener = listener;
    }

    private void setOnCancelledListener(OnCancelledListener listener) {
        this.mCancelledListener = listener;
    }

    private void start() {
        new AsyncTask<Void, Void, Boolean>(){

            protected Boolean doInBackground(Void ... params) {
                if (!this.isCancelled()) {
                    try {
                        Geeksone.this.mHttpRequest = null;
                        if (Geeksone.this.mRequestMode == Mode.GET) {
                            Geeksone.this.mHttpRequest = HttpRequest.get(Geeksone.this.mURL).readTimeout(Geeksone.this.mTimeout).connectTimeout(Geeksone.this.mTimeout);
                        } else if (Geeksone.this.mRequestMode == Mode.POST) {
                            Geeksone.this.mHttpRequest = HttpRequest.post(Geeksone.this.mURL).contentType("application/json").send(Geeksone.this.getRequest(Geeksone.this.mRequest));
                        } else if (Geeksone.this.mRequestMode == Mode.PUT) {
                            Geeksone.this.mHttpRequest = HttpRequest.put(Geeksone.this.mURL).contentType("application/json").send(Geeksone.this.getRequest(Geeksone.this.mRequest)).readTimeout(Geeksone.this.mTimeout).connectTimeout(Geeksone.this.mTimeout);
                        } else if (Geeksone.this.mRequestMode == Mode.DELETE) {
                            Geeksone.this.mHttpRequest = HttpRequest.delete(Geeksone.this.mURL).contentType("application/json").send(Geeksone.this.getRequest(Geeksone.this.mRequest));
                        } else {
                            Geeksone.this.PokeOnError(new Exception("Unsupported REST Mode"));
                        }
                        if (Geeksone.this.mHttpRequest != null) {
                            if (Geeksone.this.mContainer.getHeader() != null) {
                                Geeksone.this.mHttpRequest.headers(Geeksone.this.mContainer.getHeader());
                            }
                            if (Geeksone.this.mContainer.hasBasic()) {
                                Geeksone.this.mHttpRequest.basic(Geeksone.this.mContainer.BasicUsername(), Geeksone.this.mContainer.BasicPassword());
                            }
                            Geeksone.this.mHttpRequest.readTimeout(Geeksone.this.mTimeout).connectTimeout(Geeksone.this.mTimeout);
                        }
                        Geeksone.this.mResponse = Geeksone.this.mHttpRequest.body();
                        return true;
                    }
                    catch (Exception e) {
                        Geeksone.this.Error(e);
                        e.printStackTrace();
                        return false;
                    }
                }
                return false;
            }

            protected void onPreExecute() {
                super.onPreExecute();
                boolean bl = Geeksone.this.mAutoPilot = Geeksone.this.mContainer.getActivity() != null;
                if (Geeksone.this.mAutoPilot) {
                    Geeksone.this.mActivity = Geeksone.this.mContainer.getActivity();
                    Geeksone.this.mDialog = new AlertDialog.Builder((Context)Geeksone.this.mActivity).setCancelable(true).setNegativeButton((CharSequence)"CANCEL", null).create();
                    Geeksone.this.mProgressDialog = new ProgressDialog((Context)Geeksone.this.mActivity);
                    Geeksone.this.mProgressDialog.setMessage((CharSequence)Geeksone.this.mActivity.getString(R.string.gk_pb_message));
                    Geeksone.this.mProgressDialog.setTitle((CharSequence)Geeksone.this.mActivity.getString(R.string.gk_pb_title));
                    Geeksone.this.mProgressDialog.setIndeterminate(true);
                    Geeksone.this.mProgressDialog.setCancelable(false);
                    Geeksone.this.mProgressDialog.setCanceledOnTouchOutside(false);
                }
                if (Geeksone.this.mAutoPilot && Geeksone.this.mActivity != null) {
                    Geeksone.this.mActivity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (Geeksone.this.mProgressDialog.isShowing()) {
                                Geeksone.this.mProgressDialog.dismiss();
                            }
                            Geeksone.this.mProgressDialog.show();
                        }
                    });
                }
                if (Geeksone.this.getRequest(Geeksone.this.mRequest) == null) {
                    this.cancel(true);
                }
            }

            protected void onPostExecute(Boolean aBoolean) {
                super.onPostExecute((Object)aBoolean);
                if (Geeksone.this.mAutoPilot && Geeksone.this.mActivity != null) {
                    Geeksone.this.mActivity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (Geeksone.this.mProgressDialog.isShowing()) {
                                Geeksone.this.mProgressDialog.dismiss();
                            }
                        }
                    });
                }
                if (aBoolean.booleanValue()) {
                    if (Geeksone.this.getResponse() == null) {
                        if (Geeksone.this.mAutoPilot) {
                            Geeksone.this.ShowDialog(R.string.gk_err_no_response);
                        } else {
                            Geeksone.this.PokeOnError(new Exception(Geeksone.this.mActivity.getString(R.string.gk_err_no_response)));
                        }
                    } else if (Geeksone.this.getJSON() == null) {
                        Geeksone.this.mResultListener.OnResult(false, Geeksone.this.mContainer, Geeksone.this, new Exception("Response is null or not a valid JSON"));
                    } else {
                        Geeksone.this.mResultListener.OnResult(true, Geeksone.this.mContainer, Geeksone.this, null);
                    }
                } else if (Geeksone.this.mResultListener == null) {
                    Geeksone.this.PokeOnError(new Exception("OnResultListener cannot be null"));
                } else if (Geeksone.this.getRequest(Geeksone.this.mRequest) == null) {
                    Geeksone.this.PokeOnError(new NullPointerException("Unable to handle request body"));
                }
            }
        }.execute((Object[])new Void[0]);
    }

    private void Error(Exception e) {
        if (Utils.HasConnectivity((Context)this.mActivity)) {
            if (e.getCause() instanceof ConnectException || e.getCause() instanceof TimeoutException || e.getCause() instanceof SocketTimeoutException) {
                if (this.mAutoPilot) {
                    this.ShowDialog(R.string.gk_err_connection_timeout);
                } else {
                    this.PokeOnConnectionTimeOut(e);
                }
            } else if (e.getCause() instanceof UnknownHostException || e.getCause() instanceof ConnectException || e.getCause() instanceof NoRouteToHostException) {
                if (this.mAutoPilot) {
                    this.ShowDialog(R.string.gk_err_host_unreachable);
                } else {
                    this.PokeOnError(e);
                }
            } else if (e.getCause() instanceof MalformedURLException) {
                if (this.mAutoPilot) {
                    this.ShowDialog(R.string.gk_err_malformed_url);
                } else {
                    this.PokeOnError(e);
                }
            } else if (this.mAutoPilot) {
                this.ShowDialog(R.string.gk_err_unknown);
            } else {
                this.PokeOnError(e);
            }
        } else if (this.mAutoPilot) {
            this.ShowDialog(R.string.gk_err_no_internet);
        } else {
            this.PokeOnError(e);
        }
    }

    private void ShowDialog(final int stringId) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Geeksone.this.mDialog.setMessage((CharSequence)Geeksone.this.mActivity.getString(stringId));
                Geeksone.this.mDialog.setButton(-1, (CharSequence)"RETRY", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Geeksone.this.RETRY(Geeksone.this.mContainer);
                    }
                });
                Geeksone.this.mDialog.show();
            }
        });
    }

    private void ShowDialog(final String msg) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Geeksone.this.mDialog.setMessage((CharSequence)msg);
                Geeksone.this.mDialog.setButton(-1, (CharSequence)"RETRY", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Geeksone.this.RETRY(Geeksone.this.mContainer);
                    }
                });
                Geeksone.this.mDialog.show();
            }
        });
    }

    private void PokeOnError(final Exception ex) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (Geeksone.this.mCancelledListener != null) {
                    Geeksone.this.mCancelledListener.OnError(ex, false, Geeksone.this.mContainer, Geeksone.this);
                }
            }
        });
    }

    private void PokeOnConnectionTimeOut(final Exception ex) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (Geeksone.this.mCancelledListener != null) {
                    Geeksone.this.mCancelledListener.OnError(ex, true, Geeksone.this.mContainer, Geeksone.this);
                }
            }
        });
    }

    public String getRequest(Object obj) {
        if (this.mRequest instanceof JSONObject) {
            return ((JSONObject)obj).toString();
        }
        if (this.mRequest instanceof String) {
            return (String)obj;
        }
        return new GsonBuilder().create().toJson(obj);
    }

    public String getResponse() {
        return this.mResponse;
    }

    public String getJSON() {
        if (this.mResponse == null) {
            return null;
        }
        if (Utils.IsValidJSON(this.mResponse)) {
            return this.mResponse;
        }
        return null;
    }

    public <T> T getClazz(Class<T> clazz) {
        if (this.getJSON() != null) {
            try {
                return (T)new GsonBuilder().create().fromJson(this.getJSON(), clazz);
            }
            catch (Exception ex) {
                this.PokeOnError(ex);
                return null;
            }
        }
        this.PokeOnError(new Exception("Response is null"));
        return null;
    }

    public <T> T getClazz(Type t) {
        try {
            return (T)new GsonBuilder().create().fromJson(this.getJSON(), t);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Container getContainer() {
        return this.mContainer;
    }
}

