/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.longstream;

import android.support.annotation.NonNull;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStream;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStreamCompat;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.function.LongBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.LongConsumer;
import com.github.wrdlbrnft.streamcompat.function.LongFunction;
import com.github.wrdlbrnft.streamcompat.function.LongPredicate;
import com.github.wrdlbrnft.streamcompat.function.LongToByteFunction;
import com.github.wrdlbrnft.streamcompat.function.LongToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.LongToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.LongToFloatFunction;
import com.github.wrdlbrnft.streamcompat.function.LongToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.LongUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.ObjLongConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.function.ToLongFunction;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.array.LongArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ByteChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.CharChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.DoubleChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.FloatChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.IntChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.LongChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.LongIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongExceptional;
import com.github.wrdlbrnft.streamcompat.longstream.LongIteratorWrapper;
import com.github.wrdlbrnft.streamcompat.longstream.LongIteratorWrapperImpl;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalDouble;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalLong;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.Arrays;
import java.util.Iterator;

class LongStreamImpl
implements LongStream {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private final LongIterator mIterator;
    private final LongIteratorWrapper mIteratorWrapper = new LongIteratorWrapperImpl();

    LongStreamImpl(LongIterator iterator) {
        this.mIterator = this.mIteratorWrapper.apply(iterator);
    }

    @Override
    public LongStream filter(LongPredicate predicate) {
        Utils.requireNonNull(predicate);
        DummyIterator iterator = new DummyIterator();
        return new LongStreamImpl(new LongChildIterator(() -> {
            while (this.mIterator.hasNext()) {
                long value = this.mIterator.nextLong();
                if (!predicate.test(value)) continue;
                return iterator.newValue(value);
            }
            return iterator;
        }, Iterator::hasNext, LongIterator::nextLong));
    }

    @Override
    public LongStream map(LongUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        return new LongStreamImpl(new LongChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsLong(iterator.nextLong())));
    }

    @Override
    public LongStream flatMap(LongFunction<? extends LongStream> mapper) {
        Utils.requireNonNull(mapper);
        LongIterator[] buffer = new LongIterator[1];
        return new LongStreamImpl(new LongChildIterator(() -> {
            if (buffer[0] == null || !buffer[0].hasNext()) {
                if (!this.mIterator.hasNext()) {
                    return LongStreamCompat.EMPTY_ITERATOR;
                }
                buffer[0] = ((LongStream)mapper.apply(this.mIterator.nextLong())).iterator();
            }
            return buffer[0];
        }, Iterator::hasNext, LongIterator::nextLong));
    }

    @Override
    public <U> Stream<U> mapToObj(LongFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        return StreamCompat.of(new ChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.apply(this.mIterator.nextLong())));
    }

    @Override
    public IntStream mapToInt(LongToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        return IntStreamCompat.of(new IntChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsInt(this.mIterator.nextLong())));
    }

    @Override
    public DoubleStream mapToDouble(LongToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        return DoubleStreamCompat.of(new DoubleChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsDouble(this.mIterator.nextLong())));
    }

    @Override
    public FloatStream mapToFloat(LongToFloatFunction mapper) {
        Utils.requireNonNull(mapper);
        return FloatStreamCompat.of(new FloatChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsFloat(this.mIterator.nextLong())));
    }

    @Override
    public CharacterStream mapToChar(LongToCharFunction mapper) {
        Utils.requireNonNull(mapper);
        return CharacterStreamCompat.of(new CharChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsChar(this.mIterator.nextLong())));
    }

    @Override
    public ByteStream mapToByte(LongToByteFunction mapper) {
        Utils.requireNonNull(mapper);
        return ByteStreamCompat.of(new ByteChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsByte(this.mIterator.nextLong())));
    }

    @Override
    @NonNull
    public LongIterator iterator() {
        return this.mIterator;
    }

    @Override
    public void forEach(LongConsumer action) {
        Utils.requireNonNull(action);
        while (this.mIterator.hasNext()) {
            long value = this.mIterator.nextLong();
            action.accept(value);
        }
    }

    @Override
    public Stream<Long> boxed() {
        return this.mapToObj(Long::valueOf);
    }

    @Override
    public LongStream limit(long maxSize) {
        long[] buffer = new long[]{0L, maxSize};
        return new LongStreamImpl(new LongChildIterator(() -> this.mIterator, iterator -> buffer[0] < buffer[1] && this.mIterator.hasNext(), iterator -> {
            buffer[0] = buffer[0] + 1L;
            return iterator.nextLong();
        }));
    }

    @Override
    public LongStream skip(long count) {
        long[] buffer = new long[]{0L, count};
        return new LongStreamImpl(new LongChildIterator(() -> {
            while (this.mIterator.hasNext() && buffer[0] < buffer[1]) {
                this.mIterator.nextLong();
                buffer[0] = buffer[0] + 1L;
            }
            return this.mIterator;
        }, Iterator::hasNext, LongIterator::nextLong));
    }

    @Override
    public long reduce(long identity, LongBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        long current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsInt(current, this.mIterator.nextLong());
        }
        return current;
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalLong.empty();
        }
        long current = this.mIterator.nextLong();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsInt(current, this.mIterator.nextLong());
        }
        return OptionalLong.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextLong());
        }
        return sink;
    }

    @Override
    public <E extends Throwable> LongExceptional<E> exception(Class<E> cls) {
        return new LongExceptionalImpl<E>(cls);
    }

    @Override
    public long sum() {
        return this.reduce(0L, (a, b) -> a + b);
    }

    @Override
    public OptionalLong min() {
        return this.reduce(Math::min);
    }

    @Override
    public OptionalLong max() {
        return this.reduce(Math::max);
    }

    @Override
    public long count() {
        return this.map(i -> 1L).sum();
    }

    @Override
    public LongStream sort() {
        return new LongStreamImpl(new LongChildIterator(() -> {
            long[] array = this.toArray();
            Arrays.sort(array);
            return new LongArrayIterator(array);
        }, Iterator::hasNext, LongIterator::nextLong));
    }

    @Override
    public OptionalDouble average() {
        long[] avg = this.collect(() -> new long[2], (ll, i) -> {
            ll[0] = ll[0] + 1L;
            ll[1] = ll[1] + i;
        });
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public OptionalLong findFirst() {
        if (this.mIterator.hasNext()) {
            return OptionalLong.of(this.mIterator.nextLong());
        }
        return OptionalLong.empty();
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        Utils.requireNonNull(predicate);
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextLong())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        Utils.requireNonNull(predicate);
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        Utils.requireNonNull(predicate);
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    @Override
    public long[] toArray() {
        long[] tmp = new long[16];
        int index = 0;
        while (this.mIterator.hasNext()) {
            long c = this.mIterator.nextLong();
            if (index >= tmp.length) {
                long[] newArray = new long[tmp.length * 2];
                System.arraycopy(tmp, 0, newArray, 0, tmp.length);
                tmp = newArray;
            }
            tmp[index++] = c;
        }
        long[] result = new long[index];
        System.arraycopy(tmp, 0, result, 0, index);
        return result;
    }

    private class LongExceptionalImpl<E extends Throwable>
    implements LongExceptional<E> {
        private final Class<E> mExceptionClass;

        public LongExceptionalImpl(Class<E> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        @Override
        public LongStream mapException(ToLongFunction<E> mapper) {
            LongStreamImpl.this.mIteratorWrapper.mapException(this.mExceptionClass, mapper);
            return LongStreamImpl.this;
        }

        @Override
        public LongStream consume(Consumer<E> consumer) {
            LongStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, consumer);
            return LongStreamImpl.this;
        }

        @Override
        public <I extends RuntimeException> LongStream rethrow(Function<E, I> mapper) {
            LongStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {
                throw (RuntimeException)mapper.apply(e);
            });
            return LongStreamImpl.this;
        }

        @Override
        public LongStream ignore() {
            LongStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {});
            return LongStreamImpl.this;
        }
    }

    private static class DummyIterator
    extends BaseIterator<Long>
    implements LongIterator {
        private long mValue;
        private boolean mHasNext;

        public DummyIterator(long value) {
            this(value, true);
        }

        public DummyIterator() {
            this(0L, false);
        }

        private DummyIterator(long value, boolean hasNext) {
            this.mValue = value;
            this.mHasNext = hasNext;
        }

        public DummyIterator newValue(long value) {
            this.mValue = value;
            this.mHasNext = true;
            return this;
        }

        @Override
        public long nextLong() {
            this.mHasNext = false;
            return this.mValue;
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public Long next() {
            return this.nextLong();
        }
    }
}

