/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.floatstream;

import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl;
import com.github.wrdlbrnft.streamcompat.iterator.array.ArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.array.FloatArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.FloatChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.FloatIterator;
import com.github.wrdlbrnft.streamcompat.util.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FloatStreamCompat {
    static final FloatIterator EMPTY_ITERATOR = new EmptyFloatIterator();
    private static final FloatStreamImpl EMPTY_STREAM = new FloatStreamImpl(EMPTY_ITERATOR);

    public static FloatStream empty() {
        return EMPTY_STREAM;
    }

    public static FloatStream concat(FloatStream ... streams) {
        ArrayIterator<FloatStream> iterator = new ArrayIterator<FloatStream>(streams);
        FloatIterator[] buffer = new FloatIterator[1];
        return new FloatStreamImpl(new FloatChildIterator(() -> {
            if (buffer[0] == null || !buffer[0].hasNext()) {
                if (!iterator.hasNext()) {
                    return EMPTY_ITERATOR;
                }
                buffer[0] = ((FloatStream)iterator.next()).iterator();
            }
            return buffer[0];
        }, Iterator::hasNext, FloatIterator::nextFloat));
    }

    public static FloatStream of(float ... values) {
        FloatArrayIterator iterator = new FloatArrayIterator(values);
        return new FloatStreamImpl(iterator);
    }

    public static FloatStream of(FloatIterator iterator) {
        return new FloatStreamImpl(iterator);
    }

    private static class EmptyFloatIterator
    extends EmptyIterator<Float>
    implements FloatIterator {
        private EmptyFloatIterator() {
        }

        @Override
        public float nextFloat() {
            throw new NoSuchElementException();
        }
    }
}

