/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.characterstream;

import android.support.annotation.NonNull;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStream;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStreamCompat;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterExceptional;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterIteratorWrapper;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterIteratorWrapperImpl;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.CharBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.CharConsumer;
import com.github.wrdlbrnft.streamcompat.function.CharFunction;
import com.github.wrdlbrnft.streamcompat.function.CharPredicate;
import com.github.wrdlbrnft.streamcompat.function.CharToByteFunction;
import com.github.wrdlbrnft.streamcompat.function.CharToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.CharToFloatFunction;
import com.github.wrdlbrnft.streamcompat.function.CharToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.CharToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.CharUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.function.ObjCharConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.function.ToCharFunction;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.array.CharArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ByteChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.CharChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.DoubleChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.FloatChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.IntChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.LongChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.CharIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalCharacter;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalDouble;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.Arrays;
import java.util.Iterator;

class CharacterStreamImpl
implements CharacterStream {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private final CharacterIteratorWrapper mIteratorWrapper = new CharacterIteratorWrapperImpl();
    private final CharIterator mIterator;

    CharacterStreamImpl(CharIterator iterator) {
        this.mIterator = this.mIteratorWrapper.apply(iterator);
    }

    @Override
    public CharacterStream filter(CharPredicate predicate) {
        Utils.requireNonNull(predicate);
        DummyIterator iterator = new DummyIterator();
        return new CharacterStreamImpl(new CharChildIterator(() -> {
            while (this.mIterator.hasNext()) {
                char c = this.mIterator.nextChar();
                if (!predicate.test(c)) continue;
                return iterator.newValue(c);
            }
            return iterator;
        }, Iterator::hasNext, CharIterator::nextChar));
    }

    @Override
    public CharacterStream map(CharUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        return new CharacterStreamImpl(new CharChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsChar(iterator.nextChar())));
    }

    @Override
    public CharacterStream flatMap(CharFunction<? extends CharacterStream> mapper) {
        Utils.requireNonNull(mapper);
        CharIterator[] array = new CharIterator[1];
        return new CharacterStreamImpl(new CharChildIterator(() -> {
            if (array[0] == null || !array[0].hasNext()) {
                if (!this.mIterator.hasNext()) {
                    array[0] = CharacterStreamCompat.EMPTY_ITERATOR;
                    return array[0];
                }
                array[0] = ((CharacterStream)mapper.apply(this.mIterator.nextChar())).iterator();
            }
            return array[0];
        }, Iterator::hasNext, CharIterator::nextChar));
    }

    @Override
    public <U> Stream<U> mapToObj(CharFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        return StreamCompat.of(new ChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.apply(this.mIterator.nextChar())));
    }

    @Override
    public LongStream mapToLong(CharToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        return LongStreamCompat.of(new LongChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsLong(this.mIterator.nextChar())));
    }

    @Override
    public IntStream mapToInt(CharToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        return IntStreamCompat.of(new IntChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsInt(this.mIterator.nextChar())));
    }

    @Override
    public DoubleStream mapToDouble(CharToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        return DoubleStreamCompat.of(new DoubleChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsDouble(this.mIterator.nextChar())));
    }

    @Override
    public FloatStream mapToFloat(CharToFloatFunction mapper) {
        Utils.requireNonNull(mapper);
        return FloatStreamCompat.of(new FloatChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsFloat(this.mIterator.nextChar())));
    }

    @Override
    public ByteStream mapToByte(CharToByteFunction mapper) {
        Utils.requireNonNull(mapper);
        return ByteStreamCompat.of(new ByteChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsByte(this.mIterator.nextChar())));
    }

    @Override
    @NonNull
    public CharIterator iterator() {
        return this.mIterator;
    }

    @Override
    public void forEach(CharConsumer action) {
        Utils.requireNonNull(action);
        while (this.mIterator.hasNext()) {
            char value = this.mIterator.nextChar();
            action.accept(value);
        }
    }

    @Override
    public Stream<Character> boxed() {
        return this.mapToObj(Character::valueOf);
    }

    @Override
    public CharacterStream limit(long limit) {
        long[] array = new long[]{0L, limit};
        return new CharacterStreamImpl(new CharChildIterator(() -> this.mIterator, i -> array[0] < array[1] && i.hasNext(), i -> {
            array[0] = array[0] + 1L;
            return i.nextChar();
        }));
    }

    @Override
    public CharacterStream skip(long count) {
        long[] buffer = new long[]{0L, count};
        return new CharacterStreamImpl(new CharChildIterator(() -> {
            while (this.mIterator.hasNext() && buffer[0] < buffer[1]) {
                this.mIterator.nextChar();
                buffer[0] = buffer[0] + 1L;
            }
            return this.mIterator;
        }, Iterator::hasNext, CharIterator::nextChar));
    }

    @Override
    public char reduce(char identity, CharBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        char current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsChar(current, this.mIterator.nextChar());
        }
        return current;
    }

    @Override
    public OptionalCharacter reduce(CharBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalCharacter.empty();
        }
        char current = this.mIterator.nextChar();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsChar(current, this.mIterator.nextChar());
        }
        return OptionalCharacter.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjCharConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextChar());
        }
        return sink;
    }

    @Override
    public <E extends Throwable> CharacterExceptional<E> exception(Class<E> cls) {
        return new CharacterExceptionalImpl<E>(cls);
    }

    public char sum() {
        return this.reduce('\u0000', (a, b) -> (char)(a + b));
    }

    @Override
    public OptionalCharacter min() {
        return this.reduce((a, b) -> a < b ? a : b);
    }

    @Override
    public OptionalCharacter max() {
        return this.reduce((a, b) -> a < b ? b : a);
    }

    @Override
    public long count() {
        return this.mapToLong(i -> 1L).sum();
    }

    @Override
    public CharacterStream sort() {
        return new CharacterStreamImpl(new CharChildIterator(() -> {
            char[] array = this.toArray();
            Arrays.sort(array);
            return new CharArrayIterator(array);
        }, Iterator::hasNext, CharIterator::nextChar));
    }

    public OptionalDouble average() {
        long[] avg = this.collect(() -> new long[2], (ll, i) -> {
            ll[0] = ll[0] + 1L;
            ll[1] = ll[1] + (long)i;
        });
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public OptionalCharacter findFirst() {
        return this.mIterator.hasNext() ? OptionalCharacter.of(this.mIterator.nextChar()) : OptionalCharacter.empty();
    }

    @Override
    public boolean anyMatch(CharPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextChar())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(CharPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextChar())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(CharPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextChar())) continue;
            return false;
        }
        return true;
    }

    @Override
    public char[] toArray() {
        char[] tmp = new char[16];
        int index = 0;
        while (this.mIterator.hasNext()) {
            char c = this.mIterator.nextChar();
            if (index >= tmp.length) {
                char[] newArray = new char[tmp.length * 2];
                System.arraycopy(tmp, 0, newArray, 0, tmp.length);
                tmp = newArray;
            }
            tmp[index++] = c;
        }
        char[] result = new char[index];
        System.arraycopy(tmp, 0, result, 0, index);
        return result;
    }

    private class CharacterExceptionalImpl<E extends Throwable>
    implements CharacterExceptional<E> {
        private final Class<E> mExceptionClass;

        public CharacterExceptionalImpl(Class<E> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        @Override
        public CharacterStream mapException(ToCharFunction<E> mapper) {
            CharacterStreamImpl.this.mIteratorWrapper.mapException(this.mExceptionClass, mapper);
            return CharacterStreamImpl.this;
        }

        @Override
        public CharacterStream consume(Consumer<E> consumer) {
            CharacterStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, consumer);
            return CharacterStreamImpl.this;
        }

        @Override
        public <I extends RuntimeException> CharacterStream rethrow(Function<E, I> mapper) {
            CharacterStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {
                throw (RuntimeException)mapper.apply(e);
            });
            return CharacterStreamImpl.this;
        }

        @Override
        public CharacterStream ignore() {
            CharacterStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {});
            return CharacterStreamImpl.this;
        }
    }

    private static class DummyIterator
    extends BaseIterator<Character>
    implements CharIterator {
        private char mValue;
        private boolean mHasNext;

        public DummyIterator(char value) {
            this(value, true);
        }

        public DummyIterator() {
            this('a', false);
        }

        private DummyIterator(char value, boolean hasNext) {
            this.mValue = value;
            this.mHasNext = hasNext;
        }

        public DummyIterator newValue(char value) {
            this.mValue = value;
            this.mHasNext = true;
            return this;
        }

        @Override
        public char nextChar() {
            this.mHasNext = false;
            return this.mValue;
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public Character next() {
            return Character.valueOf(this.nextChar());
        }
    }
}

