/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.bytestream;

import android.support.annotation.NonNull;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteExceptional;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteIteratorWrapper;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteIteratorWrapperImpl;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStream;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStreamCompat;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.ByteBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.ByteConsumer;
import com.github.wrdlbrnft.streamcompat.function.ByteFunction;
import com.github.wrdlbrnft.streamcompat.function.BytePredicate;
import com.github.wrdlbrnft.streamcompat.function.ByteToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.ByteToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.ByteToFloatFunction;
import com.github.wrdlbrnft.streamcompat.function.ByteToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.ByteToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.ByteUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.function.ObjByteConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.function.ToByteFunction;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.array.ByteArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ByteChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.CharChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.DoubleChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.FloatChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.IntChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.LongChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.ByteIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalByte;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalDouble;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.Arrays;
import java.util.Iterator;

class ByteStreamImpl
implements ByteStream {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private final ByteIteratorWrapper mIteratorWrapper = new ByteIteratorWrapperImpl();
    private final ByteIterator mIterator;

    ByteStreamImpl(ByteIterator iterator) {
        this.mIterator = this.mIteratorWrapper.apply(iterator);
    }

    @Override
    public ByteStream filter(BytePredicate predicate) {
        Utils.requireNonNull(predicate);
        DummyIterator iterator = new DummyIterator();
        return new ByteStreamImpl(new ByteChildIterator(() -> {
            while (this.mIterator.hasNext()) {
                byte c = this.mIterator.nextByte();
                if (!predicate.test(c)) continue;
                return iterator.newValue(c);
            }
            return iterator;
        }, Iterator::hasNext, ByteIterator::nextByte));
    }

    @Override
    public ByteStream map(ByteUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        return new ByteStreamImpl(new ByteChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsByte(iterator.nextByte())));
    }

    @Override
    public ByteStream flatMap(ByteFunction<? extends ByteStream> mapper) {
        Utils.requireNonNull(mapper);
        ByteIterator[] array = new ByteIterator[1];
        return new ByteStreamImpl(new ByteChildIterator(() -> {
            if (array[0] == null || !array[0].hasNext()) {
                if (!this.mIterator.hasNext()) {
                    array[0] = ByteStreamCompat.EMPTY_ITERATOR;
                    return array[0];
                }
                array[0] = ((ByteStream)mapper.apply(this.mIterator.nextByte())).iterator();
            }
            return array[0];
        }, Iterator::hasNext, ByteIterator::nextByte));
    }

    @Override
    public <U> Stream<U> mapToObj(ByteFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        return StreamCompat.of(new ChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.apply(this.mIterator.nextByte())));
    }

    @Override
    public LongStream mapToLong(ByteToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        return LongStreamCompat.of(new LongChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsLong(this.mIterator.nextByte())));
    }

    @Override
    public IntStream mapToInt(ByteToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        return IntStreamCompat.of(new IntChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsInt(this.mIterator.nextByte())));
    }

    @Override
    public DoubleStream mapToDouble(ByteToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        return DoubleStreamCompat.of(new DoubleChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsDouble(this.mIterator.nextByte())));
    }

    @Override
    public FloatStream mapToFloat(ByteToFloatFunction mapper) {
        Utils.requireNonNull(mapper);
        return FloatStreamCompat.of(new FloatChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsFloat(this.mIterator.nextByte())));
    }

    @Override
    public CharacterStream mapToChar(ByteToCharFunction mapper) {
        Utils.requireNonNull(mapper);
        return CharacterStreamCompat.of(new CharChildIterator(() -> this.mIterator, Iterator::hasNext, iterator -> mapper.applyAsChar(this.mIterator.nextByte())));
    }

    @Override
    @NonNull
    public ByteIterator iterator() {
        return this.mIterator;
    }

    @Override
    public void forEach(ByteConsumer action) {
        Utils.requireNonNull(action);
        while (this.mIterator.hasNext()) {
            byte value = this.mIterator.nextByte();
            action.accept(value);
        }
    }

    @Override
    public Stream<Byte> boxed() {
        return this.mapToObj(Byte::valueOf);
    }

    @Override
    public ByteStream limit(long limit) {
        long[] array = new long[]{0L, limit};
        return new ByteStreamImpl(new ByteChildIterator(() -> this.mIterator, i -> array[0] < array[1] && i.hasNext(), i -> {
            array[0] = array[0] + 1L;
            return i.nextByte();
        }));
    }

    @Override
    public ByteStream skip(long count) {
        long[] buffer = new long[]{0L, count};
        return new ByteStreamImpl(new ByteChildIterator(() -> {
            while (this.mIterator.hasNext() && buffer[0] < buffer[1]) {
                this.mIterator.nextByte();
                buffer[0] = buffer[0] + 1L;
            }
            return this.mIterator;
        }, Iterator::hasNext, ByteIterator::nextByte));
    }

    @Override
    public byte reduce(byte identity, ByteBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        byte current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsByte(current, this.mIterator.nextByte());
        }
        return current;
    }

    @Override
    public OptionalByte reduce(ByteBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalByte.empty();
        }
        byte current = this.mIterator.nextByte();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsByte(current, this.mIterator.nextByte());
        }
        return OptionalByte.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjByteConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextByte());
        }
        return sink;
    }

    @Override
    public <E extends Throwable> ByteExceptional<E> exception(Class<E> cls) {
        return new ByteExceptionalImpl<E>(cls);
    }

    public byte sum() {
        return this.reduce((byte)0, (a, b) -> (byte)(a + b));
    }

    @Override
    public OptionalByte min() {
        return this.reduce((a, b) -> a < b ? a : b);
    }

    @Override
    public OptionalByte max() {
        return this.reduce((a, b) -> a < b ? b : a);
    }

    @Override
    public long count() {
        return this.mapToLong(i -> 1L).sum();
    }

    @Override
    public ByteStream sort() {
        return new ByteStreamImpl(new ByteChildIterator(() -> {
            byte[] array = this.toArray();
            Arrays.sort(array);
            return new ByteArrayIterator(array);
        }, Iterator::hasNext, ByteIterator::nextByte));
    }

    public OptionalDouble average() {
        long[] avg = this.collect(() -> new long[2], (ll, i) -> {
            ll[0] = ll[0] + 1L;
            ll[1] = ll[1] + (long)i;
        });
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public OptionalByte findFirst() {
        return this.mIterator.hasNext() ? OptionalByte.of(this.mIterator.nextByte()) : OptionalByte.empty();
    }

    @Override
    public boolean anyMatch(BytePredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextByte())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(BytePredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextByte())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(BytePredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextByte())) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] toArray() {
        byte[] tmp = new byte[16];
        int index = 0;
        while (this.mIterator.hasNext()) {
            byte c = this.mIterator.nextByte();
            if (index >= tmp.length) {
                byte[] newArray = new byte[tmp.length * 2];
                System.arraycopy(tmp, 0, newArray, 0, tmp.length);
                tmp = newArray;
            }
            tmp[index++] = c;
        }
        byte[] result = new byte[index];
        System.arraycopy(tmp, 0, result, 0, index);
        return result;
    }

    private class ByteExceptionalImpl<E extends Throwable>
    implements ByteExceptional<E> {
        private final Class<E> mExceptionClass;

        public ByteExceptionalImpl(Class<E> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        @Override
        public ByteStream mapException(ToByteFunction<E> mapper) {
            ByteStreamImpl.this.mIteratorWrapper.mapException(this.mExceptionClass, mapper);
            return ByteStreamImpl.this;
        }

        @Override
        public ByteStream consume(Consumer<E> consumer) {
            ByteStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, consumer);
            return ByteStreamImpl.this;
        }

        @Override
        public <I extends RuntimeException> ByteStream rethrow(Function<E, I> mapper) {
            ByteStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {
                throw (RuntimeException)mapper.apply(e);
            });
            return ByteStreamImpl.this;
        }

        @Override
        public ByteStream ignore() {
            ByteStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, e -> {});
            return ByteStreamImpl.this;
        }
    }

    private static class DummyIterator
    extends BaseIterator<Byte>
    implements ByteIterator {
        private byte mValue;
        private boolean mHasNext;

        public DummyIterator(byte value) {
            this(value, true);
        }

        public DummyIterator() {
            this(0, false);
        }

        private DummyIterator(byte value, boolean hasNext) {
            this.mValue = value;
            this.mHasNext = hasNext;
        }

        public DummyIterator newValue(byte value) {
            this.mValue = value;
            this.mHasNext = true;
            return this;
        }

        @Override
        public byte nextByte() {
            this.mHasNext = false;
            return this.mValue;
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public Byte next() {
            return this.nextByte();
        }
    }
}

