/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.stream;

import android.support.v4.util.LongSparseArray;
import android.util.SparseArray;
import com.github.wrdlbrnft.streamcompat.iterator.array.ArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.sparsearray.LongSparseArrayValueIterator;
import com.github.wrdlbrnft.streamcompat.iterator.sparsearray.SparseArrayValueIterator;
import com.github.wrdlbrnft.streamcompat.stream.ImmutableIterator;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat$$Lambda$3;
import com.github.wrdlbrnft.streamcompat.stream.StreamImpl;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.Iterator;
import java.util.Map;

public class StreamCompat {
    private static final Stream<?> EMPTY_STREAM = new StreamImpl(Utils.emptyIterator());

    public static <S> Stream<S> empty() {
        return EMPTY_STREAM;
    }

    @SafeVarargs
    public static <S> Stream<S> concat(Stream<S> ... streams) {
        ArrayIterator<Stream<S>> iterator = new ArrayIterator<Stream<S>>(streams);
        Iterator[] buffer = new Iterator[1];
        return new StreamImpl(new ChildIterator(StreamCompat$$Lambda$1.lambdaFactory$(buffer, iterator), StreamCompat$$Lambda$2.lambdaFactory$(), StreamCompat$$Lambda$3.lambdaFactory$()));
    }

    public static <T> Stream<T> ofValues(LongSparseArray<T> array) {
        LongSparseArrayValueIterator<T> iterator = new LongSparseArrayValueIterator<T>(array);
        return new StreamImpl<T>(iterator);
    }

    public static <T> Stream<T> ofValues(SparseArray<T> array) {
        SparseArrayValueIterator<T> iterator = new SparseArrayValueIterator<T>(array);
        return new StreamImpl<T>(iterator);
    }

    public static <K, V> Stream<V> ofValues(Map<K, V> map) {
        Iterator<V> iterator = map.values().iterator();
        return new StreamImpl<V>(iterator);
    }

    public static <K, V> Stream<K> ofKeys(Map<K, V> map) {
        Iterator<K> iterator = map.keySet().iterator();
        return new StreamImpl<K>(iterator);
    }

    public static <S> Stream<S> of(Iterable<S> collection) {
        ImmutableIterator<S> iterator = new ImmutableIterator<S>(collection.iterator());
        return new StreamImpl<S>(iterator);
    }

    public static <S> Stream<S> of(Iterator<S> iterator) {
        return new StreamImpl<S>(iterator);
    }

    @SafeVarargs
    public static <S> Stream<S> of(S ... items) {
        ArrayIterator<S> iterator = new ArrayIterator<S>(items);
        return new StreamImpl<S>(iterator);
    }

    private static /* synthetic */ Iterator lambda$concat$200(Iterator[] iteratorArray, Iterator iterator) {
        if (iteratorArray[0] == null || !iteratorArray[0].hasNext()) {
            if (!iterator.hasNext()) {
                return Utils.emptyIterator();
            }
            do {
                iteratorArray[0] = ((Stream)iterator.next()).iterator();
            } while (iterator.hasNext() && !iteratorArray[0].hasNext());
        }
        return iteratorArray[0];
    }

    static /* synthetic */ Iterator access$lambda$0(Iterator[] iteratorArray, Iterator iterator) {
        return StreamCompat.lambda$concat$200(iteratorArray, iterator);
    }
}

